/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.NormalizeScheme;
import oracle.dmt.dm4j.datasources.TXColumn;
import oracle.dmt.dm4j.wizard.state.transformsteps.NormalizeSchemeStat;

public class CDSNormalizeSchemeStat
extends NormalizeSchemeStat {
    private ComplexDataStructure m_sampledCDS;

    public CDSNormalizeSchemeStat(Connection connection, ComplexDataStructure complexDataStructure, String string, String string2, String string3, NormalizeScheme normalizeScheme) throws Exception {
        super(connection, complexDataStructure.getCaseSchema(), complexDataStructure.getCaseTable(), string, string2, false, string3, normalizeScheme);
        this.m_sampledCDS = complexDataStructure;
    }

    public CDSNormalizeSchemeStat(Connection connection, ComplexDataStructure complexDataStructure, String string, NormalizeScheme normalizeScheme) throws Exception {
        super(connection, complexDataStructure.getCaseSchema(), complexDataStructure.getCaseTable(), string, normalizeScheme);
        this.m_sampledCDS = complexDataStructure;
    }

    protected void createDataFrom2DDBTable() throws SQLException {
        block5: {
            String string = this.m_scheme.getComplexAttributeInfo();
            if (string == null || 0 == string.length()) {
                super.createDataFrom2DDBTable();
                return;
            }
            TXColumn tXColumn = this.m_sampledCDS.getTXColumn(string);
            if (tXColumn == null || !tXColumn.getIsSingleMetrics()) {
                return;
            }
            try {
                if (tXColumn.isNumeric()) {
                    this.processSingleMetricTxData(tXColumn, string);
                }
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) break block5;
                System.out.println(exception);
            }
        }
    }

    private void processSingleMetricTxData(TXColumn tXColumn, String string) throws SQLException, Exception {
        StringBuffer stringBuffer = new StringBuffer(1000);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        StringBuffer stringBuffer3 = new StringBuffer(100);
        StringBuffer stringBuffer4 = new StringBuffer(100);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object[] objectArray = new Object[]{"a", tXColumn.getValueColumn()};
            stringBuffer.append(MessageFormat.format("ROUND((SUM(POWER(\"{0}\",3)) / GREATEST(((COUNT(\"{1}\")-1)*POWER(STDDEV(\"{1}\"),3)),0.001)), 2) skewness,ROUND((SUM(POWER(\"{0}\",4)) / GREATEST(((COUNT(\"{1}\")-1)*POWER(STDDEV(\"{1}\"),4)),0.001)-3), 2) kurtosis,ROUND(AVG(\"{1}\"), 2) mean,ROUND(STDDEV(\"{1}\"), 2) std,ROUND(MIN(\"{1}\"), 2) min,ROUND(MAX(\"{1}\"), 2) max", objectArray));
            stringBuffer2.append(MessageFormat.format("\"{1}\", (\"{1}\"-(AVG(\"{1}\") OVER())) \"{0}\"", objectArray));
            Object[] objectArray2 = new Object[]{stringBuffer.toString(), stringBuffer2.toString()};
            stringBuffer3.append(MessageFormat.format("SELECT {0} FROM (SELECT {1} FROM r)", objectArray2));
            Object[] objectArray3 = new Object[]{CDSNormalizeSchemeStat.get2DSchemeFormula(tXColumn.getValueColumn(), this.m_scheme.getType(), this.m_scheme.getArg1(), this.m_scheme.getArg2()), tXColumn.getValueColumn(), tXColumn.getDataLocation(), stringBuffer3.toString()};
            stringBuffer4.append(MessageFormat.format("WITH r AS (SELECT {0} \"{1}\" FROM {2}) {3}", objectArray3));
            statement = this.m_conn.createStatement();
            resultSet = statement.executeQuery(stringBuffer4.toString());
            int n = 1;
            if (resultSet.next()) {
                String string2 = resultSet.getString(n++);
                String string3 = resultSet.getString(n++);
                String string4 = resultSet.getString(n++);
                String string5 = resultSet.getString(n++);
                String string6 = resultSet.getString(n++);
                String string7 = resultSet.getString(n++);
                this.m_scheme.setNewSkewness(Float.parseFloat(string2.trim()));
                this.m_scheme.setNewKurtosis(Float.parseFloat(string3.trim()));
                this.m_scheme.setNewMean(Float.parseFloat(string4.trim()));
                this.m_scheme.setNewStd(Float.parseFloat(string5.trim()));
                this.m_scheme.setNewMin(Float.parseFloat(string6.trim()));
                this.m_scheme.setNewMax(Float.parseFloat(string7.trim()));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }
}

