/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transforms;

import java.sql.Connection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.wizard.director.transforms.StratifiedSplitDirector;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dss.graph.Graph;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;

public class StratifiedSplitState
extends TransformWizardState {
    private boolean m_isTestView = true;
    private ComplexDataStructure m_testOutputDataDescriptor = null;
    private Graph m_graph = null;

    public StratifiedSplitState(BrowserContext browserContext, Connection connection) {
        super(browserContext, connection);
        this.m_director = new StratifiedSplitDirector(this);
        if (null == this.m_graph) {
            DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
            defaultErrorHandler.setDebugMode(0);
            this.m_graph = new Graph((ErrorHandler)defaultErrorHandler);
            this.m_graph.setLocale(Locale.getDefault());
            this.m_graph.setGraphType(17);
            this.m_graph.setAutoLayout(2);
            this.m_graph.getPFJ().setDisplay(this.m_graph.getPFJ().getLegendArea(), false);
        }
    }

    public ComplexDataStructure getTestOutputDataDescriptor() {
        return this.m_testOutputDataDescriptor;
    }

    public void setTestOutputDataDescriptor(ComplexDataStructure complexDataStructure) {
        this.m_testOutputDataDescriptor = complexDataStructure;
    }

    public void setNewTestTranformName(String string, String string2, boolean bl) {
        this.m_newSchemaName.setLength(0);
        this.m_newSchemaName.append(string);
        this.m_isTestView = bl;
    }

    protected void invalidateFurtherSteps(StepType stepType) throws Exception {
        Vector vector = this.getStepKeys();
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            StepType stepType2 = (StepType)iterator.next();
            WizardStepState wizardStepState = this.getStep(stepType2);
            if (stepType2 == stepType) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            if (StepType.DATA_STEP == stepType) {
                if (StepType.NAME_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    this.setStepState(wizardStepState, StepStateType.INCONSISTENT);
                } else if (StepType.SETTING_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    this.setStepState(wizardStepState, StepStateType.INCONSISTENT);
                }
            }
            if (StepType.FINISH_STEP != stepType2 || wizardStepState.getState() == StepStateType.UNLOADED) continue;
            this.setStepState(wizardStepState, StepStateType.INCONSISTENT);
        }
    }

    public Graph getGraph() {
        return this.m_graph;
    }

    public void exit() {
        super.exit();
        if (null != this.m_graph) {
            this.m_graph.cleanUp();
            this.m_graph = null;
        }
    }

    public void finish(Vector vector) throws Exception {
        super.finish(vector);
        if (null != this.m_graph) {
            this.m_graph.cleanUp();
            this.m_graph = null;
        }
    }

    public StratifiedSplitState(BrowserContext browserContext, Connection connection, boolean bl) {
        super(browserContext, connection);
        this.m_director = new StratifiedSplitDirector(this);
    }

    public void constructCodGen() throws Exception {
        if (this.m_director != null) {
            ((StratifiedSplitDirector)this.m_director).constructCodeGen();
        }
    }

    public Vector getTxSQL(String string) throws Exception {
        if (this.m_director != null) {
            return this.m_director.getTxSQL(string);
        }
        return null;
    }

    public Hashtable getCodeGenCreateBuildArguments() {
        if (this.m_director != null) {
            return this.m_director.getCodeGenCreateBuildArguments();
        }
        return null;
    }

    public Hashtable getCodeGenCreateTestArguments() {
        if (this.m_director != null) {
            return this.m_director.getCodeGenCreateTestArguments();
        }
        return null;
    }
}

