/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transforms;

import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.sql.SQLProcess;
import oracle.dmt.dm4j.wizard.director.transforms.CreateContextIndexDirector;
import oracle.dmt.dm4j.wizard.director.transforms.ExecuteTransformationProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CreateContextIndexDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TableNameState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ViewNameState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class CreateContextIndexState
extends TransformWizardState {
    private String m_newSchemaName = "";
    private String m_newTableName = "";
    private boolean m_isView = false;

    public CreateContextIndexState(BrowserContext browserContext, Connection connection) {
        super(browserContext, connection);
        this.m_director = new CreateContextIndexDirector(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(Vector vector) throws Exception {
        Connection connection = null;
        boolean bl = true;
        ExecuteTransformationProcess executeTransformationProcess = null;
        try {
            this.construct();
            connection = DM4JConnectionManager.getDbConnection();
            executeTransformationProcess = new ExecuteTransformationProcess(connection, this);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), executeTransformationProcess, true);
            executeTransformationProcess.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_DESC"));
            if (executeTransformationProcess.getException() != null) {
                this.doAbortCancel(executeTransformationProcess.getException());
            } else if (progressBar.hasUserCancelled()) {
            } else {
                Object object;
                String string = null;
                this.m_newSchemaName = DM4JConnectionManager.getUser();
                CreateContextIndexDataState createContextIndexDataState = (CreateContextIndexDataState)this.getStep(StepType.DATA_STEP);
                if (createContextIndexDataState.isNewTableRequired()) {
                    object = (TableNameState)this.getStep(StepType.NAME_STEP);
                    this.m_newTableName = ((ViewNameState)object).getViewName();
                } else {
                    this.m_newTableName = createContextIndexDataState.getSelectedTableName();
                }
                if (this.m_newSchemaName.length() > 0 && this.m_newTableName.length() > 0) {
                    this.setWizardFinished();
                    object = this.getBrowserContext();
                    if (((BrowserContext)object).getLaunchPoint() == LaunchPoint.ACTIVITY_GUIDE) {
                        return;
                    }
                    string = this.m_isView ? "VIEW" : "TABLE";
                    BrowserFrame.getMainFrame().findSchemaObject(this.m_newSchemaName, this.m_newTableName, string);
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishOLD(Vector vector) throws Exception {
        Connection connection = null;
        boolean bl = true;
        SQLProcess sQLProcess = null;
        try {
            this.construct();
            connection = DM4JConnectionManager.getDbConnection();
            sQLProcess = new SQLProcess(connection, this.getConstructResults());
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), sQLProcess, true);
            sQLProcess.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_DESC"));
            if (sQLProcess.getException() != null) {
                this.doAbortCancel(sQLProcess.getException());
            } else if (progressBar.hasUserCancelled()) {
            } else {
                Object object;
                String string = null;
                this.m_newSchemaName = DM4JConnectionManager.getUser();
                CreateContextIndexDataState createContextIndexDataState = (CreateContextIndexDataState)this.getStep(StepType.DATA_STEP);
                if (createContextIndexDataState.isNewTableRequired()) {
                    object = (TableNameState)this.getStep(StepType.NAME_STEP);
                    this.m_newTableName = ((ViewNameState)object).getViewName();
                } else {
                    this.m_newTableName = createContextIndexDataState.getSelectedTableName();
                }
                if (this.m_newSchemaName.length() > 0 && this.m_newTableName.length() > 0) {
                    this.setWizardFinished();
                    object = this.getBrowserContext();
                    if (((BrowserContext)object).getLaunchPoint() == LaunchPoint.ACTIVITY_GUIDE) {
                        return;
                    }
                    string = this.m_isView ? "VIEW" : "TABLE";
                    BrowserFrame.getMainFrame().findSchemaObject(this.m_newSchemaName, this.m_newTableName, string);
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void invalidateFurtherSteps(StepType stepType) throws Exception {
        Vector vector = this.getStepKeys();
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            StepType stepType2 = (StepType)iterator.next();
            WizardStepState wizardStepState = this.getStep(stepType2);
            if (stepType2 == stepType) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            if (StepType.DATA_STEP == stepType) {
                if (StepType.NAME_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    this.setStepState(wizardStepState, StepStateType.INCONSISTENT);
                } else if (StepType.SETTING_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    this.setStepState(wizardStepState, StepStateType.INCONSISTENT);
                }
            }
            if (StepType.FINISH_STEP != stepType2 || wizardStepState.getState() == StepStateType.UNLOADED) continue;
            this.setStepState(wizardStepState, StepStateType.INCONSISTENT);
        }
    }

    public void construct() throws Exception {
        if (this.m_director != null) {
            this.m_director.construct();
        }
    }

    public String getNewSchemaName() {
        return this.m_newSchemaName;
    }

    public String getNewTableName() {
        return this.m_newTableName;
    }

    public String getConstructResults() throws Exception {
        if (this.m_director != null) {
            return this.m_director.getConstructResults();
        }
        return "";
    }
}

