/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transforms;

import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import oracle.dmt.dm4j.ConnectionPersistenceInfo;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CodeGenDBDescriptor;
import oracle.dmt.dm4j.datasources.CodeGenDataSource;
import oracle.dmt.dm4j.wizard.director.transforms.CodeGenDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class CodeGenState
extends TransformWizardState {
    private CodeGenDBDescriptor m_dbDescriptor;
    private CodeGenDataSource m_cgDatasource;
    private StringBuffer m_packageBody;
    private StringBuffer m_packageSpec;
    private ArrayList m_packageTypes;
    private boolean showConnectionPage = true;
    private int m_launchingContext = -1;

    public void setShowConnectionPage(boolean bl) {
        this.showConnectionPage = bl;
    }

    public boolean isShowConnectionPage() {
        return this.showConnectionPage;
    }

    public void setPackageBody(String string) {
        this.m_packageBody = new StringBuffer(string);
    }

    public StringBuffer getPackageBody() {
        return this.m_packageBody;
    }

    public void setPackageSpec(String string) {
        this.m_packageSpec = new StringBuffer(string);
    }

    public StringBuffer getPackageSpec() {
        return this.m_packageSpec;
    }

    public void setPackageTypes(ArrayList arrayList) {
        this.m_packageTypes = arrayList;
    }

    public ArrayList getPackageTypes() {
        return this.m_packageTypes;
    }

    public void setDBDescriptor(CodeGenDBDescriptor codeGenDBDescriptor) {
        this.m_dbDescriptor = codeGenDBDescriptor;
    }

    public CodeGenDBDescriptor getDBDescriptor() {
        return this.m_dbDescriptor;
    }

    public boolean isPackageNameInUse(String string, String string2) {
        if (!this.isJDevOffline()) {
            return this.m_dbDescriptor.isPackageInSchema(string2);
        }
        return this.m_dbDescriptor.isPackageInSchema(string, string2);
    }

    public CodeGenState(BrowserContext browserContext, CodeGenDataSource codeGenDataSource, int n, Connection connection) throws Exception {
        super(browserContext, connection);
        this.m_launchingContext = n;
        if (codeGenDataSource == null) {
            throw new Exception("CodeGenDataSource can't be null");
        }
        this.m_director = new CodeGenDirector(this);
        this.m_cgDatasource = codeGenDataSource;
    }

    public CodeGenDataSource getDataSource() {
        return this.m_cgDatasource;
    }

    public boolean isDataMiner() {
        return this.m_launchingContext == 3;
    }

    public boolean isJDevOffline() {
        return !this.isDataMiner() && this.m_launchingContext == 0;
    }

    public Connection getSelectedDBConnection() throws Exception {
        ConnectionPersistenceInfo connectionPersistenceInfo = this.m_cgDatasource.getConnectionInfo(this.m_cgDatasource.getSelectedConnectionName());
        return this.refreshConnection(connectionPersistenceInfo);
    }

    public Connection getContextConnection() throws Exception {
        if (this.isJDevOffline()) {
            return this.getSelectedDBConnection();
        }
        if (this.isDataMiner()) {
            return DM4JConnectionManager.getDbConnection();
        }
        ConnectionPersistenceInfo connectionPersistenceInfo = this.m_cgDatasource.getConnectionInfo(this.m_cgDatasource.getContextConnName());
        return this.refreshConnection(connectionPersistenceInfo);
    }

    private Connection refreshConnection(ConnectionPersistenceInfo connectionPersistenceInfo) throws Exception {
        if (this.m_cgDatasource == null) {
            return null;
        }
        String string = connectionPersistenceInfo.getSid();
        boolean bl = false;
        if (string == null || 0 == string.length()) {
            string = connectionPersistenceInfo.getServiceName();
            bl = true;
        }
        DM4JConnectionManager.close();
        DM4JConnectionManager.initialize(connectionPersistenceInfo.getHost(), connectionPersistenceInfo.getPort(), string, bl, connectionPersistenceInfo.getUser(), connectionPersistenceInfo.getMigratedPassword().toCharArray(), Locale.getDefault());
        return DM4JConnectionManager.getDbConnection();
    }

    public void exit() {
        super.exit();
        try {
            if (!this.isDataMiner()) {
                DM4JConnectionManager.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(Vector vector) throws Exception {
        Connection connection = null;
        try {
            connection = this.getContextConnection();
            ((CodeGenDirector)this.m_director).setConnection(connection);
            ProgressBar progressBar = new ProgressBar((Component)((Object)this.getWizard()), ResourceUtilities.getUILabel("CG_FINISH_DIALOG_TITLE"), (CodeGenDirector)this.m_director, true);
            ((CodeGenDirector)this.m_director).setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("CG_FINISH_DIALOG_TITLE"), ResourceUtilities.getUILabel("CG_FINISH_DIALOG_DESC"));
            progressBar.waitUntilDone();
            if (((CodeGenDirector)this.m_director).getException() != null) {
                this.doAbortCancel(((CodeGenDirector)this.m_director).getException());
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void construct() throws Exception {
        if (this.m_director != null) {
            this.m_director.construct();
        }
    }

    public void invalidateTargetActivityStep() throws Exception {
        WizardStepState wizardStepState = this.getStep(StepType.SETTING_STEP_2);
        super.setStepState(wizardStepState, StepStateType.UNLOADED);
    }

    public void invalidateResultsStep() throws Exception {
        WizardStepState wizardStepState = this.getStep(StepType.SETTING_STEP);
        super.setStepState(wizardStepState, StepStateType.UNLOADED);
    }

    public static interface LAUNCHING_CONTEXT {
        public static final int JDEVELEOPER_OFFLINE = 0;
        public static final int JDEVELEOPER_ONLINE = 1;
        public static final int DATA_MINER = 3;
    }
}

