/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Iterator;
import java.util.Vector;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.director.minings.MiningLoader;
import oracle.dmt.dm4j.wizard.director.minings.TargetValueExtractProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TargetValueStateError;

public class TargetValueState
extends WizardStepState {
    protected StringBuffer m_selectedTargetValue = new StringBuffer(0);
    protected TargetValueDataSource m_targetValues = null;
    protected TargetValueCostMatrixDataSource m_targetValueCostMatrix = null;
    CheckForDataSourceChanges m_dataSourcelistener;
    protected boolean m_weightedScoreIndicator = false;
    protected StringBuffer m_weight = new StringBuffer(0);
    protected boolean m_falsePositiveIndicator = false;

    public TargetValueState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void setSelectedTargetValue(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_selectedTargetValue.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_selectedTargetValue = new StringBuffer(string);
        }
    }

    public String getSelectedTargetValue() {
        return this.m_selectedTargetValue.toString();
    }

    public boolean refreshTargetValuesFromDB() {
        boolean bl = true;
        TargetValueExtractProcess targetValueExtractProcess = null;
        try {
            targetValueExtractProcess = new TargetValueExtractProcess((DataState)this.getparentWizardState().getStep(StepType.DATA_STEP));
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("TARGET_VALUE_EXTRACT_DIALOG_TITLE"), targetValueExtractProcess, true);
            targetValueExtractProcess.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("TARGET_VALUE_EXTRACT_DIALOG_TITLE"), ResourceUtilities.getUILabel("TARGET_VALUE_EXTRACT_DESCRIPTION"));
            if (targetValueExtractProcess.getException() != null) {
                this.getparentWizardState().doAbortCancel(targetValueExtractProcess.getException());
            } else if (progressBar.hasUserCancelled()) {
                bl = false;
                this.setState(StepStateType.DIRTY);
                return bl;
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
        return bl;
    }

    protected void setDataUsageListener(boolean bl) {
        this.m_dataSourcelistener = new CheckForDataSourceChanges(bl);
        this.getTargetValuesDataSource().addModelListener((TwoDModelListener)this.m_dataSourcelistener);
    }

    public void setWeightedScoreIndicator(boolean bl) {
        if (!this.m_weightedScoreIndicator == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_weightedScoreIndicator = bl;
        }
    }

    public boolean getWeightedScoreIndicator() {
        return this.m_weightedScoreIndicator;
    }

    public boolean getFalsePositiveIndicator() {
        return this.m_falsePositiveIndicator;
    }

    public void setFalsePositiveIndicator(boolean bl) {
        if (!this.m_falsePositiveIndicator == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_falsePositiveIndicator = bl;
        }
    }

    public String getWeight() {
        return this.m_weight.toString();
    }

    public float getWeightasFloat() {
        return Float.parseFloat(this.m_weight.toString());
    }

    public void setWeight(String string) {
        String string2;
        if (this.m_weight != null && !string.equals(string2 = this.m_weight.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_weight = new StringBuffer(string.trim());
        }
    }

    protected void refreshOld() throws Exception {
        this.loadOld();
    }

    protected void refreshNew() throws Exception {
        this.loadNew();
    }

    protected void loadOld() throws Exception {
        this.loadDefaults();
        MiningLoader miningLoader = ((WizardState)this.getparentWizardState()).getMiningLoader();
        miningLoader.buildTargetValue(this);
        this.setDataUsageListener(false);
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void loadNew() throws Exception {
        this.loadDefaults();
        this.setDataUsageListener(true);
    }

    protected void loadDefaults() {
        Vector vector = this.getTargetValues();
        if (!vector.isEmpty()) {
            this.setSelectedTargetValue((String)vector.get(0));
        }
        this.setWeightedScoreIndicator(false);
        this.setFalsePositiveIndicator(false);
        this.setWeight("1.0");
    }

    public void validate(Vector vector) throws Exception {
        this.validateCostMatrix(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    private Vector validateCostMatrix() throws Exception {
        Vector vector = new Vector();
        this.validateCostMatrix(vector);
        return vector;
    }

    private void validateCostMatrix(Vector vector) throws Exception {
    }

    private void validateTargetValue(Vector vector) throws Exception {
        String string = this.m_selectedTargetValue.toString();
        if (!this.isTargetValueNameValid(string)) {
            String[] stringArray = new String[]{string};
            vector.add(new StateValidation((ValidationType)TargetValueStateError.TARGET_VALUE_NOT_IN_DATA, stringArray));
        }
    }

    public void setTargetValues(TargetValueDataSource targetValueDataSource) {
        this.m_targetValues = targetValueDataSource;
    }

    public TargetValueDataSource getTargetValuesDataSource() {
        return this.m_targetValues;
    }

    public void setTargetValueCostMatrix(TargetValueCostMatrixDataSource targetValueCostMatrixDataSource) {
        this.m_targetValueCostMatrix = targetValueCostMatrixDataSource;
    }

    public TargetValueCostMatrixDataSource getTargetValueCostMatrixDataSource() {
        return this.m_targetValueCostMatrix;
    }

    public Vector getTargetValues() {
        this.m_targetValues = this.getTargetValuesDataSource();
        return this.m_targetValues.getAttributes(0);
    }

    public boolean isTargetValueNameValid(String string) {
        Iterator iterator = this.getTargetValues().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    private class CheckForDataSourceChanges
    extends TwoDModelAdapter {
        private boolean m_newWizard;

        public CheckForDataSourceChanges(boolean bl) {
            this.m_newWizard = this.m_newWizard;
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            if (this.m_newWizard) {
                if (TargetValueState.this.getState() == StepStateType.VALIDATED) {
                    TargetValueState.this.setState(StepStateType.DIRTY);
                }
            } else if (TargetValueState.this.getState() == StepStateType.VALIDATED) {
                TargetValueState.this.setState(StepStateType.INCONSISTENT);
            }
        }
    }
}

