/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import javax.datamining.algorithm.svm.KernelFunction;
import oracle.dmt.dm4j.activity.steps.SVMBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.SVMCBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.SVMRBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AlgorithmSettingState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.SupportVectorMachineAlgorithmStateError;

public class SupportVectorMachineAlgorithmState
extends AlgorithmSettingState {
    protected KernelFunction m_kernelFunction;
    protected KernelFunction m_defaultKernelFunction;
    protected Double m_tolerance;
    protected Double m_defaultTolerance;
    protected Double m_std;
    protected Double m_defaultStd;
    protected Double m_complexityFactor;
    protected Double m_defaultComplexityFactor;
    protected Integer m_kernelCacheSize;
    protected Integer m_defaultKernelCacheSize;
    protected Double m_epsilon;
    protected Double m_defaultEpsilon;
    protected boolean m_stdSelected;
    protected boolean m_defaultStdSelected;
    protected boolean m_complexityFactorSelected;
    protected boolean m_defaultComplexityFactorSelected;
    protected boolean m_epsilonSelected;
    protected boolean m_defaultEpsilonSelected;
    protected boolean m_isRegression = false;
    protected boolean m_learningEnabled;
    protected boolean m_defaultLearningEnabled;
    private SVMBuildStepOptions m_options = null;

    public SupportVectorMachineAlgorithmState(WizardStepState wizardStepState, KernelFunction kernelFunction, Double d, Double d2, Double d3, Integer n, Double d4, boolean bl) {
        super(wizardStepState);
        this.initialize(kernelFunction, d, d2, d3, n, d4, bl);
    }

    public SupportVectorMachineAlgorithmState(KernelFunction kernelFunction, Double d, Double d2, Double d3, Integer n, Double d4, boolean bl) {
        this.initialize(kernelFunction, d, d2, d3, n, d4, bl);
    }

    public SupportVectorMachineAlgorithmState(WizardStepState wizardStepState, KernelFunction kernelFunction, Double d, Double d2, Double d3, Integer n, boolean bl) {
        this(wizardStepState, kernelFunction, d, d2, d3, n, null, bl);
    }

    public SupportVectorMachineAlgorithmState(KernelFunction kernelFunction, Double d, Double d2, Double d3, Integer n, boolean bl) {
        this(kernelFunction, d, d2, d3, n, null, bl);
    }

    private void initialize(KernelFunction kernelFunction, Double d, Double d2, Double d3, Integer n, Double d4, boolean bl) {
        BrowserContext browserContext = this.m_wizardStepState.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof SVMBuildStepOptions) {
            this.m_options = (SVMBuildStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_kernelFunction = this.m_options.getKernelFunction();
            this.m_tolerance = this.m_options.getTolerance();
            this.m_kernelCacheSize = this.m_options.getKernelCacheSize();
            this.m_std = this.m_options.getStd();
            this.m_learningEnabled = this.m_options.isLearningEnabled();
            if (this.m_options instanceof SVMCBuildStepOptions) {
                this.m_complexityFactor = ((SVMCBuildStepOptions)this.m_options).getComplexityFactor();
            } else if (this.m_options instanceof SVMRBuildStepOptions) {
                this.m_complexityFactor = ((SVMRBuildStepOptions)this.m_options).getComplexityFactor();
                this.m_epsilon = ((SVMRBuildStepOptions)this.m_options).getEpsilon();
                this.m_epsilonSelected = this.m_epsilon != null;
                this.m_isRegression = true;
            }
            this.m_stdSelected = this.m_std != null;
            this.m_complexityFactorSelected = this.m_complexityFactor != null;
        } else {
            this.m_kernelFunction = kernelFunction;
            this.m_tolerance = d;
            this.m_kernelCacheSize = n;
            this.m_std = d2;
            this.m_learningEnabled = bl;
            this.m_complexityFactor = d3;
            boolean bl2 = this.m_isRegression = d4 != null;
            if (this.m_isRegression) {
                this.m_epsilon = d4;
                this.m_epsilonSelected = d4.compareTo(new Double(0.0)) != 0;
            }
            this.m_stdSelected = d2.compareTo(new Double(0.0)) != 0;
            this.m_complexityFactorSelected = d3.compareTo(new Double(0.0)) != 0;
        }
        this.m_defaultKernelFunction = kernelFunction;
        this.m_defaultTolerance = d;
        this.m_defaultKernelCacheSize = n;
        this.m_defaultStdSelected = this.m_stdSelected;
        this.m_defaultStd = d2;
        this.m_defaultLearningEnabled = bl;
        this.m_defaultComplexityFactorSelected = this.m_complexityFactorSelected;
        this.m_defaultComplexityFactor = d3;
        this.m_defaultEpsilon = d4;
        this.m_defaultEpsilonSelected = this.m_epsilonSelected;
    }

    public boolean isRegression() {
        return this.m_isRegression;
    }

    public void setKernelFunction(KernelFunction kernelFunction) {
        if (this.m_kernelFunction.compareTo(kernelFunction) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_kernelFunction = kernelFunction;
            if (this.m_options != null) {
                this.m_options.setKernelFunction(kernelFunction);
            }
        }
    }

    public KernelFunction getKernelFunction() {
        return this.m_kernelFunction;
    }

    public void setTolerance(Double d) {
        if (this.m_tolerance == null || d == null || this.m_tolerance.compareTo(d) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_tolerance = d;
            if (this.m_options != null) {
                this.m_options.setTolerance(d);
            }
        }
    }

    public Double getTolerance() {
        return this.m_tolerance;
    }

    public void setEpsilon(Double d) {
        if (this.m_isRegression && (this.m_epsilon == null || d == null || this.m_epsilon.compareTo(d) != 0)) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_epsilon = d;
            if (this.m_options != null) {
                ((SVMRBuildStepOptions)this.m_options).setEpsilon(d);
            }
        }
    }

    public Double getEpsilon() {
        return this.m_isRegression ? this.m_epsilon : null;
    }

    public boolean getEpsilonSelected() {
        return this.m_isRegression ? this.m_epsilonSelected : false;
    }

    public boolean isEpsilonSelected() {
        return this.m_isRegression ? this.m_epsilonSelected : false;
    }

    public void setEpsilonSelected(boolean bl) {
        if (this.m_isRegression && !this.m_epsilonSelected == bl) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_epsilonSelected = bl;
            if (this.m_options != null && !bl) {
                ((SVMRBuildStepOptions)this.m_options).setEpsilon(null);
            }
        }
    }

    public void setKernelCacheSize(Integer n) {
        if (this.m_kernelCacheSize == null || n == null || this.m_kernelCacheSize.compareTo(n) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_kernelCacheSize = n;
            if (this.m_options != null) {
                ((SVMRBuildStepOptions)this.m_options).setKernelCacheSize(n);
            }
        }
    }

    public Integer getKernelCacheSize() {
        return this.m_kernelCacheSize;
    }

    public void setStd(Double d) {
        if (this.m_std == null || d == null || this.m_std.compareTo(d) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_std = d;
            if (this.m_options != null) {
                this.m_options.setStd(d);
            }
        }
    }

    public Double getStd() {
        return this.m_std;
    }

    public boolean getStdSelected() {
        return this.m_stdSelected;
    }

    public boolean isStdSelected() {
        return this.m_stdSelected;
    }

    public void setStdSelected(boolean bl) {
        if (!this.m_stdSelected == bl) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_stdSelected = bl;
            if (this.m_options != null && !bl) {
                this.m_options.setStd(null);
            }
        }
    }

    public void setComplexityFactor(Double d) {
        if (this.m_complexityFactor == null || d == null || this.m_complexityFactor.compareTo(d) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_complexityFactor = d;
            if (this.m_options != null) {
                if (this.m_options instanceof SVMCBuildStepOptions) {
                    ((SVMCBuildStepOptions)this.m_options).setComplexityFactor(d);
                } else if (this.m_options instanceof SVMRBuildStepOptions) {
                    ((SVMRBuildStepOptions)this.m_options).setComplexityFactor(d);
                }
            }
        }
    }

    public Double getComplexityFactor() {
        return this.m_complexityFactor;
    }

    public boolean getComplexityFactorSelected() {
        return this.m_complexityFactorSelected;
    }

    public boolean isComplexityFactorSelected() {
        return this.m_complexityFactorSelected;
    }

    public void setComplexityFactorSelected(boolean bl) {
        if (!this.m_complexityFactorSelected == bl) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_complexityFactorSelected = bl;
            if (this.m_options != null) {
                if (this.m_options instanceof SVMCBuildStepOptions && !bl) {
                    ((SVMCBuildStepOptions)this.m_options).setComplexityFactor(null);
                } else if (this.m_options instanceof SVMRBuildStepOptions && !bl) {
                    ((SVMRBuildStepOptions)this.m_options).setComplexityFactor(null);
                }
            }
        }
    }

    public Vector getAvailableKernelFunctionTypeNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("System Determined");
        vector.add("Linear");
        vector.add("Gaussian");
        return vector;
    }

    public boolean getLearningEnabled() {
        return this.m_learningEnabled;
    }

    public boolean isLearningEnabled() {
        return this.m_learningEnabled;
    }

    public void setLearningEnabled(boolean bl) {
        if (!this.m_learningEnabled == bl) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_learningEnabled = bl;
            if (this.m_options != null) {
                this.m_options.setLearningEnabled(bl);
            }
        }
    }

    protected void validateStd(Vector vector) throws Exception {
        if (this.m_stdSelected) {
            Double d = new Double(0.0);
            Double d2 = new Double(Double.MAX_VALUE);
            if (this.m_std == null) {
                String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_SVM_STD")};
                vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_STD_EMPTY, string, stringArray));
                return;
            }
            if (this.m_std.compareTo(d) <= 0 || this.m_std.compareTo(d2) > 0) {
                vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_STD_INVALID));
            }
        }
    }

    protected void validateComplexityFactor(Vector vector) throws Exception {
        if (this.m_complexityFactorSelected) {
            Double d = new Double(0.0);
            Double d2 = new Double(Double.MAX_VALUE);
            if (this.m_complexityFactor == null) {
                String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_SVM_COMPLEXITY_FACTOR")};
                vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_COMPLEXITY_FACTOR_EMPTY, string, stringArray));
                return;
            }
            if (this.m_complexityFactor.compareTo(d) <= 0 || this.m_complexityFactor.compareTo(d2) > 0) {
                vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_COMPLEXITY_FACTOR_INVALID));
            }
        }
    }

    protected void validateTolerance(Vector vector) throws Exception {
        Double d = new Double(0.0);
        Double d2 = new Double(0.1);
        if (this.m_tolerance == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_SVM_TOLERANCE")};
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_TOLERANCE_EMPTY, string, stringArray));
            return;
        }
        if (this.m_tolerance.compareTo(d) <= 0 || this.m_tolerance.compareTo(d2) > 0) {
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_TOLERANCE_INVALID));
        }
    }

    protected void validateEpsilon(Vector vector) throws Exception {
        if (this.m_epsilonSelected) {
            Double d = new Double(0.0);
            Double d2 = new Double(Double.MAX_VALUE);
            if (this.m_epsilon == null) {
                String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_SVM_EPSILON")};
                vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_EPSILON_EMPTY, string, stringArray));
                return;
            }
            if (this.m_epsilon.compareTo(d) <= 0 || this.m_epsilon.compareTo(d2) > 0) {
                vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_EPSILON_INVALID));
            }
        }
    }

    protected void validateKernelCacheSize(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.m_kernelCacheSize == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_SVM_KERNEL_CACHE_SIZE")};
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_KERNEL_CACHE_SIZE_EMPTY, string, stringArray));
            return;
        }
        if (this.m_kernelCacheSize.compareTo(n) <= 0 || this.m_kernelCacheSize.compareTo(n2) > 0) {
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_KERNEL_CACHE_SIZE_INVALID));
        }
    }

    public void validate(Vector vector) throws Exception {
        if (this.m_kernelFunction.compareTo(KernelFunction.kGaussian) == 0) {
            this.validateStd(vector);
            this.validateKernelCacheSize(vector);
        }
        this.validateComplexityFactor(vector);
        this.validateTolerance(vector);
        this.validateEpsilon(vector);
    }

    public Vector validate() throws Exception {
        Vector vector = new Vector();
        this.validate(vector);
        return vector;
    }

    public void restoreSettingsToDefault() {
        this.setKernelFunction(this.m_defaultKernelFunction);
        this.setTolerance(this.m_defaultTolerance);
        this.setStd(this.m_defaultStd);
        this.setComplexityFactor(this.m_defaultComplexityFactor);
        this.setKernelCacheSize(this.m_defaultKernelCacheSize);
        this.setStdSelected(this.m_defaultStdSelected);
        this.setComplexityFactorSelected(this.m_defaultComplexityFactorSelected);
        this.setLearningEnabled(this.m_defaultLearningEnabled);
        if (this.m_isRegression) {
            this.setEpsilon(this.m_defaultEpsilon);
        }
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
    }
}

