/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.NMFBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AlgorithmSettingState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FeatureExtractionAlgorithmState;

public class NMFAlgorithmState
extends AlgorithmSettingState {
    private AbstractActivity m_activity = null;
    private NMFBuildStepOptions m_options = null;
    private NMFBuildStepOptions m_savedOptions = null;

    public NMFAlgorithmState(WizardStepState wizardStepState) {
        super(wizardStepState);
        this.m_wizardStepState = (FeatureExtractionAlgorithmState)wizardStepState;
        this.initialize();
    }

    public NMFAlgorithmState() {
        this.initialize();
    }

    private void initialize() {
        BrowserContext browserContext = this.m_wizardStepState.getparentWizardState().getBrowserContext();
        this.m_activity = browserContext.getActivity();
        this.m_options = (NMFBuildStepOptions)browserContext.getOptions();
        this.m_savedOptions = new NMFBuildStepOptions(this.m_options);
    }

    public void setNumberofFeatures(Integer n) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setNumOfFeatures(n);
    }

    public Integer getNumberofFeatures() {
        return this.m_options.getNumOfFeatures();
    }

    public boolean getNumberofFeaturesSelected() {
        return this.m_options.getNumberofFeaturesSelected();
    }

    public boolean isNumberofFeaturesSelected() {
        return this.m_options.isNumberofFeaturesSelected();
    }

    public void setNumberofFeaturesSelected(boolean bl) {
        this.m_options.setNumberofFeaturesSelected(bl);
    }

    public boolean getRandomSeedSelected() {
        return this.m_options.getRandomSeedSelected();
    }

    public boolean isRandomSeedSelected() {
        return this.m_options.isRandomSeedSelected();
    }

    public void setRandomSeedSelected(boolean bl) {
        this.m_options.setRandomSeedSelected(bl);
    }

    public void setRandomSeed(Long l) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setRandomSeed(l);
    }

    public Long getRandomSeed() {
        return this.m_options.getRandomSeed();
    }

    public void setMinConvergenceTolerance(Double d) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setMinConvergenceTolerance(d);
    }

    public Double getMinConvergenceTolerance() {
        return this.m_options.getMinConvergenceTolerance();
    }

    public void setMaxNumberOfIterations(Integer n) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setMaxNumberOfIterations(n);
    }

    public Integer getMaxNumberOfIterations() {
        return this.m_options.getMaxNumberOfIterations();
    }

    protected void validateNumberofFeatures(Vector vector) throws Exception {
        this.m_options.validateNumberofFeatures(this.m_activity, vector);
    }

    protected void validateMinConvergenceTolerance(Vector vector) throws Exception {
        this.m_options.validateMinConvergenceTolerance(vector);
    }

    protected void validateMaxNumberOfIterations(Vector vector) throws Exception {
        this.m_options.validateMaxNumberOfIterations(vector);
    }

    protected void validateRandomSeed(Vector vector) throws Exception {
        this.m_options.validateRandomSeed(vector);
    }

    public void validate(Vector vector) throws Exception {
        this.m_options.validate(this.m_activity, vector);
    }

    public Vector validate() throws Exception {
        Vector vector = new Vector();
        this.validate(vector);
        return vector;
    }

    public void restoreSettingsToDefault() {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.restoreToDefaultSettings(this.m_activity);
    }

    public void restoreSettings() {
        if (this.m_wizardStepState.getState() == StepStateType.DIRTY) {
            this.m_wizardStepState.setState(StepStateType.VALIDATED);
        }
        this.m_options.restoreSettings(this.m_savedOptions);
    }
}

