/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.sql.SQLException;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTestDataState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.NameStateError;

public class ModelTestNameState
extends WizardStepState {
    private final int NAME_LENGTH_MAX = 25;
    private final String NAME_SUFFIX = "";
    protected StringBuffer m_modelTestName = new StringBuffer(0);

    public ModelTestNameState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public String getModelTestName() {
        return this.m_modelTestName.toString();
    }

    public void setModelTestName(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_modelTestName.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_modelTestName = new StringBuffer(string);
            }
        }
    }

    protected void loadOld() throws Exception {
        this.loadNew();
    }

    protected void loadNew() throws Exception {
        this.loadDefaultModelTestName();
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void refreshOld() throws Exception {
    }

    protected void refreshNew() throws Exception {
    }

    public void validate(Vector vector) throws Exception {
        this.validateModelTestName(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    private void validateModelTestName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        boolean bl = DM4JStringUtils.isDoubleQuotedString(this.m_modelTestName.toString());
        String string2 = this.m_modelTestName.toString();
        if (bl) {
            string2 = DM4JStringUtils.trimDoubleQuotes(string2);
        }
        if (string2.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("MODEL_TEST_NAME")};
            vector.add(new StateValidation(NameStateError.MODEL_TEST_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(string2, 25)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("MODEL_TEST_NAME"), Integer.toString(25)};
            vector.add(new StateValidation(NameStateError.MODEL_TEST_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (!ValidationUtil.isModelTestNameUnique(string2, ((WizardState)this.getparentWizardState()).getConnection())) {
            vector.add(new StateValidation(NameStateError.MODEL_TEST_NAME_DUPLICATE));
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string2)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
    }

    protected void loadDefaultModelTestName() throws SQLException {
        String string;
        ModelTestDataState modelTestDataState = (ModelTestDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        String string2 = "DM4J$" + modelTestDataState.getSelectedTableName();
        int n = 13;
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        String string3 = null;
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            string3 = "DM4J$" + browserContext.getActivity().getCaseTable().getName();
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (ValidationUtil.isValidNonQuotedDBObjectName(string = ValidationUtil.createUniqueJDMObjectName(string3 = string3.length() > n ? string3.substring(0, n) : string3, ((WizardState)this.getparentWizardState()).getConnection(), "_TM"))) {
            this.setModelTestName(string);
        } else {
            this.setModelTestName(DM4JStringUtils.addDoubleQuotes(string));
        }
    }
}

