/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.text.NumberFormat;
import java.util.Vector;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.dmt.dm4j.activity.steps.ABNBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.activity.steps.DecisionTreeBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.GLMCBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.NaiveBayesBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.SVMCBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.datasources.TargetValueWeightDataSource;
import oracle.dmt.dm4j.wizard.director.minings.ClassificationModelBuildLoader;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetValueState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TargetValueStateError;

public class ModelTargetValueState
extends TargetValueState {
    private static int SCALE_FACTOR = 1000000;
    private boolean m_priorsIndicator = false;
    private boolean m_targetWeightsIndicator = false;
    private boolean m_weightedScoreEnable = false;
    private boolean m_priorsEnable = false;
    private boolean m_targetWeightsEnable = false;
    protected AbstractStepOptions m_options = null;

    public ModelTargetValueState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            this.m_options = browserContext.getOptions();
        }
    }

    public void setPriorsIndicator(boolean bl) {
        if (!this.m_priorsIndicator == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_priorsIndicator = bl;
        }
    }

    public void setTargetWeightsIndicator(boolean bl) {
        if (!this.m_targetWeightsIndicator == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_targetWeightsIndicator = bl;
        }
    }

    public boolean getPriorsIndicator() {
        return this.m_priorsIndicator;
    }

    public boolean getTargetWeightsIndicator() {
        return this.m_targetWeightsIndicator;
    }

    protected void refreshOld() throws Exception {
        this.loadOld();
    }

    protected void refreshNew() throws Exception {
        super.refreshNew();
        this.loadNew();
    }

    protected void loadOld() throws Exception {
        super.loadOld();
        this.loadDefaults();
        ClassificationModelBuildLoader classificationModelBuildLoader = (ClassificationModelBuildLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        classificationModelBuildLoader.buildCostMatrix(this);
        classificationModelBuildLoader.buildPriors(this);
        this.setDataUsageListener(false);
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        super.postValidate(vector);
        return bl;
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        bl = super.preload();
        return bl;
    }

    protected void loadNew() throws Exception {
        super.loadNew();
        this.loadDefaults();
        this.setDataUsageListener(true);
    }

    public void setWeightedScoreEnabled(boolean bl) {
        if (this.m_weightedScoreEnable != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_weightedScoreEnable = bl;
        }
    }

    public void setPriorsEnabled(boolean bl) {
        if (this.m_priorsEnable != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_priorsEnable = bl;
        }
    }

    public void setTargetWeightsEnabled(boolean bl) {
        if (this.m_targetWeightsEnable != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_targetWeightsEnable = bl;
        }
    }

    public boolean isWeightedScoreEnabled() {
        return this.m_weightedScoreEnable;
    }

    public boolean isPriorsEnabled() {
        return this.m_priorsEnable;
    }

    public boolean isTargetWeightsEnabled() {
        return this.m_targetWeightsEnable;
    }

    protected void loadDefaults() {
        super.loadDefaults();
        if (this.m_options != null) {
            if (this.m_options instanceof DecisionTreeBuildStepOptions) {
                DecisionTreeBuildStepOptions decisionTreeBuildStepOptions = (DecisionTreeBuildStepOptions)this.m_options;
                this.setWeightedScoreIndicator(decisionTreeBuildStepOptions.isCurWeightedScore());
                this.setWeightedScoreEnabled(decisionTreeBuildStepOptions.isCurWeightedScore());
                this.setSelectedTargetValue(decisionTreeBuildStepOptions.getCurTargetValue());
            } else if (this.m_options instanceof SVMCBuildStepOptions) {
                SVMCBuildStepOptions sVMCBuildStepOptions = (SVMCBuildStepOptions)this.m_options;
                this.setTargetWeightsIndicator(sVMCBuildStepOptions.isCurTargetWeighted());
                this.setTargetWeightsEnabled(sVMCBuildStepOptions.isCurTargetWeighted());
                this.setSelectedTargetValue(sVMCBuildStepOptions.getCurTargetValue());
            } else if (this.m_options instanceof GLMCBuildStepOptions) {
                GLMCBuildStepOptions gLMCBuildStepOptions = (GLMCBuildStepOptions)this.m_options;
                this.setTargetWeightsIndicator(gLMCBuildStepOptions.isCurTargetWeighted());
                this.setTargetWeightsEnabled(gLMCBuildStepOptions.isCurTargetWeighted());
                this.setSelectedTargetValue(gLMCBuildStepOptions.getCurTargetValue());
            } else if (this.m_options instanceof ABNBuildStepOptions) {
                ABNBuildStepOptions aBNBuildStepOptions = (ABNBuildStepOptions)this.m_options;
                this.setPriorsIndicator(true);
                this.setPriorsEnabled(true);
                this.setSelectedTargetValue(aBNBuildStepOptions.getCurTargetValue());
            } else if (this.m_options instanceof NaiveBayesBuildStepOptions) {
                NaiveBayesBuildStepOptions naiveBayesBuildStepOptions = (NaiveBayesBuildStepOptions)this.m_options;
                this.setPriorsIndicator(true);
                this.setPriorsEnabled(true);
                this.setSelectedTargetValue(naiveBayesBuildStepOptions.getCurTargetValue());
            }
        } else {
            boolean bl = false;
            boolean bl2 = false;
            WizardStepState wizardStepState = (WizardStepState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            if (wizardStepState instanceof ClassificationAlgorithmState) {
                ClassificationAlgorithmState classificationAlgorithmState = (ClassificationAlgorithmState)wizardStepState;
                bl = classificationAlgorithmState.isSupportVectorMachineSelected();
                bl2 = classificationAlgorithmState.isDecisionTreeSelected();
            }
            this.setWeightedScoreEnabled(bl2);
            this.setPriorsEnabled(!bl2 && !bl);
            this.setTargetWeightsEnabled(bl);
        }
    }

    public Vector validatePriors() throws Exception {
        Vector vector = new Vector();
        this.validatePriors(vector);
        return vector;
    }

    private void validatePriors(Vector vector) throws Exception {
        int n;
        if (!this.getPriorsIndicator()) {
            return;
        }
        TargetValueDataSource targetValueDataSource = this.getTargetValuesDataSource();
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < targetValueDataSource.getRowCount(); ++n) {
            Object object = targetValueDataSource.getData(3, n);
            if (!(object instanceof Double)) {
                String string = (String)targetValueDataSource.getData(0, n);
                String string2 = ResourceUtilities.getstateExceptionMessage("PRIORS_HAS_ZERO_ENTRY");
                String[] stringArray = new String[]{string};
                vector.add(new StateValidation(TargetValueStateError.PRIORS_HAS_ZERO_ENTRY, string2, stringArray));
                return;
            }
            d = ((Double)targetValueDataSource.getData(3, n)).floatValue();
            d2 += d;
            if (!(d2 <= 0.0)) continue;
            String string = (String)targetValueDataSource.getData(0, n);
            String string3 = ResourceUtilities.getstateExceptionMessage("PRIORS_HAS_ZERO_ENTRY");
            String[] stringArray = new String[]{string};
            vector.add(new StateValidation(TargetValueStateError.PRIORS_HAS_ZERO_ENTRY, string3, stringArray));
            return;
        }
        n = 1000000 - (int)(d2 = (double)((int)Math.round(d2 * 10000.0)));
        if (n < 0) {
            n *= -1;
        }
        if (n > 0) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMaximumFractionDigits(4);
            String string = ResourceUtilities.getstateExceptionMessage("PRIORS_NOT_EQUAL_100");
            double d3 = d2 / 10000.0;
            double d4 = (double)n / 10000.0;
            String[] stringArray = new String[]{numberFormat.format(d3), numberFormat.format(d4)};
            vector.add(new StateValidation(TargetValueStateError.PRIORS_NOT_EQUAL_100, string, stringArray));
        }
    }

    public Vector validateCostMatrix() throws Exception {
        Vector vector = new Vector();
        this.validateCostMatrix(vector);
        return vector;
    }

    private void validateCostMatrix(Vector vector) throws Exception {
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
        if (vector.isEmpty()) {
            this.validateCostMatrix(vector);
        }
        if (vector.isEmpty()) {
            this.validatePriors(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    public String getTargetAttribute() {
        TargetState targetState = (TargetState)this.getparentWizardState().getStep(StepType.TARGET_STEP);
        return targetState.getTargetAttribute();
    }

    public void setOriginalDistEqualToCurrentDist() {
        TargetValueDataSource targetValueDataSource = this.getTargetValuesDataSource();
        for (int i = 0; i < targetValueDataSource.getRowCount(); ++i) {
            Double d = (Double)targetValueDataSource.getData(2, i);
            targetValueDataSource.setData(3, i, d);
        }
    }

    public void setTargetValues(TargetValueDataSource targetValueDataSource) {
        if (this.m_options != null) {
            if (this.m_options instanceof SVMCBuildStepOptions) {
                SVMCBuildStepOptions sVMCBuildStepOptions = (SVMCBuildStepOptions)this.m_options;
                sVMCBuildStepOptions.setTargetValueWeightDataSource((TargetValueWeightDataSource)targetValueDataSource);
            } else if (this.m_options instanceof GLMCBuildStepOptions) {
                GLMCBuildStepOptions gLMCBuildStepOptions = (GLMCBuildStepOptions)this.m_options;
                gLMCBuildStepOptions.setTargetValueWeightDataSource((TargetValueWeightDataSource)targetValueDataSource);
            } else if (this.m_options instanceof ABNBuildStepOptions) {
                ABNBuildStepOptions aBNBuildStepOptions = (ABNBuildStepOptions)this.m_options;
                aBNBuildStepOptions.setTargetValueDataSource(targetValueDataSource);
            } else if (this.m_options instanceof NaiveBayesBuildStepOptions) {
                NaiveBayesBuildStepOptions naiveBayesBuildStepOptions = (NaiveBayesBuildStepOptions)this.m_options;
                naiveBayesBuildStepOptions.setTargetValueDataSource(targetValueDataSource);
            }
        }
        super.setTargetValues(targetValueDataSource);
    }

    public TargetValueDataSource getTargetValuesDataSource() {
        if (this.m_options != null) {
            BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
            if (this.m_options instanceof DecisionTreeBuildStepOptions) {
                DecisionTreeBuildStepOptions decisionTreeBuildStepOptions = (DecisionTreeBuildStepOptions)this.m_options;
                TargetValueDataSource targetValueDataSource = new TargetValueDataSource(decisionTreeBuildStepOptions.getTargetPrior());
                targetValueDataSource.run();
                this.m_targetValues = targetValueDataSource;
            } else if (this.m_options instanceof SVMCBuildStepOptions) {
                SVMCBuildStepOptions sVMCBuildStepOptions = (SVMCBuildStepOptions)this.m_options;
                TargetValueWeightDataSource targetValueWeightDataSource = sVMCBuildStepOptions.getTargetValueWeightDataSource(browserContext.getActivity());
                this.m_targetValues = targetValueWeightDataSource;
            } else if (this.m_options instanceof GLMCBuildStepOptions) {
                GLMCBuildStepOptions gLMCBuildStepOptions = (GLMCBuildStepOptions)this.m_options;
                TargetValueWeightDataSource targetValueWeightDataSource = gLMCBuildStepOptions.getTargetValueWeightDataSource(browserContext.getActivity());
                this.m_targetValues = targetValueWeightDataSource;
            } else if (this.m_options instanceof ABNBuildStepOptions) {
                TargetValueDataSource targetValueDataSource;
                ABNBuildStepOptions aBNBuildStepOptions = (ABNBuildStepOptions)this.m_options;
                this.m_targetValues = targetValueDataSource = aBNBuildStepOptions.getTargetValueDataSource(browserContext.getActivity());
            } else if (this.m_options instanceof NaiveBayesBuildStepOptions) {
                TargetValueDataSource targetValueDataSource;
                NaiveBayesBuildStepOptions naiveBayesBuildStepOptions = (NaiveBayesBuildStepOptions)this.m_options;
                this.m_targetValues = targetValueDataSource = naiveBayesBuildStepOptions.getTargetValueDataSource(browserContext.getActivity());
            }
        }
        return super.getTargetValuesDataSource();
    }

    public void setTargetValueCostMatrix(TargetValueCostMatrixDataSource targetValueCostMatrixDataSource) {
        if (this.m_options != null && this.m_options instanceof DecisionTreeBuildStepOptions) {
            DecisionTreeBuildStepOptions decisionTreeBuildStepOptions = (DecisionTreeBuildStepOptions)this.m_options;
            decisionTreeBuildStepOptions.setCostMatrixDS(targetValueCostMatrixDataSource);
        }
        super.setTargetValueCostMatrix(targetValueCostMatrixDataSource);
    }

    public TargetValueCostMatrixDataSource getTargetValueCostMatrixDataSource() {
        if (this.m_options != null && this.m_options instanceof DecisionTreeBuildStepOptions) {
            DecisionTreeBuildStepOptions decisionTreeBuildStepOptions = (DecisionTreeBuildStepOptions)this.m_options;
            this.m_targetValueCostMatrix = decisionTreeBuildStepOptions.getCostMatrixDS();
        }
        return super.getTargetValueCostMatrixDataSource();
    }

    private class CheckForDataSourceChanges
    extends TwoDModelAdapter {
        private boolean m_newWizard;

        public CheckForDataSourceChanges(boolean bl) {
            this.m_newWizard = this.m_newWizard;
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            if (this.m_newWizard) {
                if (ModelTargetValueState.this.getState() == StepStateType.VALIDATED) {
                    ModelTargetValueState.this.setState(StepStateType.DIRTY);
                }
            } else if (ModelTargetValueState.this.getState() == StepStateType.VALIDATED) {
                ModelTargetValueState.this.setState(StepStateType.INCONSISTENT);
            }
        }
    }
}

