/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.MiningAlgorithm;
import javax.datamining.NamedObject;
import javax.datamining.base.Model;
import javax.datamining.resource.Connection;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.director.minings.MiningLoader;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClusteringModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FeatureExtractionModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionModelState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.ModelStateError;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.task.OraBuildTask;

public abstract class ModelState
extends WizardStepState {
    protected LDSDataSource m_ldsDataSource;
    protected String[] m_modelNames;
    protected StringBuffer m_modelName = new StringBuffer(0);
    protected StringBuffer m_modelInputSchema = new StringBuffer(0);
    protected StringBuffer m_modelBuildCompletionDate = new StringBuffer(0);
    protected StringBuffer m_modelBuildCompletionTime = new StringBuffer(0);
    protected StringBuffer m_modelInputTable = new StringBuffer(0);
    protected StringBuffer m_modelAlgorithm = new StringBuffer(0);
    protected Model m_modelBuildResult = null;
    protected Model m_miningModel = null;

    public ModelState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public Model getSelectedMiningModel() {
        return this.m_miningModel;
    }

    public String[] getModelNames() {
        return this.m_modelNames;
    }

    public String getSelectedModelName() {
        return this.m_modelName.toString();
    }

    public void setSelectedModelName(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_modelName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.setSelectedModelNameInternal(new StringBuffer(string));
        }
    }

    public boolean allowModelSelection() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        return !browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
    }

    protected void loadOld() throws Exception {
        this.loadModelNames();
        MiningLoader miningLoader = ((WizardState)this.getparentWizardState()).getMiningLoader();
        miningLoader.buildModel(this);
        this.m_miningModel = this.restoreModel();
    }

    protected void loadNew() throws Exception {
        this.loadModelNames();
        this.loadDefaultModelName();
    }

    protected void loadDefaultModelName() {
        if (this.m_modelNames.length > 0) {
            BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
            String string = browserContext.getMiningObjectName();
            if (string != null) {
                for (int i = 0; i < this.m_modelNames.length; ++i) {
                    if (this.m_modelNames[i].compareTo(string) != 0) continue;
                    this.setSelectedModelNameInternal(new StringBuffer(string));
                    break;
                }
            }
            if (this.m_modelName.length() == 0) {
                this.setSelectedModelNameInternal(new StringBuffer(this.m_modelNames[0]));
            }
        }
    }

    protected void loadModelNames() throws SQLException {
        Class<ClassificationModelState> clazz = ClassificationModelState.class;
        Class<ClusteringModelState> clazz2 = ClusteringModelState.class;
        Class<RegressionModelState> clazz3 = RegressionModelState.class;
        Class<FeatureExtractionModelState> clazz4 = FeatureExtractionModelState.class;
        String string = null;
        if (clazz.isInstance(this)) {
            string = "CLASSIFICATION";
        } else if (clazz2.isInstance(this)) {
            string = "CLUSTERING";
        } else if (clazz3.isInstance(this)) {
            string = "REGRESSION";
        } else if (clazz4.isInstance(this)) {
            string = "FEATURE_EXTRACTION";
        }
        if (string != null) {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String[] stringArray = dMEMetadata.getModelNames(this.getparentWizardState().getConnection(), string);
            this.m_modelNames = stringArray;
        }
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        this.m_miningModel = this.restoreModel();
        if (this.m_miningModel == null) {
            bl = false;
        }
        return bl;
    }

    protected void refreshOld() throws Exception {
        this.loadOld();
    }

    protected void refreshNew() throws Exception {
        this.loadNew();
    }

    public void validate(Vector vector) throws Exception {
        this.validateModelSelected(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    public void validateModelExists(Vector vector) throws Exception {
        String[] stringArray = new String[]{this.getSelectedModelName()};
        try {
            this.m_miningModel = this.restoreModel();
            if (this.m_miningModel == null) {
                vector.add(new StateValidation((ValidationType)ModelStateError.MODEL_DOES_NOT_EXIST, stringArray));
            }
        }
        catch (JDMException jDMException) {
            vector.add(new StateValidation((ValidationType)ModelStateError.MODEL_DOES_NOT_EXIST, stringArray));
        }
    }

    private void validateModelSelected(Vector vector) throws Exception {
        if (this.m_modelName.length() == 0) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("MODEL_NAME")};
            vector.add(new StateValidation(ModelStateError.MODEL_EMPTY, string, stringArray));
        }
    }

    protected void addModels(String[] stringArray, String[] stringArray2, int n) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n + i] = stringArray[i];
        }
    }

    public abstract Model restoreModel() throws Exception;

    public void setLDSDataSource(LDSDataSource lDSDataSource) {
        this.m_ldsDataSource = lDSDataSource;
    }

    public int getAttributeCountFromLDSDataSource() {
        return this.m_ldsDataSource.getRowCount();
    }

    public String getTextAttribute() {
        return null;
    }

    private void setSelectedModelNameInternal(StringBuffer stringBuffer) {
        this.m_modelName = stringBuffer;
        if (this.m_modelName != null && this.m_modelName.length() > 0) {
            this.loadModelDetails();
        }
    }

    private void loadModelDetails() {
        try {
            java.sql.Connection connection = ((WizardState)this.getparentWizardState()).getConnection();
            Connection connection2 = ((WizardState)this.getparentWizardState()).getJDMConnection();
            this.m_modelBuildResult = (Model)connection2.retrieveObject(this.m_modelName.toString().toUpperCase(), NamedObject.model);
            if (this.m_modelBuildResult != null) {
                Object object;
                Object object2;
                Object object3;
                this.m_modelInputSchema.setLength(0);
                this.m_modelInputTable.setLength(0);
                DMEMetadata dMEMetadata = DMEMetadata.getInstance();
                String string = dMEMetadata.getTaskNameForMiningObject(connection, "BUILD", this.m_modelName.toString());
                if (string != null) {
                    object3 = (OraBuildTask)connection2.retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string), NamedObject.task);
                    object2 = ((OraBuildTask)object3).getBuildData().getURI();
                    object = ((String)object2).split(".");
                    if (((String[])object).length > 1) {
                        this.m_modelInputSchema.append(object[0]);
                        this.m_modelInputTable.append((String)object[1]);
                    } else {
                        this.m_modelInputSchema.append(DM4JConnectionManager.getUser());
                        this.m_modelInputTable.append((String)object2);
                    }
                }
                object3 = this.m_modelBuildResult.getBuildDuration();
                object2 = this.m_modelBuildResult.getCreationDate();
                object = DateFormat.getDateInstance(3, Locale.getDefault());
                String string2 = ((DateFormat)object).format((Date)object2);
                this.m_modelBuildCompletionDate = new StringBuffer(string2);
                object = DateFormat.getTimeInstance(3, Locale.getDefault());
                String string3 = ((DateFormat)object).format((Date)object2);
                this.m_modelBuildCompletionTime = new StringBuffer(string3);
                this.m_modelAlgorithm = new StringBuffer(this.getAlgorithmDisplayName(this.m_modelBuildResult));
            } else {
                this.m_modelInputTable = new StringBuffer(0);
                this.m_modelInputSchema = new StringBuffer(0);
                this.m_modelBuildCompletionDate = new StringBuffer(0);
                this.m_modelBuildCompletionTime = new StringBuffer(0);
                this.m_modelAlgorithm = new StringBuffer(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getAlgorithmDisplayName(Model model) {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        String string = null;
        MiningAlgorithm miningAlgorithm = model.getMiningAlgorithm();
        string = miningAlgorithm.equals(MiningAlgorithm.naiveBayes) ? dM4JListResourceBundle.getString("CLASS_MODEL_TYPE_NB") : (miningAlgorithm.equals(MiningAlgorithm.svmClassification) ? dM4JListResourceBundle.getString("CLASS_MODEL_TYPE_SVM") : (miningAlgorithm.equals(MiningAlgorithm.svmRegression) ? dM4JListResourceBundle.getString("REGRE_MODEL_TYPE_SVM") : (miningAlgorithm.equals(MiningAlgorithm.decisionTree) ? dM4JListResourceBundle.getString("CLASS_MODEL_TYPE_DT") : (miningAlgorithm.equals(MiningAlgorithm.kMeans) ? dM4JListResourceBundle.getString("CLUST_MODEL_TYPE_KMEANS") : (miningAlgorithm.equals(OraMiningAlgorithm.adaptiveBayesNetwork) ? dM4JListResourceBundle.getString("CLASS_MODEL_TYPE_ABN") : (miningAlgorithm.equals(OraMiningAlgorithm.aprioriAssociationRules) ? dM4JListResourceBundle.getString("ASSOC_ALGO_APRIORI") : (miningAlgorithm.equals(OraMiningAlgorithm.minimumDescriptionLength) ? dM4JListResourceBundle.getString("AI_ALGO_PREDICTOR_VARIANCE") : (miningAlgorithm.equals(OraMiningAlgorithm.nonNegativeMatrixFactorization) ? dM4JListResourceBundle.getString("FEATU_MODEL_TYPE_NMF") : (miningAlgorithm.equals(OraMiningAlgorithm.oCluster) ? dM4JListResourceBundle.getString("CLUST_MODEL_TYPE_OCLUSTER") : dM4JListResourceBundle.getString("COMMON_NOT_AVAILABLE"))))))))));
        return string;
    }

    public String getModelInputDataSchemaName() {
        return this.m_modelInputSchema.toString();
    }

    public String getModelInputDataTableName() {
        return this.m_modelInputTable.toString();
    }

    public Model getModelBuildResult() {
        return this.m_modelBuildResult;
    }

    public String getModelBuildCompletionDate() {
        return this.m_modelBuildCompletionDate.toString();
    }

    public String getModelBuildCompletionTime() {
        return this.m_modelBuildCompletionTime.toString();
    }

    public String getModelAlgorithm() {
        return this.m_modelAlgorithm.toString();
    }
}

