/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dm4j.activity.AdaptiveBayesActivity;
import oracle.dmt.dm4j.activity.AnomalyDetectionActivity;
import oracle.dmt.dm4j.activity.AssociationRulesActivity;
import oracle.dmt.dm4j.activity.AttributeImportanceActivity;
import oracle.dmt.dm4j.activity.DecisionTreeActivity;
import oracle.dmt.dm4j.activity.KMeansActivity;
import oracle.dmt.dm4j.activity.NMFActivity;
import oracle.dmt.dm4j.activity.NaiveBayesActivity;
import oracle.dmt.dm4j.activity.OClusterActivity;
import oracle.dmt.dm4j.activity.SVMClassificationActivity;
import oracle.dmt.dm4j.activity.SVMRegressionActivity;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.AssociationModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.NameStateError;

public class ModelNameState
extends WizardStepState {
    private final int NAME_LENGTH_MAX = 25;
    private final String NAME_SUFFIX = "";
    protected StringBuffer m_modelName = new StringBuffer();

    public ModelNameState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public String getModelName() {
        return this.m_modelName.toString();
    }

    public void setModelName(String string) {
        String string2;
        if (string != null && string.compareTo(string2 = this.m_modelName.toString()) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_modelName.setLength(0);
            this.m_modelName.append(string.toUpperCase());
        }
    }

    protected void loadOld() throws Exception {
        this.loadNew();
    }

    protected void loadNew() throws Exception {
        this.loadDefaultModelName();
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void refreshOld() throws Exception {
    }

    protected void refreshNew() throws Exception {
    }

    public void validate(Vector vector) throws Exception {
        this.validateModelName(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    private void validateModelName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.m_modelName.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("MODEL_NAME")};
            vector.add(new StateValidation(NameStateError.MODEL_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_modelName.toString(), 25)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("MODEL_NAME"), Integer.toString(25)};
            vector.add(new StateValidation(NameStateError.MODEL_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (!ValidationUtil.isValidNonQuotedDBObjectName(this.m_modelName.toString())) {
            vector.add(new StateValidation(NameStateError.MODEL_NAME_INVALID));
        }
        if (!ValidationUtil.isModelNameUnique(this.m_modelName.toString(), ((WizardState)this.getparentWizardState()).getConnection())) {
            vector.add(new StateValidation(NameStateError.MODEL_NAME_DUPLICATE));
        }
    }

    protected void loadDefaultModelName() throws SQLException {
        String string = ((WizardState)this.getparentWizardState()).getDefaultModelName();
        int n = 25;
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        String string2 = null;
        String string3 = "";
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            if (this.getparentWizardState() instanceof AssociationModelBuildState) {
                Table table = null;
                Iterator iterator = browserContext.getActivity().getTables().iterator();
                while (iterator.hasNext() && (table = (Table)iterator.next()).equals(browserContext.getActivity().getCaseTable())) {
                }
                string2 = table.getName();
            } else {
                string2 = browserContext.getActivity().getCaseTable().getName();
            }
            if (browserContext.getActivity() instanceof DecisionTreeActivity) {
                string3 = "_DT";
            } else if (browserContext.getActivity() instanceof NaiveBayesActivity) {
                string3 = "_NB";
            } else if (browserContext.getActivity() instanceof AdaptiveBayesActivity) {
                string3 = "_AB";
            } else if (browserContext.getActivity() instanceof SVMClassificationActivity) {
                string3 = "_SV";
            } else if (browserContext.getActivity() instanceof AnomalyDetectionActivity) {
                string3 = "_SV";
            } else if (browserContext.getActivity() instanceof AssociationRulesActivity) {
                string3 = "_AS";
            } else if (browserContext.getActivity() instanceof AttributeImportanceActivity) {
                string3 = "_AI";
            } else if (browserContext.getActivity() instanceof KMeansActivity) {
                string3 = "_CL";
            } else if (browserContext.getActivity() instanceof NMFActivity) {
                string3 = "_NF";
            } else if (browserContext.getActivity() instanceof OClusterActivity) {
                string3 = "_CL";
            } else if (browserContext.getActivity() instanceof SVMRegressionActivity) {
                string3 = "_SV";
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        string2 = string2.length() > n ? string2.substring(0, n) : string2;
        string2 = ValidationUtil.createUniqueModelName(string2, ((WizardState)this.getparentWizardState()).getConnection(), string3);
        this.setModelName(string2);
    }

    private String getNameFromDataState() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getSelectedTableName();
    }
}

