/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import javax.datamining.algorithm.kmeans.ClusteringDistanceFunction;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.KMeansBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AlgorithmSettingState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClusteringAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.KMeansAlgorithmStateError;
import oracle.dmt.jdm.algorithm.kmeans.OraSplitCriterion;

public class KMeansAlgorithmState
extends AlgorithmSettingState {
    private AbstractActivity m_activity = null;
    private KMeansBuildStepOptions m_options = null;
    private KMeansBuildStepOptions m_savedOptions = null;
    private ClusteringAlgorithmState m_wizardStepState;

    public KMeansAlgorithmState(WizardStepState wizardStepState) {
        super(wizardStepState);
        this.m_wizardStepState = (ClusteringAlgorithmState)wizardStepState;
        this.initialize();
    }

    public KMeansAlgorithmState() {
        this.initialize();
    }

    private void initialize() {
        BrowserContext browserContext = this.m_wizardStepState.getparentWizardState().getBrowserContext();
        this.m_activity = browserContext.getActivity();
        this.m_options = (KMeansBuildStepOptions)browserContext.getOptions();
        this.m_savedOptions = new KMeansBuildStepOptions(this.m_options);
    }

    public void setMinimumErrorTolerance(Double d) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setMinimumErrorTolerance(d);
    }

    public Double getMinimumErrorTolerance() {
        return this.m_options.getMinimumErrorTolerance();
    }

    public void setMinimumSupportPercentage(Double d) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setMinimumSupportPercentage(d);
    }

    public Double getMinimumSupportPercentage() {
        return this.m_options.getMinimumSupportPercentage();
    }

    public Vector getAvailableSplitCriterionNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("Size");
        vector.add("Variance");
        return vector;
    }

    public Vector getAvailableDistanceFunctionNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("Cosine");
        vector.add("Euclidean");
        return vector;
    }

    public void setMaximumIterations(Integer n) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setMaximumIterations(n);
    }

    public Integer getMaximumIterations() {
        return this.m_options.getMaximumIterations();
    }

    public void setNumberOfBins(Integer n) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setNumberOfBins(n);
    }

    public Integer getNumberOfBins() {
        return this.m_options.getNumberOfBins();
    }

    public void setDistanceFunction(ClusteringDistanceFunction clusteringDistanceFunction) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setDistanceFunction(clusteringDistanceFunction);
    }

    public ClusteringDistanceFunction getDistanceFunction() {
        return this.m_options.getDistanceFunction();
    }

    public void setSplitCriterion(OraSplitCriterion oraSplitCriterion) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setSplitCriterion(oraSplitCriterion);
    }

    public OraSplitCriterion getSplitCriterion() {
        return this.m_options.getSplitCriterion();
    }

    public Integer getBlockGrowth() {
        return this.m_options.getBlockGrowth();
    }

    public void setBlockGrowth(Integer n) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setBlockGrowth(n);
    }

    protected void validateNoCategoricals(Vector vector) throws Exception {
        ModelDataState modelDataState = (ModelDataState)this.m_wizardStepState.getparentWizardState().getStep(StepType.DATA_STEP);
        int n = modelDataState.getLDSDataSource().getCountOfCategoricals(true);
        if (n > 0) {
            vector.add(new StateValidation(KMeansAlgorithmStateError.ALGO_KMEANS_CATEGORICALS_NOT_ALLOWED));
            return;
        }
    }

    public void validate(Vector vector) throws Exception {
        this.m_options.validate(vector);
    }

    public Vector validate() throws Exception {
        Vector vector = new Vector();
        this.validate(vector);
        return vector;
    }

    public void restoreSettingsToDefault() {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.restoreToDefaultSettings(this.m_activity);
    }

    public void restoreSettings() {
        if (this.m_wizardStepState.getState() == StepStateType.DIRTY) {
            this.m_wizardStepState.setState(StepStateType.VALIDATED);
        }
        this.m_options.restoreSettings(this.m_savedOptions);
    }
}

