/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import javax.datamining.algorithm.tree.TreeHomogeneityMetric;
import oracle.dmt.dm4j.activity.steps.DecisionTreeBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AlgorithmSettingState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.DecisionTreeAlgorithmStateError;

public class DecisionTreeAlgorithmState
extends AlgorithmSettingState {
    private Integer m_maxDepth;
    private Integer m_minSizeCnt;
    private Double m_minSizePercent;
    private Integer m_nodeSizeForSplitCnt;
    private Double m_nodeSizeForSplitPercent;
    private TreeHomogeneityMetric m_homogeneityMetric;
    private Integer m_defaultMaxDepth;
    private Integer m_defaultMinSizeCnt;
    private Double m_defaultMinSizePercent;
    private Integer m_defaultNodeSizeForSplitCnt;
    private Double m_defaultNodeSizeForSplitPercent;
    private TreeHomogeneityMetric m_defaultHomogeneityMetric;
    private DecisionTreeBuildStepOptions m_options = null;

    public DecisionTreeAlgorithmState(WizardStepState wizardStepState, Integer n, Integer n2, Double d, Integer n3, Double d2, TreeHomogeneityMetric treeHomogeneityMetric) {
        super(wizardStepState);
        this.initialize(n, n2, d, n3, d2, treeHomogeneityMetric);
    }

    public DecisionTreeAlgorithmState(Integer n, Integer n2, Double d, Integer n3, Double d2, TreeHomogeneityMetric treeHomogeneityMetric) {
        this.initialize(n, n2, d, n3, d2, treeHomogeneityMetric);
    }

    private void initialize(Integer n, Integer n2, Double d, Integer n3, Double d2, TreeHomogeneityMetric treeHomogeneityMetric) {
        BrowserContext browserContext = this.m_wizardStepState.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof DecisionTreeBuildStepOptions) {
            this.m_options = (DecisionTreeBuildStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_maxDepth = this.m_options.getMaxDepth();
            this.m_minSizeCnt = this.m_options.getMinSizeCnt();
            this.m_minSizePercent = this.m_options.getMinSizePercent();
            this.m_nodeSizeForSplitCnt = this.m_options.getNodeSizeForSplitCnt();
            this.m_nodeSizeForSplitPercent = this.m_options.getNodeSizeForSplitPercent();
            this.m_homogeneityMetric = this.m_options.getHomogeneityMetric();
        } else {
            this.m_maxDepth = n;
            this.m_minSizeCnt = n2;
            this.m_minSizePercent = d;
            this.m_nodeSizeForSplitCnt = n3;
            this.m_nodeSizeForSplitPercent = d2;
            this.m_homogeneityMetric = treeHomogeneityMetric;
        }
        this.m_defaultMaxDepth = n;
        this.m_defaultMinSizeCnt = n2;
        this.m_defaultMinSizePercent = d;
        this.m_defaultNodeSizeForSplitCnt = n3;
        this.m_defaultNodeSizeForSplitPercent = d2;
        this.m_defaultHomogeneityMetric = treeHomogeneityMetric;
    }

    public void setMaxDepth(Integer n) {
        if (this.m_maxDepth == null || n == null || !this.m_maxDepth.equals(n)) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_maxDepth = n;
            if (this.m_options != null) {
                this.m_options.setMaxDepth(n);
            }
        }
    }

    public Integer getMaxDepth() {
        return this.m_maxDepth;
    }

    public void setMinSizeCnt(Integer n) {
        if (this.m_minSizeCnt == null || n == null || !this.m_minSizeCnt.equals(n)) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_minSizeCnt = n;
            if (this.m_options != null) {
                this.m_options.setMinSizeCnt(n);
            }
        }
    }

    public Integer getMinSizeCnt() {
        return this.m_minSizeCnt;
    }

    public void setMinSizePercent(Double d) {
        if (this.m_minSizePercent == null || d == null || !this.m_minSizePercent.equals(d)) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_minSizePercent = d;
            if (this.m_options != null) {
                this.m_options.setMinSizePercent(d);
            }
        }
    }

    public Double getMinSizePercent() {
        return this.m_minSizePercent;
    }

    public void setNodeSizeForSplitCnt(Integer n) {
        if (this.m_nodeSizeForSplitCnt == null || n == null || !this.m_nodeSizeForSplitCnt.equals(n)) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_nodeSizeForSplitCnt = n;
            if (this.m_options != null) {
                this.m_options.setNodeSizeForSplitCnt(n);
            }
        }
    }

    public Integer getNodeSizeForSplitCnt() {
        return this.m_nodeSizeForSplitCnt;
    }

    public void setNodeSizeForSplitPercent(Double d) {
        if (this.m_nodeSizeForSplitCnt == null || d == null || !this.m_nodeSizeForSplitCnt.equals(d)) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_nodeSizeForSplitPercent = d;
            if (this.m_options != null) {
                this.m_options.setNodeSizeForSplitPercent(d);
            }
        }
    }

    public Double getNodeSizeForSplitPercent() {
        return this.m_nodeSizeForSplitPercent;
    }

    public Vector getAvailableHomogeneityMetricNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(TreeHomogeneityMetric.entropy.name());
        vector.add(TreeHomogeneityMetric.gini.name());
        return vector;
    }

    public void setHomogeneityMetricSelected(TreeHomogeneityMetric treeHomogeneityMetric) {
        if (this.m_homogeneityMetric == null || treeHomogeneityMetric == null || !this.m_homogeneityMetric.equals(treeHomogeneityMetric)) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_homogeneityMetric = treeHomogeneityMetric;
            if (this.m_options != null) {
                this.m_options.setHomogeneityMetric(treeHomogeneityMetric);
            }
        }
    }

    public TreeHomogeneityMetric getHomogeneityMetricSelected() {
        return this.m_homogeneityMetric;
    }

    protected void validateMaxDepth(Vector vector) throws Exception {
        if (this.m_maxDepth == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_DT_MAX_DEPTH")};
            vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MAX_DEPTH_EMPTY, string, stringArray));
        } else {
            int n = this.m_maxDepth;
            if (n < 2 || n > 20) {
                vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MAX_DEPTH_INVALID));
            }
        }
    }

    protected void validateMinSizeCnt(Vector vector) throws Exception {
        if (this.m_minSizeCnt == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_DT_MIN_SIZE_CNT")};
            vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MIN_SIZE_CNT_EMPTY, string, stringArray));
        } else {
            double d = this.m_minSizeCnt.doubleValue();
            if (d < 0.0) {
                vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MIN_SIZE_CNT_INVALID));
            }
        }
    }

    protected void validateMinSizePercent(Vector vector) throws Exception {
        if (this.m_minSizePercent == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_DT_MIN_SIZE_PERCENT")};
            vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MIN_SIZE_PERCENT_EMPTY, string, stringArray));
        } else {
            double d = this.m_minSizePercent;
            if (d < 0.0 || d > 10.0) {
                vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_MIN_SIZE_PERCENT_INVALID));
            }
        }
    }

    protected void validateNodeSizeForSplitCnt(Vector vector) throws Exception {
        if (this.m_nodeSizeForSplitCnt == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_DT_NODE_SIZE_CNT")};
            vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_NODE_SIZE_CNT_EMPTY, string, stringArray));
        } else {
            double d = this.m_nodeSizeForSplitCnt.doubleValue();
            if (d < 0.0) {
                vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_NODE_SIZE_CNT_INVALID));
            }
        }
    }

    protected void validateNodeSizeForSplitPercent(Vector vector) throws Exception {
        if (this.m_nodeSizeForSplitPercent == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_DT_NODE_SIZE_PERCENT")};
            vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_NODE_SIZE_PERCENT_EMPTY, string, stringArray));
        } else {
            double d = this.m_nodeSizeForSplitPercent;
            if (d < 0.0 || d > 20.0) {
                vector.add(new StateValidation(DecisionTreeAlgorithmStateError.ALGO_DT_NODE_SIZE_PERCENT_INVALID));
            }
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateMaxDepth(vector);
        this.validateMinSizeCnt(vector);
        this.validateMinSizePercent(vector);
        this.validateNodeSizeForSplitCnt(vector);
        this.validateNodeSizeForSplitPercent(vector);
    }

    public Vector validate() throws Exception {
        Vector vector = new Vector();
        this.validate(vector);
        return vector;
    }

    public void restoreSettingsToDefault() {
        this.setMaxDepth(this.m_defaultMaxDepth);
        this.setMinSizeCnt(this.m_defaultMinSizeCnt);
        this.setMinSizePercent(this.m_defaultMinSizePercent);
        this.setNodeSizeForSplitCnt(this.m_defaultNodeSizeForSplitCnt);
        this.setNodeSizeForSplitPercent(this.m_defaultNodeSizeForSplitPercent);
        this.setHomogeneityMetricSelected(this.m_defaultHomogeneityMetric);
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
    }
}

