/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.AssociationModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.AttributeImportanceModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.ClusteringModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.FeatureExtractionModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.RegressionModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClusteringAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataPrepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.DataUsageError;
import oracle.dmt.dm4j.wizard.validation.miningsteps.DataUsageWarning;

public class DataUsageState
extends WizardStepState {
    private static int TRANSACTIONAL_NAME_MAX_LENGTH = 30;
    private static char DOUBLE_QUOTE = (char)34;
    CheckForDataSourceChanges m_dataSourcelistener;
    protected boolean m_enableValidation = true;

    public DataUsageState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    protected void setDataUsageListener(boolean bl) {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        this.m_dataSourcelistener = new CheckForDataSourceChanges(bl);
        modelDataState.getLDSDataSource().addModelListener((TwoDModelListener)this.m_dataSourcelistener);
    }

    public void adjustNestedAttributeSelection() {
        ClassificationAlgorithmState classificationAlgorithmState;
        boolean bl = true;
        if (this.getparentWizardState() instanceof ClassificationModelBuildState && (classificationAlgorithmState = (ClassificationAlgorithmState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP)).isDecisionTreeSelected()) {
            bl = false;
        }
        for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
            String string = (String)this.getLDSDataSource().getData(2, i);
            if (!string.equals("DM_NESTED_NUMERICALS") && !string.equals("DM_NESTED_CATEGORICALS")) continue;
            if (bl) {
                this.getLDSDataSource().setData(0, i, Boolean.TRUE);
                this.getLDSDataSource().setData(8, i, Boolean.TRUE);
                continue;
            }
            this.getLDSDataSource().setData(0, i, Boolean.FALSE);
            this.getLDSDataSource().setData(8, i, Boolean.FALSE);
        }
    }

    public void adjust2DAttributeSelection() {
        boolean bl = false;
        int n = 0;
        if (this.getparentWizardState() instanceof ClusteringModelBuildState) {
            ClusteringAlgorithmState clusteringAlgorithmState = (ClusteringAlgorithmState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            if (clusteringAlgorithmState.isOClusterSelected()) {
                n = 1;
                bl = true;
            }
        } else if (this.getparentWizardState() instanceof FeatureExtractionModelBuildState) {
            n = 0;
            bl = true;
        }
        if (bl) {
            for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
                Double d;
                if (this.getLDSDataSource().getData(5, i).equals("target") || !((Boolean)this.getLDSDataSource().getData(0, i)).booleanValue() || !((String)this.getLDSDataSource().getData(2, i)).equals("NUMBER") && !((String)this.getLDSDataSource().getData(2, i)).equals("FLOAT") || (d = (Double)this.getLDSDataSource().getData(13, i)) == null || d.intValue() >= n) continue;
                this.getLDSDataSource().setData(0, i, Boolean.FALSE);
                this.getLDSDataSource().setData(8, i, Boolean.FALSE);
            }
        }
    }

    protected void loadNew() throws Exception {
        this.setDataUsageListener(true);
        this.adjust2DAttributeSelection();
        this.adjustNestedAttributeSelection();
    }

    public LDSDataSource getLDSDataSource() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getLDSDataSource();
    }

    public String getTextAttribute() {
        return this.getLDSDataSource().getSelectedTextAttributeName();
    }

    public String getTargetAttribute() {
        return this.getLDSDataSource().getTargetAttributeName();
    }

    public String getCaseIdAttribute() {
        return this.getLDSDataSource().getCaseIdAttributeName();
    }

    protected void validateMinimumAttributes(Vector vector) throws Exception {
        int n = this.getLDSDataSource().getActiveAttributeCountExcludingTargets();
        WizardState wizardState = (WizardState)this.getparentWizardState();
        if (wizardState instanceof AssociationModelBuildState || wizardState instanceof ClusteringModelBuildState) {
            if (n <= 1) {
                vector.add(new StateValidation(DataUsageError.DATA_USAGE_NOT_ENOUGH_ATTRIBUTES));
            }
        } else if (n == 0) {
            vector.add(new StateValidation(DataUsageError.DATA_USAGE_NO_ACTIVE_ATTRIBUTES));
        }
    }

    protected void validateTargetIsCategorical(Vector vector) throws Exception {
        TargetState targetState = (TargetState)this.getparentWizardState().getStep(StepType.TARGET_STEP);
        if (targetState != null) {
            String string = targetState.getTargetAttribute();
            String string2 = this.getLDSDataSource().getTargetAttributeMiningType();
            if (!string2.equals("categorical")) {
                String string3 = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_TARGET_NOT_CATEGORICAL");
                String[] stringArray = new String[]{string};
                vector.add(new StateValidation(DataUsageError.DATA_USAGE_TARGET_NOT_CATEGORICAL, string3, stringArray));
            }
        }
    }

    protected void validateTargetIsNumerical(Vector vector) throws Exception {
        TargetState targetState = (TargetState)this.getparentWizardState().getStep(StepType.TARGET_STEP);
        if (targetState != null) {
            String string = targetState.getTargetAttribute();
            String string2 = this.getLDSDataSource().getTargetAttributeMiningType();
            if (!string2.equals("numerical")) {
                String string3 = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_TARGET_NOT_NUMERICAL");
                String[] stringArray = new String[]{string};
                vector.add(new StateValidation(DataUsageError.DATA_USAGE_TARGET_NOT_NUMERICAL, string3, stringArray));
            }
        }
    }

    public void validate(Vector vector) throws Exception {
        if (!this.m_enableValidation) {
            return;
        }
        this.validateMinimumAttributes(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateMinValueErrors(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            WizardStepState wizardStepState = (WizardStepState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            if (wizardStepState instanceof ClassificationAlgorithmState) {
                this.validateTargetIsCategorical(vector);
            } else if (wizardStepState instanceof RegressionAlgorithmState) {
                this.validateTargetIsNumerical(vector);
            } else if (this.getparentWizardState() instanceof AttributeImportanceModelBuildState) {
                this.validateTargetIsCategorical(vector);
            }
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    public void validateAttributeDataTypes(Vector vector) throws Exception {
        WizardStepState wizardStepState;
        boolean bl = true;
        if (this.getparentWizardState() instanceof ClassificationModelBuildState) {
            wizardStepState = (ClassificationAlgorithmState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            if (((ClassificationAlgorithmState)wizardStepState).isDecisionTreeSelected()) {
                bl = false;
            }
        } else if (this.getparentWizardState() instanceof ClusteringModelBuildState && ((ClusteringAlgorithmState)(wizardStepState = (ClusteringAlgorithmState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP))).isOClusterSelected()) {
            bl = false;
        }
        for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
            Boolean bl2 = (Boolean)this.getLDSDataSource().getData(0, i);
            String string = (String)this.getLDSDataSource().getData(2, i);
            if (!bl2.booleanValue() || string.equals("FLOAT") || string.equals("NUMBER") || string.equals("DATE") || string.equals("CHAR") || string.equals("VARCHAR2")) continue;
            if (bl) {
                if (string.equals("DM_NESTED_NUMERICALS") || string.equals("DM_NESTED_CATEGORICALS")) continue;
                vector.add(new StateValidation(DataUsageError.DATA_USAGE_DATA_TYPE_INVALID));
                this.getLDSDataSource().setData(0, i, Boolean.FALSE);
                this.getLDSDataSource().setData(8, i, Boolean.FALSE);
                continue;
            }
            vector.add(new StateValidation(DataUsageError.DATA_USAGE_DATA_TYPE_INVALID2));
            this.getLDSDataSource().setData(0, i, Boolean.FALSE);
            this.getLDSDataSource().setData(8, i, Boolean.FALSE);
        }
    }

    private void validateBinData(Vector vector) throws Exception {
        DataPrepState dataPrepState = (DataPrepState)this.getparentWizardState().getStep(StepType.DATA_PREP_STEP);
        if (dataPrepState != null && dataPrepState.getDataPreparedStatus() == DataPrepState.PREP_NONE && this.doesAlgorithmRequireBinning()) {
            this.validateBinDataCategoricalType(vector);
            this.checkForBinningErrors(vector);
        }
    }

    private void validateBinDataCategoricalType(Vector vector) throws Exception {
        if (!(this.getparentWizardState() instanceof ClusteringModelBuildState)) {
            Boolean bl = Boolean.FALSE;
            for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
                bl = (Boolean)this.getLDSDataSource().getData(0, i);
                if (!bl.booleanValue() || ((String)this.getLDSDataSource().getData(5, i)).equals("target") || ((String)this.getLDSDataSource().getData(5, i)).equals("caseId") || !((String)this.getLDSDataSource().getData(3, i)).equals("numerical")) continue;
                vector.add(new StateValidation(DataUsageError.DATA_USAGE_NUMERICAL_MINING_TYPE_INVALID));
                i = this.getLDSDataSource().getRowCount();
            }
        }
    }

    private void validateMinValueErrors(Vector vector) throws Exception {
        Object object;
        boolean bl = false;
        int n = 0;
        if (this.getparentWizardState() instanceof ClusteringModelBuildState) {
            object = (ClusteringAlgorithmState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            if (((ClusteringAlgorithmState)object).isOClusterSelected()) {
                bl = true;
            }
        } else if (this.getparentWizardState() instanceof FeatureExtractionModelBuildState) {
            n = 0;
            bl = true;
        }
        object = new StringBuffer();
        if (bl && this.getLDSDataSource().areAttributesExceedingMinValue(n, (StringBuffer)object)) {
            String string = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_ATTRIBUTES_EXCEED_MIN_VALUE");
            String[] stringArray = new String[]{((StringBuffer)object).toString(), String.valueOf(n)};
            vector.add(new StateValidation(DataUsageError.DATA_USAGE_ATTRIBUTES_EXCEED_MIN_VALUE, string, stringArray));
        }
    }

    private void checkForBinningErrors(Vector vector) throws Exception {
        Object object;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        UserPreferences userPreferences = UserPreferences.getInstance();
        if (this.getparentWizardState() instanceof ClassificationModelBuildState) {
            object = (ClassificationAlgorithmState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            if (((ClassificationAlgorithmState)object).getAdaptiveNaiveBayesSelected()) {
                n = userPreferences.getMaxABNCategoricalBin();
                n2 = userPreferences.getMaxABNNumericalBin();
            } else {
                n = userPreferences.getMaxCategoricalBin();
                n2 = userPreferences.getMaxNumericalBin();
            }
        } else {
            n = userPreferences.getMaxCategoricalBin();
            n2 = userPreferences.getMaxNumericalBin();
        }
        if (this.getLDSDataSource().areAttributesExceedingBinLimits(n, n2)) {
            object = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_ATTRIBUTES_EXCEED_BIN_LIMITS");
            String[] stringArray = new String[]{String.valueOf(n), String.valueOf(n2)};
            vector.add(new StateValidation(DataUsageWarning.ATTRIBUTES_EXCEED_BIN_LIMIT, (String)object, stringArray));
        }
    }

    public boolean doesAlgorithmRequireBinning() {
        boolean bl = false;
        if (this.getparentWizardState() instanceof ClassificationModelBuildState) {
            ClassificationAlgorithmState classificationAlgorithmState = (ClassificationAlgorithmState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            bl = !classificationAlgorithmState.getSupportVectorMachineSelected();
        } else if (this.getparentWizardState() instanceof AssociationModelBuildState || this.getparentWizardState() instanceof AttributeImportanceModelBuildState || this.getparentWizardState() instanceof ClusteringModelBuildState) {
            bl = true;
        }
        return bl;
    }

    public boolean doesAlgorithmHaveTargetAttribute() {
        boolean bl = false;
        if (this.getparentWizardState() instanceof ClassificationModelBuildState || this.getparentWizardState() instanceof AttributeImportanceModelBuildState || this.getparentWizardState() instanceof RegressionModelBuildState) {
            bl = true;
        }
        return bl;
    }

    public boolean doesAlgorithmSupportTextMining() {
        boolean bl = false;
        if (this.getparentWizardState() instanceof ClassificationModelBuildState) {
            ClassificationAlgorithmState classificationAlgorithmState = (ClassificationAlgorithmState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            if (classificationAlgorithmState.getSupportVectorMachineSelected()) {
                bl = true;
            }
        } else if (this.getparentWizardState() instanceof RegressionModelBuildState) {
            bl = true;
        } else if (this.getparentWizardState() instanceof FeatureExtractionModelBuildState) {
            bl = true;
        }
        return bl;
    }

    public boolean IsCaseIdUsed() {
        boolean bl = true;
        return bl;
    }

    private void validateQuotedAttributeName(Vector vector) throws Exception {
        Boolean bl = Boolean.FALSE;
        for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
            String string;
            bl = (Boolean)this.getLDSDataSource().getData(0, i);
            if (!bl.booleanValue() || ValidationUtil.isValidNonQuotedDBObjectName(string = (String)this.getLDSDataSource().getData(1, i))) continue;
            String string2 = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_NAME_INVALID_NONQUOTED_COL_NAME");
            String[] stringArray = new String[]{string};
            vector.add(new StateValidation(DataUsageError.INVALID_NONQUOTED_DBNAME, string2, stringArray));
            i = this.getLDSDataSource().getRowCount();
        }
    }

    private void validateTxnAttributeName(Vector vector) throws Exception {
        Boolean bl = Boolean.FALSE;
        for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
            String[] stringArray;
            String string;
            bl = (Boolean)this.getLDSDataSource().getData(0, i);
            if (!bl.booleanValue()) continue;
            String string2 = (String)this.getLDSDataSource().getData(1, i);
            if (string2.length() == 0) {
                string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                stringArray = new String[]{ResourceUtilities.getUILabel("DATA_USAGE_ATTRIBUTE_NAME")};
                vector.add(new StateValidation(DataUsageError.ATTRIBUTE_NAME_EMPTY, string, stringArray));
                i = this.getLDSDataSource().getRowCount();
                continue;
            }
            if (ValidationUtil.checkStringLength(string2, TRANSACTIONAL_NAME_MAX_LENGTH)) continue;
            string = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_ATTRIBUTE_NAME_EXCEEDS_MAXIMUM_LENGTH");
            stringArray = new String[]{string2, Integer.toString(TRANSACTIONAL_NAME_MAX_LENGTH)};
            vector.add(new StateValidation(DataUsageError.DATA_USAGE_ATTRIBUTE_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
            i = this.getLDSDataSource().getRowCount();
        }
    }

    public int getAttributeCountInteger() {
        return Integer.parseInt(this.getAttributeCount());
    }

    public String getAttributeCount() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return Integer.toString(modelDataState.getAttributeCountFromLDSDataSource());
    }

    public String getActiveAttributeCountExcludingTargets() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return Integer.toString(modelDataState.getActiveAttributeCountExcludingTargets());
    }

    public int getActiveAttributeCountIncludingTargetsInteger() {
        return Integer.parseInt(this.getActiveAttributeCountIncludingTargets());
    }

    public String getActiveAttributeCountIncludingTargets() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return Integer.toString(modelDataState.getActiveAttributeCountIncludingTargets());
    }

    public int getCaseCountInteger() {
        return Integer.parseInt(this.getCaseCount());
    }

    public String getCaseCount() {
        DataState dataState = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return Integer.toString(dataState.getCaseCount());
    }

    public boolean isMulitpleRecordCaseFormat() {
        DataState dataState = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return dataState.isMultipleRecordCaseFormat();
    }

    public String[] getMiningTypeAllowableValues() {
        String[] stringArray = new String[]{"categorical", "numerical"};
        return stringArray;
    }

    public Vector setAttributeToCategorical(Range[] rangeArray) {
        Vector<StateValidation> vector = new Vector<StateValidation>();
        LDSDataSource lDSDataSource = this.getLDSDataSource();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                if (((String)this.getLDSDataSource().getData(5, j)).equals("target") || ((String)this.getLDSDataSource().getData(5, j)).equals("caseId")) continue;
                ++n;
                String string = (String)this.getLDSDataSource().getData(2, j);
                if (!string.equals("DM_NESTED_CATEGORICALS") && !string.equals("CHAR") && !string.equals("VARCHAR2") && !string.equals("DATE") && !string.equals("FLOAT") && !string.equals("NUMBER")) continue;
                lDSDataSource.setData(3, j, "categorical");
                ++n2;
            }
        }
        if (n2 > 0) {
            this.setState(StepStateType.DIRTY);
        }
        if (n != n2) {
            try {
                String string = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_NUMBER_ATTRIBUTES_SET_CATEGORICAL");
                String[] stringArray = new String[]{Integer.toString(n2), Integer.toString(n)};
                vector.add(new StateValidation(DataUsageWarning.DATA_USAGE_NUMBER_ATTRIBUTES_SET_CATEGORICAL, string, stringArray));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    public Vector setAttributeToNumerical(Range[] rangeArray) {
        Vector<StateValidation> vector = new Vector<StateValidation>();
        LDSDataSource lDSDataSource = this.getLDSDataSource();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                if (((String)this.getLDSDataSource().getData(5, j)).equals("target") || ((String)this.getLDSDataSource().getData(5, j)).equals("caseId")) continue;
                ++n;
                String string = (String)this.getLDSDataSource().getData(2, j);
                if (!string.equals("DM_NESTED_NUMERICALS") && !string.equals("FLOAT") && !string.equals("NUMBER")) continue;
                lDSDataSource.setData(3, j, "numerical");
                ++n2;
            }
        }
        if (n2 > 0) {
            this.setState(StepStateType.DIRTY);
        }
        if (n != n2) {
            try {
                String string = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_NUMBER_ATTRIBUTES_SET_NUMERICAL");
                String[] stringArray = new String[]{Integer.toString(n2), Integer.toString(n)};
                vector.add(new StateValidation(DataUsageWarning.DATA_USAGE_NUMBER_ATTRIBUTES_SET_NUMERICAL, string, stringArray));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    public Vector setAttributeToInclude(Range[] rangeArray) {
        Object object;
        Vector<StateValidation> vector = new Vector<StateValidation>();
        boolean bl = true;
        if (this.getparentWizardState() instanceof ClassificationModelBuildState) {
            object = (ClassificationAlgorithmState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            if (((ClassificationAlgorithmState)object).isDecisionTreeSelected()) {
                bl = false;
            }
        } else if (this.getparentWizardState() instanceof ClusteringModelBuildState && ((ClusteringAlgorithmState)(object = (ClusteringAlgorithmState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP))).isOClusterSelected()) {
            bl = false;
        }
        object = this.getLDSDataSource();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                if (((String)this.getLDSDataSource().getData(5, j)).equals("target") || ((String)this.getLDSDataSource().getData(5, j)).equals("caseId")) continue;
                ++n;
                String string = (String)this.getLDSDataSource().getData(2, j);
                if (string.equals("FLOAT") || string.equals("NUMBER") || string.equals("CHAR") || string.equals("DATE") || string.equals("VARCHAR2")) {
                    ((LDSDataSource)object).setData(0, j, Boolean.TRUE);
                    ++n2;
                    continue;
                }
                if (!string.equals("DM_NESTED_NUMERICALS") && !string.equals("DM_NESTED_CATEGORICALS") || !bl) continue;
                ((LDSDataSource)object).setData(0, j, Boolean.TRUE);
                ++n2;
            }
        }
        if (n2 > 0) {
            this.setState(StepStateType.DIRTY);
        }
        if (n != n2) {
            try {
                String string = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_NUMBER_ATTRIBUTES_INCLUDED");
                String[] stringArray = new String[]{Integer.toString(n2), Integer.toString(n)};
                vector.add(new StateValidation(DataUsageWarning.DATA_USAGE_NUMBER_ATTRIBUTES_INCLUDED, string, stringArray));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    public Vector setAttributeToExclude(Range[] rangeArray) {
        Vector<StateValidation> vector = new Vector<StateValidation>();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                if (((String)this.getLDSDataSource().getData(5, j)).equals("target") || ((String)this.getLDSDataSource().getData(5, j)).equals("caseId")) continue;
                ++n;
                this.getLDSDataSource().setData(0, j, Boolean.FALSE);
                ++n2;
            }
        }
        if (n2 > 0) {
            this.setState(StepStateType.DIRTY);
        }
        if (n != n2) {
            try {
                String string = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_NUMBER_ATTRIBUTES_EXCLUDED");
                String[] stringArray = new String[]{Integer.toString(n2), Integer.toString(n)};
                vector.add(new StateValidation(DataUsageWarning.DATA_USAGE_NUMBER_ATTRIBUTES_EXCLUDED, string, stringArray));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    public void restoreAttributeToDefault() {
        for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
            String string = (String)this.getLDSDataSource().getData(5, i);
            if (!string.equals("target") && !string.equals("caseId")) {
                this.getLDSDataSource().setData(5, i, (String)this.getLDSDataSource().getData(7, i));
                this.getLDSDataSource().setData(0, i, (Boolean)this.getLDSDataSource().getData(8, i));
            }
            this.getLDSDataSource().setData(3, i, (String)this.getLDSDataSource().getData(6, i));
            this.getLDSDataSource().setData(4, i, (Boolean)this.getLDSDataSource().getData(9, i));
        }
        this.setState(StepStateType.DIRTY);
    }

    protected void refreshNew() throws Exception {
        this.loadNew();
    }

    protected void refreshOld() throws Exception {
        this.setDataUsageListener(false);
    }

    protected void loadOld() throws Exception {
        this.setDataUsageListener(false);
        this.adjust2DAttributeSelection();
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean hasDataUsageChanged() {
        return this.getLDSDataSource().isDirty();
    }

    public String getSQLString() {
        return this.getLDSDataSource().getSQLString();
    }

    private class CheckForDataSourceChanges
    extends TwoDModelAdapter {
        private boolean m_newWizard;

        public CheckForDataSourceChanges(boolean bl) {
            this.m_newWizard = bl;
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            if (this.m_newWizard) {
                if (DataUsageState.this.getState() == StepStateType.VALIDATED) {
                    DataUsageState.this.setState(StepStateType.DIRTY);
                }
            } else if (DataUsageState.this.getState() == StepStateType.VALIDATED) {
                DataUsageState.this.setState(StepStateType.INCONSISTENT);
            }
        }
    }
}

