/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Iterator;
import java.util.Vector;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.datasources.TableColumnsModel;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.director.minings.AttributeExtractProcess;
import oracle.dmt.dm4j.wizard.director.minings.MiningLoader;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class DataState
extends WizardStepState {
    protected LDSDataSource m_ldsDataSource;
    protected StringBuffer m_schemaName = new StringBuffer(0);
    protected StringBuffer m_tableName = new StringBuffer(0);
    protected boolean m_multipleRecordCaseFormat = false;
    protected StringBuffer m_sequenceIDMapping = new StringBuffer(0);
    protected StringBuffer m_attributeNameMapping = new StringBuffer(0);
    protected StringBuffer m_valueMapping = new StringBuffer(0);
    protected Vector m_schemaNames = new Vector();
    protected Vector m_tableNames = new Vector();
    protected Vector m_columnNames = new Vector();
    protected TableColumnsModel m_columnModel;
    private boolean m_hidePage = true;
    protected int m_caseCount;
    protected ComplexDataStructure m_inputCDS;
    protected boolean m_isOnlyTransactional = false;
    private static int ALL_COLUMNS = 1;
    private static int STRING_COLUMNS_ONLY = 1;
    private static int NUMBER_COLUMNS_ONLY = 1;

    public DataState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public DataState(WizardState wizardState, String string, StepType stepType, boolean bl) {
        super(wizardState, string, stepType);
        this.m_multipleRecordCaseFormat = wizardState.getBrowserContext().isDataSourceTransaction();
        this.m_hidePage = bl;
    }

    protected void loadNew() throws Exception {
        this.loadSchemaNames();
        this.loadDefaultSelectedSchemaName();
        this.loadDefaultSelectedTableName();
    }

    protected void loadSchemaNames() throws Exception {
        this.m_schemaNames = DatabaseMetadata.getAccessibleSchemas(((WizardState)this.getparentWizardState()).getConnection());
    }

    protected void loadDefaultSelectedSchemaName() throws Exception {
        if (this.m_schemaNames.isEmpty()) {
            return;
        }
        if (this.getparentWizardState().getBrowserContext().getSchemaName() != null) {
            this.setSelectedSchemaName(this.getparentWizardState().getBrowserContext().getSchemaName());
        } else {
            this.setSelectedSchemaName(DM4JConnectionManager.getUser());
        }
    }

    protected void loadTableNames() throws Exception {
        this.m_tableNames = DatabaseMetadata.getAccessableTablesAndViews(((WizardState)this.getparentWizardState()).getConnection(), this.m_schemaName.toString());
        this.clearMappingColumns();
    }

    protected void loadColumnNames() throws Exception {
        this.m_columnModel = new TableColumnsModel(((WizardState)this.getparentWizardState()).getConnection(), this.m_schemaName.toString(), this.m_tableName.toString());
        this.clearMappingColumns();
    }

    protected void loadDefaultSelectedTableName() throws Exception {
        if (this.m_tableNames.isEmpty()) {
            this.setSelectedTableName("");
            return;
        }
        if (this.getparentWizardState().getBrowserContext().getDataSourceName() != null) {
            this.setSelectedTableName(this.getparentWizardState().getBrowserContext().getDataSourceName());
        } else {
            this.setSelectedTableName((String)this.m_tableNames.firstElement());
        }
    }

    protected void loadDefaultRecordCaseFormat() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            AbstractActivity abstractActivity = this.getparentWizardState().getBrowserContext().getActivity();
        } else {
            this.m_multipleRecordCaseFormat = this.m_isOnlyTransactional;
            this.clearMappingColumns();
        }
    }

    public Vector getSchemaNames() {
        return (Vector)this.m_schemaNames.clone();
    }

    public Vector getTableNames() {
        return (Vector)this.m_tableNames.clone();
    }

    public Vector getColumnNames() {
        return this.m_columnModel.getColumnsByDataType(1, true);
    }

    public Vector getColumnNamesContainingStrings() {
        return this.m_columnModel.getColumnsByDataType(2, false);
    }

    public Vector getColumnNamesContainingStringsAndNumbers() {
        return this.m_columnModel.getColumnsByDataType(4, false);
    }

    public Vector getColumnNamesContainingNumbers() {
        return this.m_columnModel.getColumnsByDataType(3, false);
    }

    public String getSelectedSchemaName() {
        return this.m_schemaName.toString();
    }

    public void setSelectedSchemaName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_schemaName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_schemaName = new StringBuffer(string);
            this.loadTableNames();
            this.loadDefaultSelectedTableName();
        }
    }

    private void clearMappingColumns() {
        this.m_sequenceIDMapping.delete(0, this.m_sequenceIDMapping.length());
        this.m_attributeNameMapping.delete(0, this.m_attributeNameMapping.length());
        this.m_valueMapping.delete(0, this.m_valueMapping.length());
    }

    public String getSelectedTableName() {
        return this.m_tableName.toString();
    }

    public void setSelectedTableName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_tableName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_tableName = new StringBuffer(string);
            this.loadColumnNames();
        }
    }

    public boolean isMultipleRecordCaseFormat() {
        return this.m_multipleRecordCaseFormat;
    }

    public void setMultipleRecordCaseFormat(boolean bl) {
        if (!this.m_multipleRecordCaseFormat == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_multipleRecordCaseFormat = bl;
        }
    }

    public void setCaseCount(int n) {
        this.m_caseCount = n;
    }

    public int getCaseCount() {
        return this.m_caseCount;
    }

    public String getCaseCountString() {
        return Integer.toString(this.m_caseCount);
    }

    public String getSequenceIDMapping() {
        return this.m_sequenceIDMapping.toString();
    }

    public void setSequenceIDMapping(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_sequenceIDMapping.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_sequenceIDMapping = new StringBuffer(string.trim());
        }
    }

    public String getAttributeNameMapping() {
        return this.m_attributeNameMapping.toString();
    }

    public void setAttributeNameMapping(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_attributeNameMapping.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_attributeNameMapping = new StringBuffer(string.trim());
        }
    }

    public String getValueMapping() {
        return this.m_valueMapping.toString();
    }

    public void setValueMapping(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_valueMapping.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_valueMapping = new StringBuffer(string.trim());
        }
    }

    public Vector getInEligibleTextSequenceAttributes(boolean bl) {
        return this.m_ldsDataSource.getInEligibleTextSequenceAttributes(bl);
    }

    public void setIsOnlyTransactional(boolean bl) {
        if (bl) {
            this.m_multipleRecordCaseFormat = true;
        }
        this.m_isOnlyTransactional = bl;
    }

    public boolean isOnlyTransactional() {
        return this.m_isOnlyTransactional;
    }

    public void validate(Vector vector) throws Exception {
        this.validateSchemaName(vector);
        if (vector.isEmpty()) {
            this.validateTableName(vector);
        }
        if (vector.isEmpty()) {
            this.validateMultipleRecordCaseMapping(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    private void validateSchemaName(Vector vector) throws Exception {
        String string = this.m_schemaName.toString();
        if (!this.isSchemaNameValid(string)) {
            String[] stringArray = new String[]{string};
            vector.add(new StateValidation((ValidationType)DataStateError.SCHEMA_NOT_IN_DB, stringArray));
        }
    }

    private void validateTableName(Vector vector) throws Exception {
        String string = this.m_tableName.toString();
        if (!this.isTableNameValid(string)) {
            String[] stringArray = new String[]{string};
            vector.add(new StateValidation((ValidationType)DataStateError.TABLE_NOT_IN_DB, stringArray));
        }
    }

    private void validateMultipleRecordCaseMapping(Vector vector) throws Exception {
        if (!this.m_multipleRecordCaseFormat) {
            return;
        }
        if (this.m_multipleRecordCaseFormat && this.m_sequenceIDMapping.length() == 0 && this.m_attributeNameMapping.length() == 0 && this.m_valueMapping.length() == 0) {
            vector.add(new StateValidation(DataStateError.MRC_NAMES_EMPTY));
            return;
        }
        if (this.m_sequenceIDMapping.length() == 0) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("MRC_FORMAT_SEQUENCE_ID")};
            vector.add(new StateValidation(DataStateError.SEQUENCE_ID_MAPPING_EMPTY, string, stringArray));
            return;
        }
        if (this.m_attributeNameMapping.length() == 0) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("MRC_FORMAT_ATTRIBUTE_NAME")};
            vector.add(new StateValidation(DataStateError.ATTRIBUTE_NAME_MAPPING_EMPTY, string, stringArray));
            return;
        }
        if (this.m_valueMapping.length() == 0) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("MRC_FORMAT_VALUE")};
            vector.add(new StateValidation(DataStateError.VALUE_MAPPING_EMPTY, string, stringArray));
            return;
        }
        if (this.m_valueMapping.toString().equals(this.m_attributeNameMapping.toString()) || this.m_valueMapping.toString().equals(this.m_sequenceIDMapping.toString()) || this.m_sequenceIDMapping.toString().equals(this.m_attributeNameMapping.toString())) {
            vector.add(new StateValidation(DataStateError.MRC_DUPLICATE_NAMES));
            return;
        }
    }

    public Vector validateMultipleRecordCaseMapping() throws Exception {
        Vector vector = new Vector();
        this.validateMultipleRecordCaseMapping(vector);
        return vector;
    }

    protected void refreshNew() throws Exception {
        this.loadSchemaNames();
        this.loadDefaultSelectedSchemaName();
        this.loadDefaultSelectedTableName();
        this.loadDefaultRecordCaseFormat();
    }

    protected void refreshOld() throws Exception {
        this.loadSchemaNames();
        MiningLoader miningLoader = ((WizardState)this.getparentWizardState()).getMiningLoader();
        miningLoader.buildPhysicalDataSpecification(this);
    }

    protected void loadOld() throws Exception {
        this.loadSchemaNames();
        MiningLoader miningLoader = ((WizardState)this.getparentWizardState()).getMiningLoader();
        miningLoader.buildPhysicalDataSpecification(this);
        miningLoader.buildLogicalDataSpecification(this);
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        AttributeExtractProcess attributeExtractProcess = null;
        try {
            if (((WizardState)this.getparentWizardState()).isNew()) {
                attributeExtractProcess = new AttributeExtractProcess(this);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("ATTRIBUTE_EXTRACT_DIALOG_TITLE"), attributeExtractProcess, true);
                attributeExtractProcess.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("ATTRIBUTE_EXTRACT_DIALOG_TITLE"), ResourceUtilities.getUILabel("ATTRIBUTE_EXTRACT_DESCRIPTION"));
                if (attributeExtractProcess.getException() != null) {
                    this.getparentWizardState().doAbortCancel(attributeExtractProcess.getException());
                } else if (progressBar.hasUserCancelled()) {
                    bl = false;
                    this.setState(StepStateType.DIRTY);
                    return bl;
                }
            } else {
                bl = ((WizardState)this.getparentWizardState()).synchronize(vector, this);
                if (!bl) {
                    this.setState(StepStateType.DIRTY);
                }
                if (bl) {
                    int n = this.getparentWizardState().getWizard().getCurrentPageIndex();
                    for (int i = n + 1; i < this.getparentWizardState().getWizard().getPageCount(); ++i) {
                        DM4JPage dM4JPage = (DM4JPage)this.getparentWizardState().getWizard().getPageAt(i);
                        dM4JPage.refresh();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
        return bl;
    }

    public LDSDataSource getLDSDataSource() {
        return this.m_ldsDataSource;
    }

    public void setLDSDataSource(LDSDataSource lDSDataSource) {
        this.m_ldsDataSource = lDSDataSource;
    }

    public int getAttributeCountFromLDSDataSource() {
        int n = 0;
        for (int i = 0; i < this.m_ldsDataSource.getRowCount(); ++i) {
            if (!((Boolean)this.m_ldsDataSource.getData(0, i)).booleanValue()) continue;
            if (this.m_ldsDataSource.getData(16, i) != null) {
                Integer n2 = (Integer)this.m_ldsDataSource.getData(10, i);
                n += n2.intValue();
                continue;
            }
            ++n;
        }
        return n;
    }

    public boolean isSchemaNameValid(String string) {
        Iterator iterator = this.m_schemaNames.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isTableNameValid(String string) {
        Iterator iterator = this.m_tableNames.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isColumnAString(String string) {
        Vector vector = this.getColumnNamesContainingStrings();
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isColumnANumber(String string) {
        Vector vector = this.getColumnNamesContainingNumbers();
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean allowDataSelection() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        return (!browserContext.getLaunchPoint().equals(LaunchPoint.CONTEXT_MENU) || browserContext.getDataSourceName() == null) && !browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
    }

    public boolean allowDataFormatSelection() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        return !browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
    }

    protected void enablePage(boolean bl) {
        DM4JWizard dM4JWizard = this.getparentWizardState().getWizard();
        int n = dM4JWizard.getPageCount();
        Class<DM4JPage> clazz = DM4JPage.class;
        DM4JPage dM4JPage = null;
        WizardPage wizardPage = null;
        for (int i = 0; i < n; ++i) {
            wizardPage = dM4JWizard.getPageAt(i);
            if (!clazz.isInstance(wizardPage) || !(dM4JPage = (DM4JPage)wizardPage).getStepType().equals(StepType.DATA_STEP)) continue;
            dM4JPage.setEnabled(bl);
            dM4JPage.setVisible(bl);
        }
    }

    public void setInputCDS(ComplexDataStructure complexDataStructure) {
        this.m_inputCDS = complexDataStructure;
    }

    public ComplexDataStructure getInputCDS() {
        return this.m_inputCDS;
    }
}

