/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.HashMap;
import java.util.Vector;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.dmt.dm4j.activity.steps.ClusteringApplyStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.ClusteringClusterNumberSource;
import oracle.dmt.dm4j.wizard.director.minings.ClusteringModelApplyLoader;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyOutputOptionState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.ApplyOutputOptionError;

public class ClusteringApplyOutputOptionState
extends ApplyOutputOptionState {
    protected ClusteringClusterNumberSource m_clusterNumberDS;
    protected ClusteringApplyStepOptions m_options;
    CheckForDataSourceChanges m_dataSourcelistener = new CheckForDataSourceChanges();

    public ClusteringApplyOutputOptionState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof ClusteringApplyStepOptions) {
            this.m_options = (ClusteringApplyStepOptions)browserContext.getOptions();
        }
    }

    protected void loadNew() throws Exception {
        super.loadNew();
        this.loadDefaults();
    }

    private void loadDefaults() throws Exception {
        this.m_clusterNumberDS = this.m_options.getClusterNumbersDataSource();
        this.setDataUsageListener();
    }

    protected void setDataUsageListener() {
        this.m_clusterNumberDS.addModelListener((TwoDModelListener)this.m_dataSourcelistener);
    }

    protected void validateSpecificPredictions(Vector vector) throws Exception {
        if (this.m_clusterNumberDS.getIncludedCount() == 0) {
            vector.add(new StateValidation(ApplyOutputOptionError.APPLY_OPTION_REQUIRES_CLUSTER_ID));
        }
    }

    protected void validateTopNPredictions(Vector vector) throws Exception {
        super.validateTopNPredictions(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            int n = this.m_clusterNumberDS.getRowCount();
            if (this.getNumberOfTopNPredictions() <= 0 || this.getNumberOfTopNPredictions() > n) {
                String string = ResourceUtilities.getstateExceptionMessage("APPLY_OPTION_MAXIMUM_RANKED_PREDICTIONS");
                String[] stringArray = new String[]{String.valueOf(n)};
                vector.add(new StateValidation(ApplyOutputOptionError.APPLY_OPTION_BOTN_MAXIMUM_RANKED_PREDICTIONS, string, stringArray));
            }
        }
    }

    protected void refreshNew() throws Exception {
        super.refreshNew();
        this.loadDefaults();
    }

    protected void refreshOld() throws Exception {
        super.refreshOld();
        ClusteringModelApplyLoader clusteringModelApplyLoader = (ClusteringModelApplyLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        clusteringModelApplyLoader.buildApplyOption(this);
    }

    protected void loadOld() throws Exception {
        super.loadOld();
        ClusteringModelApplyLoader clusteringModelApplyLoader = (ClusteringModelApplyLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        clusteringModelApplyLoader.buildApplyOption(this);
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public void setClusterNumbers(ClusteringClusterNumberSource clusteringClusterNumberSource) {
        this.m_clusterNumberDS = clusteringClusterNumberSource;
    }

    public ClusteringClusterNumberSource getClusterNumbers() {
        return this.m_clusterNumberDS;
    }

    public Vector getClusterNumbersAsVector(boolean bl) {
        return this.m_clusterNumberDS.getIncludedClusterIDs(bl);
    }

    public String getClusterIDDataType() {
        return "NUMBER";
    }

    public String getLeafClusterIDCount() {
        return Integer.toString(this.m_clusterNumberDS.getRowCount());
    }

    public int getLeafClusterIDCountInteger() {
        return this.m_clusterNumberDS.getRowCount();
    }

    public HashMap getClusterPredictionColumns(boolean bl) {
        return this.m_clusterNumberDS.getClusterPredictionColumns(bl);
    }

    private class CheckForDataSourceChanges
    extends TwoDModelAdapter {
        private CheckForDataSourceChanges() {
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            if (ClusteringApplyOutputOptionState.this.getState() == StepStateType.VALIDATED) {
                ClusteringApplyOutputOptionState.this.setState(StepStateType.DIRTY);
            }
        }
    }
}

