/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.sql.SQLException;
import java.util.Vector;
import javax.datamining.MiningAlgorithm;
import javax.datamining.base.Model;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TestSettingError;

public class ClassificationTestSettingState
extends WizardStepState {
    public static final String MFS_NAME = "CrossValidateTestMFSName";
    private final int NAME_LENGTH_MAX = 64;
    protected boolean m_standardTest = true;
    protected boolean m_crossValidationTest = false;
    protected StringBuffer m_crossValidationMFSName = new StringBuffer("CrossValidateTestMFSName");

    public ClassificationTestSettingState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    protected void loadNew() throws Exception {
        this.setDefaults();
    }

    protected void loadOld() throws Exception {
    }

    protected void refreshNew() throws Exception {
        this.loadNew();
    }

    protected void refreshOld() throws Exception {
        this.loadOld();
    }

    protected void setDefaults() throws SQLException {
    }

    protected void validateTestOptions(Vector vector) throws Exception {
        if (this.m_crossValidationTest) {
            this.validateNBModel(vector);
            this.validateCrossValidMFSName(vector);
        }
        if (!this.m_crossValidationTest && !this.m_standardTest) {
            vector.add(new StateValidation(TestSettingError.CVT_NO_TEST_OPTION_CHOOSEN));
        }
    }

    private void validateNBModel(Vector vector) throws Exception {
        ModelState modelState = (ModelState)this.getparentWizardState().getStep(StepType.MODEL_STEP);
        Model model = modelState.restoreModel();
        if (model != null && model.getMiningAlgorithm().compareTo(MiningAlgorithm.naiveBayes) != 0) {
            vector.add(new StateValidation(TestSettingError.CVT_ABN_MODEL_NOT_ALLOWED));
        }
    }

    private void validateCrossValidMFSName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.m_crossValidationMFSName.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("TEST_CROSS_VALID_MFS_NAME")};
            vector.add(new StateValidation(TestSettingError.CVT_MFS_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_crossValidationMFSName.toString(), 64)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("TEST_CROSS_VALID_MFS_NAME"), Integer.toString(64)};
            vector.add(new StateValidation(TestSettingError.CVT_MFS_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateTestOptions(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public void setStandardTest(boolean bl) {
        if (!this.m_standardTest == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_standardTest = bl;
            this.m_crossValidationTest = !bl;
        }
    }

    public boolean isStandardTest() {
        return this.m_standardTest;
    }

    public void setCrossValidationTest(boolean bl) {
        if (!this.m_crossValidationTest == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_crossValidationTest = bl;
            this.m_standardTest = !bl;
        }
    }

    public boolean isCrossValidationTest() {
        return this.m_crossValidationTest;
    }

    public void setCrossValidationMFSName(String string) {
        String string2;
        if (this.m_crossValidationMFSName != null && !string.equals(string2 = this.m_crossValidationMFSName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_crossValidationMFSName = new StringBuffer(string.trim());
        }
    }

    public String getCrossValidationMFSName() {
        return this.m_crossValidationMFSName.toString();
    }
}

