/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.tree.TreeHomogeneityMetric;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.director.minings.ClassificationModelBuildLoader;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AdaptiveBayesNetworkAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DecisionTreeAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.GeneralizedLinearModelAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.NaiveBayesAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SupportVectorMachineAlgorithmState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.algorithm.abn.OraABNModelType;

public class ClassificationAlgorithmState
extends WizardStepState {
    private boolean m_decisionTreeSelected = false;
    private boolean m_adaptiveNaiveBayesSelected = false;
    private boolean m_naiveBayesSelected = true;
    private boolean m_supportVectorMachineSelected = false;
    private boolean m_generializedLinearModelSelected = false;
    private DecisionTreeAlgorithmState m_dtAlgorithmState;
    private AdaptiveBayesNetworkAlgorithmState m_abnAlgorithmState;
    private NaiveBayesAlgorithmState m_nbAlgorithmState;
    private SupportVectorMachineAlgorithmState m_svmAlgorithmState;
    private GeneralizedLinearModelAlgorithmState m_glmAlgorithmState;

    public ClassificationAlgorithmState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            AbstractActivity abstractActivity = this.getparentWizardState().getBrowserContext().getActivity();
            ActivityType activityType = abstractActivity.getType();
            if (activityType == ActivityType.ADAPTIVE_NAIVE_BAYES) {
                this.setAdaptiveNaiveBayesSelected(true);
            } else if (activityType == ActivityType.NAIVE_BAYES) {
                this.setNaiveBayesSelected(true);
            } else if (activityType == ActivityType.SVM_CLASSIFICATION) {
                this.setSupportVectorMachineSelected(true);
            } else if (activityType == ActivityType.DECISION_TREE) {
                this.setDecisionTreeSelected(true);
            } else if (activityType == ActivityType.GLM_CLASSIFICATION) {
                this.setGenerializedLinearModelSelected(true);
            }
        }
    }

    public void setDecisionTreeSelected(boolean bl) {
        if (this.m_decisionTreeSelected != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_decisionTreeSelected = bl;
            if (bl) {
                this.m_supportVectorMachineSelected = false;
                this.m_naiveBayesSelected = false;
                this.m_adaptiveNaiveBayesSelected = false;
                this.m_generializedLinearModelSelected = false;
            }
        }
    }

    public boolean getDecisionTreeSelected() {
        return this.m_decisionTreeSelected;
    }

    public boolean isDecisionTreeSelected() {
        return this.m_decisionTreeSelected;
    }

    public void setAdaptiveNaiveBayesSelected(boolean bl) {
        if (this.m_adaptiveNaiveBayesSelected != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_adaptiveNaiveBayesSelected = bl;
            if (bl) {
                this.m_supportVectorMachineSelected = false;
                this.m_naiveBayesSelected = false;
                this.m_decisionTreeSelected = false;
                this.m_generializedLinearModelSelected = false;
            }
        }
    }

    public boolean getAdaptiveNaiveBayesSelected() {
        return this.m_adaptiveNaiveBayesSelected;
    }

    public boolean isAdaptiveNaiveBayesSelected() {
        return this.m_adaptiveNaiveBayesSelected;
    }

    public void setNaiveBayesSelected(boolean bl) {
        if (this.m_naiveBayesSelected != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_naiveBayesSelected = bl;
            if (bl) {
                this.m_decisionTreeSelected = false;
                this.m_supportVectorMachineSelected = false;
                this.m_adaptiveNaiveBayesSelected = false;
                this.m_generializedLinearModelSelected = false;
            }
        }
    }

    public boolean getNaiveBayesSelected() {
        return this.m_naiveBayesSelected;
    }

    public boolean isNaiveBayesSelected() {
        return this.m_naiveBayesSelected;
    }

    public void setSupportVectorMachineSelected(boolean bl) {
        if (this.m_supportVectorMachineSelected != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_supportVectorMachineSelected = bl;
            if (bl) {
                this.m_adaptiveNaiveBayesSelected = false;
                this.m_naiveBayesSelected = false;
                this.m_decisionTreeSelected = false;
                this.m_generializedLinearModelSelected = false;
            }
        }
    }

    public boolean getSupportVectorMachineSelected() {
        return this.m_supportVectorMachineSelected;
    }

    public boolean isSupportVectorMachineSelected() {
        return this.m_supportVectorMachineSelected;
    }

    public void setGenerializedLinearModelSelected(boolean bl) {
        if (this.m_generializedLinearModelSelected != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_generializedLinearModelSelected = bl;
            if (bl) {
                this.m_adaptiveNaiveBayesSelected = false;
                this.m_naiveBayesSelected = false;
                this.m_decisionTreeSelected = false;
                this.m_supportVectorMachineSelected = false;
            }
        }
    }

    public boolean getGenerializedLinearModelSelected() {
        return this.m_generializedLinearModelSelected;
    }

    public boolean isGenerializedLinearModelSelected() {
        return this.m_generializedLinearModelSelected;
    }

    public LDSDataSource getLDSDataSource() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getLDSDataSource();
    }

    public String getAttributeCount() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return Integer.toString(modelDataState.getAttributeCountFromLDSDataSource());
    }

    public String getActiveAttributeCountExcludingTargets() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return Integer.toString(modelDataState.getActiveAttributeCountExcludingTargets());
    }

    public int getActiveAttributeCountExcludingTargetsInteger() {
        return Integer.parseInt(this.getActiveAttributeCountExcludingTargets());
    }

    public String getCaseCount() {
        DataState dataState = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return Integer.toString(dataState.getCaseCount());
    }

    public int getCaseCountInteger() {
        return Integer.parseInt(this.getCaseCount());
    }

    public DecisionTreeAlgorithmState getDecisionTree() {
        if (this.m_dtAlgorithmState == null) {
            this.loadDefaultDTSetting();
        }
        return this.m_dtAlgorithmState;
    }

    public void setDecisionTree(DecisionTreeAlgorithmState decisionTreeAlgorithmState) {
        this.m_dtAlgorithmState = decisionTreeAlgorithmState;
    }

    public AdaptiveBayesNetworkAlgorithmState getAdaptiveNetworkBayes() {
        if (this.m_abnAlgorithmState == null) {
            this.loadDefaultABNSetting();
        }
        return this.m_abnAlgorithmState;
    }

    public void setAdaptiveNetworkBayes(AdaptiveBayesNetworkAlgorithmState adaptiveBayesNetworkAlgorithmState) {
        this.m_abnAlgorithmState = adaptiveBayesNetworkAlgorithmState;
    }

    public NaiveBayesAlgorithmState getNaiveBayes() {
        if (this.m_nbAlgorithmState == null) {
            this.loadDefaultNBSetting();
        }
        return this.m_nbAlgorithmState;
    }

    public void setNaiveBayes(NaiveBayesAlgorithmState naiveBayesAlgorithmState) {
        this.m_nbAlgorithmState = naiveBayesAlgorithmState;
    }

    public SupportVectorMachineAlgorithmState getSupportVectorMachine() {
        if (this.m_svmAlgorithmState == null) {
            this.loadDefaultSVMSetting();
        }
        return this.m_svmAlgorithmState;
    }

    public void setSupportVectorMachineAlgorithm(SupportVectorMachineAlgorithmState supportVectorMachineAlgorithmState) {
        this.m_svmAlgorithmState = supportVectorMachineAlgorithmState;
    }

    public GeneralizedLinearModelAlgorithmState getGenerializedLinearModel() {
        if (this.m_glmAlgorithmState == null) {
            this.loadDefaultGLMSetting();
        }
        return this.m_glmAlgorithmState;
    }

    public void setGeneralizedLinearModelAlgorithm(GeneralizedLinearModelAlgorithmState generalizedLinearModelAlgorithmState) {
        this.m_glmAlgorithmState = generalizedLinearModelAlgorithmState;
    }

    public boolean allowAlgorithmSelection() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        return !browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
    }

    protected void refreshOld() throws Exception {
        this.refreshABNSetting();
    }

    protected void refreshNew() throws Exception {
        this.refreshABNSetting();
    }

    protected void loadOld() throws Exception {
        ClassificationModelBuildLoader classificationModelBuildLoader = (ClassificationModelBuildLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        classificationModelBuildLoader.buildAlgorithmSetting(this);
        this.getNaiveBayes();
        this.getAdaptiveNetworkBayes();
        this.getSupportVectorMachine();
        this.getDecisionTree();
        this.getGenerializedLinearModel();
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void loadNew() throws Exception {
        this.loadDefaults();
    }

    protected void refreshABNSetting() {
    }

    protected void loadDefaultABNSetting() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        String string = modelDataState.getActiveAttributeCountExcludingTargets() > modelDataState.getCaseCount() ? "1" : (modelDataState.getCaseCount() < 300 ? "1" : "10");
        String string2 = "25";
        String string3 = "10";
        String string4 = "1";
        this.m_abnAlgorithmState = new AdaptiveBayesNetworkAlgorithmState(this, OraABNModelType.singleFeature, new Integer(0), new Integer(string), new Integer(string2), new Integer(string3), new Integer(string4));
    }

    protected void loadDefaults() {
        this.loadDefaultABNSetting();
        this.loadDefaultNBSetting();
        this.loadDefaultSVMSetting();
        this.loadDefaultDTSetting();
        this.loadDefaultGLMSetting();
    }

    protected void loadDefaultNBSetting() {
        this.m_nbAlgorithmState = new NaiveBayesAlgorithmState(this, new Double(0.0), new Double(0.0));
    }

    protected void loadDefaultSVMSetting() {
        this.m_svmAlgorithmState = new SupportVectorMachineAlgorithmState(this, KernelFunction.systemDetermined, new Double(0.001), new Double(0.0), new Double(0.0), new Integer(50), true);
    }

    protected void loadDefaultDTSetting() {
        this.m_dtAlgorithmState = new DecisionTreeAlgorithmState(this, new Integer(7), new Integer(10), new Double(0.05), new Integer(20), new Double(0.1), TreeHomogeneityMetric.gini);
    }

    protected void loadDefaultGLMSetting() {
        this.m_glmAlgorithmState = new GeneralizedLinearModelAlgorithmState(this, new Double(0.95), false, false, null, null);
    }

    public void validate(Vector vector) throws Exception {
        if (this.isAdaptiveNaiveBayesSelected()) {
            this.m_abnAlgorithmState.validate(vector);
        }
        if (this.isNaiveBayesSelected()) {
            this.m_nbAlgorithmState.validate(vector);
        }
        if (this.isDecisionTreeSelected()) {
            this.m_dtAlgorithmState.validate(vector);
        }
        if (this.isSupportVectorMachineSelected()) {
            this.m_svmAlgorithmState.validate(vector);
        }
        if (this.isGenerializedLinearModelSelected()) {
            this.m_glmAlgorithmState.validate(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }
}

