/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.steps.ARBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AlgorithmSettingState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.AssocAlgorithmStateError;

public class AssocAlgorithmState
extends AlgorithmSettingState {
    private Double m_minSupport;
    private Double m_defaultMinSupport;
    private Double m_minConfidence;
    private Double m_defaultMinConfidence;
    private Integer m_numOfAttr;
    private Integer m_defaultNumOfAttr;
    private boolean m_numOfAttrSelected = false;
    private boolean m_defaultNumOfAttrSelected = false;
    private ARBuildStepOptions m_options = null;

    public AssocAlgorithmState(WizardStepState wizardStepState, Double d, Double d2, boolean bl, Integer n) {
        super(wizardStepState);
        this.initialize(d, d2, bl, n);
    }

    public AssocAlgorithmState(Double d, Double d2, boolean bl, Integer n) {
        this.initialize(d, d2, bl, n);
    }

    private void initialize(Double d, Double d2, boolean bl, Integer n) {
        BrowserContext browserContext = this.m_wizardStepState.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof ARBuildStepOptions) {
            this.m_options = (ARBuildStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_minSupport = this.m_options.getMinimumSupport();
            this.m_minConfidence = this.m_options.getMinimumConfidence();
            this.m_numOfAttr = n == null ? new Integer(0) : this.m_options.getNumberOfAttributes();
            this.m_numOfAttrSelected = this.m_options.getNumberOfAttributesSelected();
        } else {
            this.m_minSupport = d;
            this.m_minConfidence = d2;
            this.m_numOfAttr = n == null ? new Integer(0) : n;
            this.m_numOfAttrSelected = bl;
        }
        this.m_defaultMinSupport = this.m_minSupport;
        this.m_defaultMinConfidence = this.m_minConfidence;
        this.m_defaultNumOfAttr = this.m_numOfAttr;
        this.m_defaultNumOfAttrSelected = this.m_numOfAttrSelected;
    }

    public void setMinSupport(Double d) {
        if (this.m_minSupport == null || d == null || this.m_minSupport.compareTo(d) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_minSupport = d;
            if (this.m_options != null) {
                this.m_options.setMinimumSupport(d);
            }
        }
    }

    public Double getMinSupport() {
        return this.m_minSupport;
    }

    public void setMinConfidence(Double d) {
        if (this.m_minConfidence == null || d == null || this.m_minConfidence.compareTo(d) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_minConfidence = d;
            if (this.m_options != null) {
                this.m_options.setMinimumConfidence(d);
            }
        }
    }

    public Double getMinConfidence() {
        return this.m_minConfidence;
    }

    public void setNumOfAttr(Integer n) {
        if (this.m_numOfAttr == null || n == null || this.m_numOfAttr.compareTo(n) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_numOfAttr = n;
            if (this.m_options != null) {
                this.m_options.setNumberOfAttributes(n);
            }
        }
    }

    public Integer getNumOfAttr() {
        return this.m_numOfAttr;
    }

    public void setNumOfAttrSelected(boolean bl) {
        if (this.m_numOfAttrSelected != bl) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_numOfAttrSelected = bl;
            if (this.m_options != null) {
                this.m_options.setNumberOfAttributesSelected(bl);
            }
        }
    }

    public boolean getNumOfAttrSelected() {
        return this.m_numOfAttrSelected;
    }

    protected void validateMinSupport(Vector vector) throws Exception {
        Double d = new Double(0.0);
        Double d2 = new Double(100.0);
        if (this.m_minSupport == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ASSOC_MINIMUM_SUPPORT")};
            vector.add(new StateValidation(AssocAlgorithmStateError.ASSOC_MINIMUM_SUPPORT_EMPTY, string, stringArray));
            return;
        }
        if (this.m_minSupport.compareTo(d) < 0 || this.m_minSupport.compareTo(d2) > 0) {
            vector.add(new StateValidation(AssocAlgorithmStateError.ASSOC_MINIMUM_SUPPORT_INVALID));
        }
    }

    protected void validateMinConfidence(Vector vector) throws Exception {
        Double d = new Double(0.0);
        Double d2 = new Double(100.0);
        if (this.m_minConfidence == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ASSOC_MINIMUM_CONFIDENCE")};
            vector.add(new StateValidation(AssocAlgorithmStateError.ASSOC_MINIMUM_CONFIDENCE_EMPTY, string, stringArray));
            return;
        }
        if (this.m_minConfidence.compareTo(d) < 0 || this.m_minConfidence.compareTo(d2) > 0) {
            vector.add(new StateValidation(AssocAlgorithmStateError.ASSOC_MINIMUM_CONFIDENCE_INVALID));
        }
    }

    protected void validateNumOfAttr(Vector vector) throws Exception {
        Integer n = new Integer(2);
        Integer n2 = new Integer(20);
        if (this.m_numOfAttrSelected) {
            if (this.m_numOfAttr == null) {
                String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("ASSOC_MAXIMUM_RULE_LENGTH")};
                vector.add(new StateValidation(AssocAlgorithmStateError.ASSOC_MAXIMUM_RULE_LENGTH_EMPTY, string, stringArray));
                return;
            }
            if (this.m_numOfAttr.compareTo(n) < 0 || this.m_numOfAttr.compareTo(n2) > 0) {
                vector.add(new StateValidation(AssocAlgorithmStateError.ASSOC_MAXIMUM_RULE_LENGTH_INVALID));
            }
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateMinSupport(vector);
        this.validateMinConfidence(vector);
        this.validateNumOfAttr(vector);
    }

    public Vector validate() throws Exception {
        Vector vector = new Vector();
        this.validate(vector);
        return vector;
    }

    public void restoreSettingsToDefault() {
        this.m_minSupport = this.m_defaultMinSupport;
        this.m_minConfidence = this.m_defaultMinConfidence;
        this.m_numOfAttr = this.m_defaultNumOfAttr;
        this.m_numOfAttrSelected = this.m_defaultNumOfAttrSelected;
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
    }
}

