/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.activity.steps.ApplyStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.director.minings.ModelApplyLoader;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.ApplyOutputOptionError;

public abstract class ApplyOutputOptionState
extends WizardStepState {
    protected static final Integer MAXIMUM_RANKED_PREDICTIONS = new Integer(1000000);
    protected static final int MAXIMUM_STRING_TARGET_VALUE_LENGTH = 64;
    protected boolean m_specificPredictions = false;
    protected boolean m_topNPredictions = false;
    protected boolean m_botNPredictions = false;
    protected Integer m_numberOfTopNPredictions;
    protected Integer m_numberOfBottomNPredictions;
    protected boolean m_mostProbable;
    protected ApplyStepOptions m_options;

    public ApplyOutputOptionState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof ApplyStepOptions) {
            this.m_options = (ApplyStepOptions)browserContext.getOptions();
        }
    }

    public void setSpecificPredictions(boolean bl) {
        if (!this.m_specificPredictions == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_specificPredictions = bl;
            if (bl) {
                this.m_topNPredictions = false;
                this.m_mostProbable = false;
                this.m_options.setCurApplyOption(ApplyStepOptions.SPECIFIC_TARGETS);
            } else {
                this.m_mostProbable = true;
            }
        }
    }

    public boolean isSpecificPredictions() {
        return this.m_specificPredictions;
    }

    public void setTopNPredictions(boolean bl) {
        if (!this.m_topNPredictions == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_topNPredictions = bl;
            if (bl) {
                this.m_specificPredictions = false;
                this.m_mostProbable = false;
                this.m_options.setCurApplyOption(ApplyStepOptions.TOPN_TARGETS);
            } else {
                this.m_mostProbable = true;
            }
        }
    }

    public boolean isTopNPredictions() {
        return this.m_topNPredictions;
    }

    public void setBottomNPredictions(boolean bl) {
        if (!this.m_botNPredictions == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_botNPredictions = bl;
            this.m_topNPredictions = !bl;
            this.m_specificPredictions = !bl;
        }
    }

    public boolean isBottomNPredictions() {
        return this.m_botNPredictions;
    }

    public void setNumberOfTopNPredictions(Integer n) {
        if (this.m_numberOfTopNPredictions == null || n == null || this.m_numberOfTopNPredictions.compareTo(n) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            if (this.m_options != null) {
                this.m_options.setCurNumberOfTopNPredictions(n);
            }
            this.m_numberOfTopNPredictions = n;
        }
    }

    public Integer getNumberOfTopNPredictions() {
        return this.m_numberOfTopNPredictions;
    }

    public void setNumberOfBottomNPredictions(Integer n) {
        if (this.m_numberOfBottomNPredictions == null || n == null || this.m_numberOfBottomNPredictions.compareTo(n) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_numberOfBottomNPredictions = n;
        }
    }

    public Integer getNumberOfBottomNPredictions() {
        return this.m_numberOfBottomNPredictions;
    }

    protected void loadNew() throws Exception {
        this.loadDefaults();
    }

    private void loadDefaults() {
        if (this.m_options != null) {
            this.m_specificPredictions = this.m_options.getCurApplyOption().compareTo(ApplyStepOptions.SPECIFIC_TARGETS) == 0;
            this.m_topNPredictions = this.m_options.getCurApplyOption().compareTo(ApplyStepOptions.TOPN_TARGETS) == 0;
            this.m_mostProbable = this.m_options.getCurApplyOption().compareTo(ApplyStepOptions.PROBABLE_TARGET) == 0;
            this.m_numberOfTopNPredictions = this.m_options.getCurNumberOfTopNPredictions();
        } else {
            this.setMostProbable(true);
            this.m_numberOfTopNPredictions = new Integer(1);
            this.m_numberOfBottomNPredictions = new Integer(1);
        }
    }

    public void setMostProbable(boolean bl) {
        if (!this.m_mostProbable == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_mostProbable = bl;
            if (bl) {
                this.m_specificPredictions = false;
                this.m_topNPredictions = false;
                this.m_options.setCurApplyOption(ApplyStepOptions.PROBABLE_TARGET);
            } else {
                this.m_specificPredictions = true;
            }
        }
    }

    public boolean isMostProbable() {
        return this.m_mostProbable;
    }

    protected void validateBottomNPredictions(Vector vector) throws Exception {
        Integer n = new Integer(0);
        if (this.m_numberOfBottomNPredictions == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("APPLY_OPTION_BOTN_VALUE")};
            vector.add(new StateValidation(ApplyOutputOptionError.BOTTOM_N_EMPTY, string, stringArray));
            return;
        }
        if (this.m_numberOfBottomNPredictions.compareTo(n) <= 0 || this.m_numberOfBottomNPredictions.compareTo(MAXIMUM_RANKED_PREDICTIONS) > 0) {
            String string = ResourceUtilities.getstateExceptionMessage("APPLY_OPTION_MAXIMUM_RANKED_PREDICTIONS");
            String[] stringArray = new String[]{String.valueOf(MAXIMUM_RANKED_PREDICTIONS)};
            vector.add(new StateValidation(ApplyOutputOptionError.APPLY_OPTION_BOTN_MAXIMUM_RANKED_PREDICTIONS, string, stringArray));
        }
    }

    protected void validateTopNPredictions(Vector vector) throws Exception {
        Integer n = new Integer(0);
        if (this.m_numberOfTopNPredictions == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("APPLY_OPTION_BOTN_VALUE")};
            vector.add(new StateValidation(ApplyOutputOptionError.TOP_N_EMPTY, string, stringArray));
        }
    }

    protected abstract void validateSpecificPredictions(Vector var1) throws Exception;

    private void validateOptions(Vector vector) throws Exception {
        if (this.isBottomNPredictions()) {
            this.validateBottomNPredictions(vector);
        } else if (this.isTopNPredictions()) {
            this.validateTopNPredictions(vector);
        } else if (this.isSpecificPredictions()) {
            this.validateSpecificPredictions(vector);
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateOptions(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    protected void refreshNew() throws Exception {
        this.loadDefaults();
    }

    protected void refreshOld() throws Exception {
        this.loadDefaults();
        ModelApplyLoader modelApplyLoader = (ModelApplyLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        modelApplyLoader.buildApplyOption(this);
    }

    protected void loadOld() throws Exception {
        this.loadDefaults();
        ModelApplyLoader modelApplyLoader = (ModelApplyLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        modelApplyLoader.buildApplyOption(this);
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public Vector getListOfSpecificPredictionValues() {
        return null;
    }

    public String getTargetAttributeDataType() {
        return null;
    }

    private void enableTargetValuePage(boolean bl) {
        DM4JWizard dM4JWizard = this.getparentWizardState().getWizard();
        if (dM4JWizard != null) {
            int n = dM4JWizard.getPageCount();
            Class<DM4JPage> clazz = DM4JPage.class;
            DM4JPage dM4JPage = null;
            WizardPage wizardPage = null;
            for (int i = 0; i < n; ++i) {
                wizardPage = dM4JWizard.getPageAt(i);
                if (!clazz.isInstance(wizardPage) || !(dM4JPage = (DM4JPage)wizardPage).getStepType().equals(StepType.TARGET_VALUE_STEP)) continue;
                dM4JPage.setEnabled(bl);
                dM4JPage.setVisible(bl);
            }
        }
    }
}

