/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.ClassificationApplyStepOptions;
import oracle.dmt.dm4j.activity.steps.TestMetricStep;
import oracle.dmt.dm4j.activity.wizard.validation.ApplyCostMatrixStateError;
import oracle.dmt.dm4j.activity.wizard.validation.ApplyCostMatrixStateWarning;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class ApplyCostMatrixState
extends WizardStepState {
    protected boolean m_isBuildActivityAllowed = true;
    protected boolean m_isTestActivityAllowed = true;
    protected boolean m_isNoneActivityAllowed = false;
    protected Vector m_testActivities = null;
    protected String m_selectedBuildActivity = null;
    protected String m_selectedTestActivity = null;
    protected ClassificationApplyStepOptions m_options;

    public ApplyCostMatrixState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof ClassificationApplyStepOptions) {
            this.m_options = (ClassificationApplyStepOptions)browserContext.getOptions();
        }
    }

    protected void loadNew() throws Exception {
        this.loadDefaults();
    }

    protected void loadOld() throws Exception {
    }

    protected void refreshOld() throws Exception {
    }

    protected void refreshNew() throws Exception {
        this.loadDefaults();
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaults() throws Exception {
        Connection connection = DM4JConnectionManager.getDbConnection();
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            this.m_selectedBuildActivity = dMEMetadata.getBuildActivityNameForModel(connection, this.m_options.getModelName());
            this.m_isBuildActivityAllowed = this.m_options.isBuildActivityAllowed();
            this.m_testActivities = this.m_options.getTestActivities();
            this.m_isTestActivityAllowed = this.m_options.isTestActivityAllowed();
            this.m_isNoneActivityAllowed = this.m_options.isNoneActivityAllowed();
            if (this.m_options.getCurUseCostMatrixFromBuilActivity() != null && this.m_options.getCurUseCostMatrixFromBuilActivity() == Boolean.FALSE) {
                this.m_selectedTestActivity = this.m_options.getCurCostMatrixActivity();
            } else if (this.m_testActivities.size() > 0) {
                this.m_selectedTestActivity = (String)this.m_testActivities.get(this.m_testActivities.size() - 1);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public void setUseBuildActivity(boolean bl) {
        if (this.m_options.getCurUseCostMatrixFromBuilActivity() != (bl ? Boolean.TRUE : null)) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_options.setCurUseCostMatrixFromBuilActivity(bl ? Boolean.TRUE : null);
        }
    }

    public void setUseTestActivity(boolean bl) {
        if (this.m_options.getCurUseCostMatrixFromBuilActivity() != (bl ? Boolean.FALSE : null)) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_options.setCurUseCostMatrixFromBuilActivity(bl ? Boolean.FALSE : null);
        }
    }

    public void setUseNoneActivity(boolean bl) {
        if (this.m_options.getCurUseCostMatrixFromBuilActivity() != (bl ? null : Boolean.TRUE)) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_options.setCurUseCostMatrixFromBuilActivity(bl ? null : Boolean.TRUE);
        }
    }

    public boolean useBuildActivity() {
        return this.m_options.getCurUseCostMatrixFromBuilActivity() != null ? this.m_options.getCurUseCostMatrixFromBuilActivity().equals(Boolean.TRUE) : false;
    }

    public boolean useTestActivity() {
        return this.m_options.getCurUseCostMatrixFromBuilActivity() != null ? this.m_options.getCurUseCostMatrixFromBuilActivity().equals(Boolean.FALSE) : false;
    }

    public boolean useNoneActivity() {
        return this.m_options.getCurUseCostMatrixFromBuilActivity() == null;
    }

    public String getSelectedBuildActivity() {
        return this.m_selectedBuildActivity;
    }

    public void setSelectedBuildActivity(String string) {
        this.m_selectedBuildActivity = string;
    }

    public Vector getTestActivities() {
        return this.m_testActivities;
    }

    public String getSelectedTestActivity() {
        return this.m_selectedTestActivity;
    }

    public void setSelectedTestActivity(String string) {
        if (this.m_selectedTestActivity == null || string == null || this.m_selectedTestActivity.compareTo(string) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            if (this.m_options != null) {
                this.m_options.setCurCostMatrixActivity(string);
            }
            this.m_selectedTestActivity = string;
        }
    }

    public String getCostMatrixName() {
        String string = null;
        AbstractActivity abstractActivity = null;
        try {
            Table table;
            TestMetricStep testMetricStep;
            if (this.useBuildActivity()) {
                abstractActivity = AbstractActivity.restore(this.m_selectedBuildActivity);
            } else if (this.useTestActivity()) {
                abstractActivity = AbstractActivity.restore(this.m_selectedTestActivity);
            }
            if (abstractActivity != null && (testMetricStep = abstractActivity.findTestMetricStep()).getIsComplete() && (string = testMetricStep.getThresholdCostMatrix()) == null && (table = testMetricStep.getOutputCostMatrix()) != null) {
                string = table.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public void validate(Vector vector) throws Exception {
        if (this.useTestActivity() && this.m_selectedTestActivity == null) {
            vector.add(new StateValidation(ApplyCostMatrixStateError.TEST_METRIC_NOT_SELECTED));
        } else {
            TestMetricStep testMetricStep;
            AbstractActivity abstractActivity = null;
            if (this.useBuildActivity()) {
                abstractActivity = AbstractActivity.restore(this.m_selectedBuildActivity);
            } else if (this.useTestActivity()) {
                abstractActivity = AbstractActivity.restore(this.m_selectedTestActivity);
            }
            if (abstractActivity != null && !(testMetricStep = abstractActivity.findTestMetricStep()).getIsComplete()) {
                vector.add(new StateValidation(ApplyCostMatrixStateWarning.TEST_METRIC_NOT_COMPLETED));
            }
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public boolean isBuildActivityAllowed() {
        return this.m_isBuildActivityAllowed;
    }

    public boolean isTestActivityAllowed() {
        return this.m_isTestActivityAllowed;
    }

    public boolean isNoneActivityAllowed() {
        return this.m_isNoneActivityAllowed;
    }
}

