/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.AbstractApplyActivity;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.ExplainState;
import oracle.dmt.dm4j.wizard.state.minings.PredictState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.OutputTableState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.OutputTableError;

public class AppliedOutputTableState
extends OutputTableState {
    protected StringBuffer m_tableName = new StringBuffer(0);
    protected StringBuffer m_outputtableName = new StringBuffer(0);
    private static int MAX_LENGTH = 30;

    public AppliedOutputTableState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    protected void loadNew() throws Exception {
        super.loadNew();
        this.loadDefaultSelectedTableName();
    }

    protected void loadDefaultSelectedTableName() throws Exception {
        DataState dataState = (DataState)((WizardState)this.getparentWizardState()).getStep(StepType.DATA_STEP);
        String string = dataState.getSelectedTableName();
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            AbstractActivity abstractActivity = browserContext.getActivity();
            string = !(abstractActivity instanceof AbstractApplyActivity) ? ValidationUtil.createUniqueTableName("DM4J$" + browserContext.getActivity().getCaseTable().getName(), ((WizardState)this.getparentWizardState()).getConnection(), "_RP") : ValidationUtil.createUniqueTableName(string, ((WizardState)this.getparentWizardState()).getConnection(), "_A");
        }
        if (ValidationUtil.isValidNonQuotedDBObjectName(string)) {
            this.setSelectedTableName(string);
        } else if (this.getparentWizardState() instanceof PredictState || this.getparentWizardState() instanceof ExplainState) {
            string = ValidationUtil.createUniqueModelName(string, ((WizardState)this.getparentWizardState()).getConnection(), "_A");
            this.setSelectedTableName(string);
        } else {
            this.setSelectedTableName(DM4JStringUtils.addDoubleQuotes(string));
        }
    }

    public String getSelectedTableName() {
        return this.m_tableName.toString();
    }

    public String getOutputTableName() {
        return this.m_outputtableName.toString();
    }

    public void setOutputTableName(String string) {
        this.m_outputtableName = new StringBuffer(string);
        if (this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void setSelectedTableName(String string) throws Exception {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_tableName.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_tableName = new StringBuffer(string.trim());
                try {
                    this.m_outputtableName = new StringBuffer(ValidationUtil.createUniqueTableName(this.m_tableName.toString(), this.getparentWizardState().getConnection(), "_A"));
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    this.m_outputtableName = this.m_tableName;
                }
            }
        }
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
        if (vector.isEmpty()) {
            this.validateTableName(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    private void validateTableName(Vector vector) throws Exception {
        boolean bl = DM4JStringUtils.isDoubleQuotedString(this.m_outputtableName.toString());
        String string = this.m_outputtableName.toString();
        if (bl) {
            string = DM4JStringUtils.trimDoubleQuotes(string);
        }
        if (string.length() == 0) {
            String string2 = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("TABLE_ONLY_NAME")};
            vector.add(new StateValidation(OutputTableError.OUTPUT_TABLE_NAME_EMPTY, string2, stringArray));
            return;
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string)) {
            vector.add(new StateValidation(OutputTableError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
        if (!ValidationUtil.checkStringLength(string, MAX_LENGTH)) {
            String string3 = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("TABLE_ONLY_NAME"), Integer.toString(MAX_LENGTH)};
            vector.add(new StateValidation(OutputTableError.OUTPUT_TABLE_NAME_EXCEEDS_MAXIMUM_LENGTH, string3, stringArray));
            return;
        }
        if (ValidationUtil.isGreater32BytesInDB(string, ((WizardState)this.getparentWizardState()).getConnection())) {
            vector.add(new StateValidation(OutputTableError.OUTPUT_TABLE_NAME_GREATER_30_BTYES));
            return;
        }
        if (!ValidationUtil.isTableNameUnique(string, ((WizardState)this.getparentWizardState()).getConnection())) {
            vector.add(new StateValidation(OutputTableError.TABLE_NAME_DUPLICATE));
            return;
        }
    }

    protected void refreshNew() throws Exception {
        super.refreshNew();
        this.loadDefaultSelectedTableName();
    }

    protected void refreshOld() throws Exception {
        this.loadNew();
    }

    protected void loadOld() throws Exception {
        this.loadNew();
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }
}

