/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.steps.ABNBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AlgorithmSettingState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.AdaptiveBayesNetworkAlgorithmStateError;
import oracle.dmt.jdm.algorithm.abn.OraABNModelType;

public class AdaptiveBayesNetworkAlgorithmState
extends AlgorithmSettingState {
    protected OraABNModelType m_selectedModelBuildType;
    protected OraABNModelType m_defaultSelectedModelBuildType;
    protected Integer m_runTime;
    protected Integer m_defaultRunTime;
    protected boolean m_runTimeSelected = false;
    protected boolean m_defaultRunTimeSelected = false;
    protected Integer m_networkFeatureDepth;
    protected Integer m_defaultNetworkFeatureDepth;
    protected Integer m_numberOfNetworkFeatures;
    protected Integer m_defaultNumberOfNetworkFeatures;
    protected Integer m_numberOfNBNetworkFeatures;
    protected Integer m_defaultNumberOfNBNetworkFeatures;
    protected Integer m_prunedNetworkFeatures;
    protected Integer m_defaultPrunedNetworkFeatures;
    private ABNBuildStepOptions m_options = null;

    public AdaptiveBayesNetworkAlgorithmState(WizardStepState wizardStepState, OraABNModelType oraABNModelType, Integer n, Integer n2, Integer n3, Integer n4, Integer n5) {
        super(wizardStepState);
        this.initialize(oraABNModelType, n, n2, n3, n4, n5);
    }

    public AdaptiveBayesNetworkAlgorithmState(OraABNModelType oraABNModelType, Integer n, Integer n2, Integer n3, Integer n4, Integer n5) {
        this.initialize(oraABNModelType, n, n2, n3, n4, n5);
    }

    private void initialize(OraABNModelType oraABNModelType, Integer n, Integer n2, Integer n3, Integer n4, Integer n5) {
        BrowserContext browserContext = this.m_wizardStepState.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof ABNBuildStepOptions) {
            this.m_options = (ABNBuildStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_selectedModelBuildType = this.m_options.getModelBuildType();
            this.m_runTime = this.m_options.getRunTime();
            this.m_runTimeSelected = this.m_runTime != null && this.m_runTime != 0;
            this.m_networkFeatureDepth = this.m_options.getNetworkFeatureDepth();
            this.m_numberOfNetworkFeatures = this.m_options.getNumberOfNetworkFeatures();
            this.m_numberOfNBNetworkFeatures = this.m_options.getNumberOfNBNetworkFeatures();
            this.m_prunedNetworkFeatures = this.m_options.getPrunedNetworkFeatures();
        } else {
            this.m_selectedModelBuildType = oraABNModelType;
            this.m_runTime = n;
            this.m_runTimeSelected = this.m_runTime != null && this.m_runTime != 0;
            this.m_networkFeatureDepth = n2;
            this.m_numberOfNetworkFeatures = n3;
            this.m_numberOfNBNetworkFeatures = n4;
            this.m_prunedNetworkFeatures = n5;
        }
        this.m_defaultSelectedModelBuildType = oraABNModelType;
        this.m_defaultRunTime = n;
        this.m_defaultRunTimeSelected = false;
        this.m_defaultNetworkFeatureDepth = n2;
        this.m_defaultNumberOfNetworkFeatures = n3;
        this.m_defaultNumberOfNBNetworkFeatures = n4;
        this.m_defaultPrunedNetworkFeatures = n5;
    }

    public void setRunTime(Integer n) {
        if (this.m_runTime == null || n == null || this.m_runTime.compareTo(n) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_runTime = n;
            if (this.m_options != null) {
                this.m_options.setRunTime(n);
            }
        }
    }

    public Integer getRunTime() {
        return this.m_runTime;
    }

    public void setNetworkFeatureDepth(Integer n) {
        if (this.m_networkFeatureDepth == null || n == null || this.m_networkFeatureDepth.compareTo(n) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_networkFeatureDepth = n;
            if (this.m_options != null) {
                this.m_options.setNetworkFeatureDepth(n);
            }
        }
    }

    public Integer getNetworkFeatureDepth() {
        return this.m_networkFeatureDepth;
    }

    public void setNumberOfNetworkFeatures(Integer n) {
        if (this.m_numberOfNetworkFeatures == null || n == null || this.m_numberOfNetworkFeatures.compareTo(n) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_numberOfNetworkFeatures = n;
            if (this.m_options != null) {
                this.m_options.setNumberOfNetworkFeatures(n);
            }
        }
    }

    public void setNumberOfNBNetworkFeatures(Integer n) {
        if (this.m_numberOfNBNetworkFeatures == null || n == null || this.m_numberOfNBNetworkFeatures.compareTo(n) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_numberOfNBNetworkFeatures = n;
            if (this.m_options != null) {
                this.m_options.setNumberOfNBNetworkFeatures(n);
            }
        }
    }

    public Integer getNumberOfNetworkFeatures() {
        return this.m_numberOfNetworkFeatures;
    }

    public Integer getNumberOfNBNetworkFeatures() {
        return this.m_numberOfNBNetworkFeatures;
    }

    public void setPrunedNetworkFeatures(Integer n) {
        if (this.m_prunedNetworkFeatures == null || n == null || this.m_prunedNetworkFeatures.compareTo(n) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_prunedNetworkFeatures = n;
            if (this.m_options != null) {
                this.m_options.setPrunedNetworkFeatures(n);
            }
        }
    }

    public Integer getPrunedNetworkFeatures() {
        return this.m_prunedNetworkFeatures;
    }

    public boolean getRunTimeSelected() {
        return this.m_runTimeSelected;
    }

    public boolean isRunTimeSelected() {
        return this.m_runTimeSelected;
    }

    public void setRunTimeSelected(boolean bl) {
        if (!this.m_runTimeSelected == bl) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_runTimeSelected = bl;
            if (this.m_options != null && !bl) {
                this.m_options.setRunTime(null);
            }
        }
    }

    public OraABNModelType getModelBuildTypeSelected() {
        return this.m_selectedModelBuildType;
    }

    public Vector getAvailableModelBuildTypeNames() {
        OraABNModelType[] oraABNModelTypeArray = OraABNModelType.values();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < oraABNModelTypeArray.length; ++i) {
            vector.add(oraABNModelTypeArray[i].name());
        }
        return vector;
    }

    public void setModelBuildTypeSelected(OraABNModelType oraABNModelType) {
        if (this.m_selectedModelBuildType == null || oraABNModelType == null || this.m_selectedModelBuildType.compareTo(oraABNModelType) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_selectedModelBuildType = oraABNModelType;
            if (this.m_options != null) {
                this.m_options.setModelBuildType(oraABNModelType);
            }
        }
    }

    protected void validateRunTime(Vector vector) throws Exception {
        if (this.m_runTimeSelected) {
            Integer n = new Integer(0);
            Integer n2 = new Integer(Integer.MAX_VALUE);
            if (this.m_runTime == null) {
                String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_ABN_RUN_TIME_LIMIT")};
                vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_RUN_TIME_EMPTY, string, stringArray));
                return;
            }
            if (this.m_runTime.compareTo(n) <= 0 || this.m_runTime.compareTo(n2) > 0) {
                vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_RUN_TIME_INVALID));
            }
        }
    }

    protected void validateNetworkFeatureDepth(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.m_networkFeatureDepth == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_ABN_NETWORK_FEATURE_DEPTH")};
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NETWORK_FEATURE_DEPTH_EMPTY, string, stringArray));
            return;
        }
        if (this.m_networkFeatureDepth.compareTo(n) <= 0 || this.m_networkFeatureDepth.compareTo(n2) > 0) {
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NETWORK_FEATURE_DEPTH_INVALID));
        }
    }

    protected void validateNumberOfNetworkFeatures(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.m_numberOfNetworkFeatures == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_ABN_NUMBER_OF_NETWORK_FEATURES")};
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NUMBER_OF_NETWORK_FEATURES_EMPTY, string, stringArray));
            return;
        }
        if (this.m_numberOfNetworkFeatures.compareTo(n) <= 0 || this.m_numberOfNetworkFeatures.compareTo(n2) > 0) {
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NUMBER_OF_NETWORK_FEATURES_INVALID));
        }
    }

    protected void validateNumberOfNBNetworkFeatures(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.m_numberOfNBNetworkFeatures == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_ABN_NB_NUMBER_OF_NETWORK_FEATURES")};
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NB_NUMBER_OF_NETWORK_FEATURES_EMPTY, string, stringArray));
            return;
        }
        if (this.m_numberOfNBNetworkFeatures.compareTo(n) <= 0 || this.m_numberOfNBNetworkFeatures.compareTo(n2) > 0) {
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_NB_NUMBER_OF_NETWORK_FEATURES_INVALID));
        }
    }

    protected void validatePrunedNetworkFeatures(Vector vector) throws Exception {
        Integer n = new Integer(0);
        Integer n2 = new Integer(Integer.MAX_VALUE);
        if (this.m_prunedNetworkFeatures == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_ABN_PRUNED_NETWORK_FEATURES")};
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_PRUNED_NETWORK_FEATURES_EMPTY, string, stringArray));
            return;
        }
        if (this.m_prunedNetworkFeatures.compareTo(n) <= 0 || this.m_prunedNetworkFeatures.compareTo(n2) > 0) {
            vector.add(new StateValidation(AdaptiveBayesNetworkAlgorithmStateError.ALGO_ABN_PRUNED_NETWORK_FEATURES_INVALID));
        }
    }

    public void validate(Vector vector) throws Exception {
        if (this.m_selectedModelBuildType.compareTo(OraABNModelType.multiFeature) == 0) {
            this.validateNumberOfNetworkFeatures(vector);
            this.validateNumberOfNBNetworkFeatures(vector);
            this.validatePrunedNetworkFeatures(vector);
        } else if (this.m_selectedModelBuildType.compareTo(OraABNModelType.singleFeature) == 0) {
            this.validateNumberOfNBNetworkFeatures(vector);
            this.validateNumberOfNetworkFeatures(vector);
        }
        if (this.m_selectedModelBuildType.compareTo(OraABNModelType.naiveBayes) == 0) {
            this.validateNumberOfNBNetworkFeatures(vector);
        }
        this.validateRunTime(vector);
    }

    public Vector validate() throws Exception {
        Vector vector = new Vector();
        this.validate(vector);
        return vector;
    }

    public void restoreSettingsToDefault() {
        this.setModelBuildTypeSelected(this.m_defaultSelectedModelBuildType);
        this.setRunTime(this.m_defaultRunTime);
        this.setNetworkFeatureDepth(this.m_defaultNetworkFeatureDepth);
        this.setNumberOfNetworkFeatures(this.m_defaultNumberOfNetworkFeatures);
        this.setNumberOfNBNetworkFeatures(this.m_defaultNumberOfNBNetworkFeatures);
        this.setPrunedNetworkFeatures(this.m_defaultPrunedNetworkFeatures);
        this.setRunTimeSelected(this.m_defaultRunTimeSelected);
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
    }
}

