/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.minings;

import java.text.MessageFormat;
import java.util.Vector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateActionException;

public abstract class WizardStepState
extends oracle.dmt.dm4j.wizard.state.WizardStepState {
    private String m_stepStateName;

    public WizardStepState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        this.m_stepStateName = string;
    }

    public void load() throws Exception {
        if (((WizardState)this.getparentWizardState()).isNew()) {
            this.loadNew();
            this.setState(StepStateType.LOADED);
        } else {
            this.loadOld();
            this.setState(StepStateType.VALIDATED);
        }
    }

    public abstract boolean preload() throws Exception;

    protected abstract void loadNew() throws Exception;

    protected void loadOld() throws Exception {
    }

    public void refresh() throws Exception {
        if (((WizardState)this.getparentWizardState()).isNew()) {
            this.refreshNew();
        } else {
            this.refreshOld();
        }
        this.setState(StepStateType.LOADED);
    }

    protected void refreshOld() throws Exception {
    }

    protected abstract void refreshNew() throws Exception;

    public abstract void validate(Vector var1) throws Exception;

    protected void validateRefreshState() throws Exception {
        if (this.getState() == StepStateType.LOADED || this.getState() == StepStateType.DIRTY || this.getState() == StepStateType.INCONSISTENT) {
            String string = ResourceUtilities.getstateExceptionMessage("STATE_ACTION_EXCEPTION");
            Object[] objectArray = new Object[]{this.m_stepStateName, ResourceUtilities.getstateExceptionMessage("REFRESH_METHOD")};
            throw new StateActionException(MessageFormat.format(string, objectArray));
        }
    }
}

