/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.minings;

import java.util.Vector;
import javax.datamining.base.Model;
import javax.datamining.resource.Connection;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JException;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.ClusteringClusterNumberSource;
import oracle.dmt.dm4j.wizard.director.minings.ClusteringModelApplyBuilder;
import oracle.dmt.dm4j.wizard.director.minings.ClusteringModelApplyLoader;
import oracle.dmt.dm4j.wizard.director.minings.ValidateDataToModelProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClusteringApplyOutputOptionState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClusteringModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.jdm.clustering.OraClusteringModel;

public class ClusteringModelApplyState
extends WizardState {
    private static final String DEFAULT_APPLY_NAME = "ClustApply";

    public ClusteringModelApplyState(BrowserContext browserContext, Connection connection, boolean bl) throws Exception {
        super(browserContext, connection, bl);
    }

    public void construct() throws Exception {
        if (this.isOld()) {
            this.m_loader = new ClusteringModelApplyLoader(this, this.getBrowserContext().getMiningObjectName());
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("MODEL_REBUILD_DIALOG_TITLE"), this.m_loader, true);
            this.m_loader.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("MODEL_REBUILD_UPPER_DESC"), null);
            if (this.m_loader.getException() != null) {
                throw this.m_loader.getException();
            }
            if (progressBar.hasUserCancelled()) {
                throw new Exception("USER_CANCEL");
            }
            if (!this.m_loader.promptForPDS()) {
                throw new Exception("USER_CANCEL");
            }
            if (!this.m_loader.validate()) {
                throw new Exception("USER_CANCEL");
            }
        }
        this.m_builder = new ClusteringModelApplyBuilder(this);
        this.m_builder.construct();
    }

    public String getDefaultModelName() {
        return DEFAULT_APPLY_NAME;
    }

    public boolean synchronize(Vector vector, WizardStepState wizardStepState) {
        boolean bl = true;
        ValidateDataToModelProcess validateDataToModelProcess = null;
        try {
            ModelState modelState = (ModelState)this.getStep(StepType.MODEL_STEP);
            DataState dataState = (DataState)this.getStep(StepType.DATA_STEP);
            if (this.isOld()) {
                modelState.validateModelExists(vector);
                if (!vector.isEmpty()) {
                    bl = false;
                    return bl;
                }
            }
            Model model = modelState.getSelectedMiningModel();
            validateDataToModelProcess = new ValidateDataToModelProcess(dataState, model, false, false);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("VALIDATE_MODEL_TO_DATA_DIALOG_TITLE"), validateDataToModelProcess, true);
            validateDataToModelProcess.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("VALIDATE_MODEL_TO_DATA_DIALOG_TITLE"), ResourceUtilities.getUILabel("VALIDATE_MODEL_TO_DATA_DESCRIPTION"));
            if (validateDataToModelProcess.getException() != null) {
                this.doAbortCancel(validateDataToModelProcess.getException());
            } else {
                if (progressBar.hasUserCancelled()) {
                    bl = false;
                    return bl;
                }
                Vector vector2 = validateDataToModelProcess.getMissingAttributes();
                if (vector2 != null) {
                    if (vector2.isEmpty() || !vector2.isEmpty() && !this.displayMissingAttributesDialog(validateDataToModelProcess.getModelLDSDataSource(), vector2)) {
                        bl = true;
                        if (this.isOld()) {
                            if (!this.synchPriors(model, vector, wizardStepState)) {
                                return false;
                            }
                            this.synchApplyIDs(validateDataToModelProcess.getDataLDSDataSource(), wizardStepState);
                        }
                        dataState.setLDSDataSource(validateDataToModelProcess.getDataLDSDataSource());
                        modelState.setLDSDataSource(validateDataToModelProcess.getModelLDSDataSource());
                    } else {
                        bl = false;
                        wizardStepState.setState(StepStateType.DIRTY);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.doAbortCancel(exception);
        }
        return bl;
    }

    protected boolean synchPriors(Model model, Vector vector, WizardStepState wizardStepState) throws DM4JException, Exception {
        boolean bl = false;
        ClusteringApplyOutputOptionState clusteringApplyOutputOptionState = (ClusteringApplyOutputOptionState)this.getStep(StepType.APPLY_OPTION_STEP);
        OraClusteringModel oraClusteringModel = (OraClusteringModel)model;
        int n = oraClusteringModel.getLeafClusters().size();
        boolean bl2 = false;
        boolean bl3 = true;
        bl2 = this.doesApplyOptionsNeedToChange(clusteringApplyOutputOptionState, n);
        if (bl2) {
            bl3 = this.showPriorsDialog("SYNCHRONIZE_APPLY_CLUSTER_ID_VALUES_CHANGED");
        }
        if (bl3) {
            this.performPriorsSynch(clusteringApplyOutputOptionState, n);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private ClusteringClusterNumberSource createNewLeafClusterDataSource(ClusteringApplyOutputOptionState clusteringApplyOutputOptionState) throws Exception {
        ClusteringModelState clusteringModelState = (ClusteringModelState)clusteringApplyOutputOptionState.getparentWizardState().getStep(StepType.MODEL_STEP);
        String string = clusteringModelState.getSelectedModelName();
        Connection connection = DM4JConnectionManager.getConnection();
        ClusteringClusterNumberSource clusteringClusterNumberSource = new ClusteringClusterNumberSource(connection, string);
        clusteringClusterNumberSource.run();
        return clusteringClusterNumberSource;
    }

    private void performPriorsSynch(ClusteringApplyOutputOptionState clusteringApplyOutputOptionState, int n) throws Exception {
        super.performPriorsSynch(clusteringApplyOutputOptionState, n);
        ClusteringClusterNumberSource clusteringClusterNumberSource = this.createNewLeafClusterDataSource(clusteringApplyOutputOptionState);
        if (clusteringApplyOutputOptionState.isSpecificPredictions()) {
            this.processClusterIDs(clusteringApplyOutputOptionState, clusteringClusterNumberSource, true);
        }
        clusteringApplyOutputOptionState.setClusterNumbers(clusteringClusterNumberSource);
        if (clusteringApplyOutputOptionState.isSpecificPredictions() && clusteringClusterNumberSource.getIncludedCount() == 0) {
            clusteringApplyOutputOptionState.setTopNPredictions(true);
        }
    }

    protected boolean processClusterIDs(ClusteringApplyOutputOptionState clusteringApplyOutputOptionState, ClusteringClusterNumberSource clusteringClusterNumberSource, boolean bl) {
        Vector vector = clusteringApplyOutputOptionState.getClusterNumbersAsVector(true);
        int n = -1;
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            n = clusteringClusterNumberSource.getAttributeIndex((String)vector.get(i));
            if (n == -1) {
                bl2 = true;
                continue;
            }
            ++n2;
            if (!bl) continue;
            clusteringClusterNumberSource.setData(0, n, new Boolean(true));
        }
        return bl2;
    }

    protected boolean doesApplyOptionsNeedToChange(ClusteringApplyOutputOptionState clusteringApplyOutputOptionState, int n) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        if (super.doesApplyOptionsNeedToChange(clusteringApplyOutputOptionState, n)) {
            bl2 = true;
        } else if (clusteringApplyOutputOptionState.isSpecificPredictions()) {
            ClusteringClusterNumberSource clusteringClusterNumberSource = this.createNewLeafClusterDataSource(clusteringApplyOutputOptionState);
            bl2 = this.processClusterIDs(clusteringApplyOutputOptionState, clusteringClusterNumberSource, false);
        }
        return bl2;
    }
}

