/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.minings;

import java.util.Vector;
import javax.datamining.resource.Connection;
import oracle.dmt.dm4j.DM4JException;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.director.minings.ClassificationModelBuildBuilder;
import oracle.dmt.dm4j.wizard.director.minings.ClassificationModelBuildLoader;
import oracle.dmt.dm4j.wizard.director.minings.SynchronizeModelBuildProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.ModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class ClassificationModelBuildState
extends ModelBuildState {
    private static final String DEFAULT_MODEL_NAME = "ClassModel";

    public ClassificationModelBuildState(BrowserContext browserContext, Connection connection, boolean bl) throws Exception {
        super(browserContext, connection, bl);
    }

    public String getDefaultModelName() {
        return DEFAULT_MODEL_NAME;
    }

    public void construct() throws Exception {
        if (this.isOld()) {
            this.m_loader = new ClassificationModelBuildLoader(this, this.getBrowserContext().getMiningObjectName());
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("MODEL_REBUILD_DIALOG_TITLE"), this.m_loader, true);
            this.m_loader.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("MODEL_REBUILD_UPPER_DESC"), null);
            if (this.m_loader.getException() != null) {
                throw this.m_loader.getException();
            }
            if (progressBar.hasUserCancelled()) {
                throw new Exception("USER_CANCEL");
            }
            if (!this.m_loader.promptForPDS()) {
                throw new Exception("USER_CANCEL");
            }
            if (!this.m_loader.validate()) {
                throw new Exception("USER_CANCEL");
            }
        }
        this.m_builder = new ClassificationModelBuildBuilder(this);
        this.m_builder.construct();
    }

    public boolean synchronize(Vector vector, WizardStepState wizardStepState) {
        boolean bl = false;
        SynchronizeModelBuildProcess synchronizeModelBuildProcess = null;
        try {
            TargetState targetState = (TargetState)this.getStep(StepType.TARGET_STEP);
            synchronizeModelBuildProcess = new SynchronizeModelBuildProcess((ModelDataState)wizardStepState, targetState.getTargetAttribute(), true);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("SYNCHRONIZE_MODEL_BUILD_DIALOG_TITLE"), synchronizeModelBuildProcess, true);
            synchronizeModelBuildProcess.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("SYNCHRONIZE_MODEL_BUILD_DIALOG_TITLE"), ResourceUtilities.getUILabel("SYNCHRONIZE_MODEL_BUILD_DESCRIPTION"));
            if (synchronizeModelBuildProcess.getException() != null) {
                this.doAbortCancel(synchronizeModelBuildProcess.getException());
            } else {
                if (progressBar.hasUserCancelled()) {
                    bl = false;
                    return bl;
                }
                bl = this.processSynchronizationAction(vector, wizardStepState, synchronizeModelBuildProcess);
            }
        }
        catch (Exception exception) {
            this.doAbortCancel(exception);
        }
        return bl;
    }

    protected boolean processSynchronizationAction(Vector vector, WizardStepState wizardStepState, SynchronizeModelBuildProcess synchronizeModelBuildProcess) throws Exception {
        boolean bl = false;
        ModelDataState modelDataState = (ModelDataState)this.getStep(StepType.DATA_STEP);
        TargetState targetState = (TargetState)this.getStep(StepType.TARGET_STEP);
        int n = synchronizeModelBuildProcess.getValidationAction();
        if (n == SynchronizeModelBuildProcess.ACTION_MISSING_TARGET) {
            wizardStepState.setState(StepStateType.DIRTY);
            bl = false;
            String[] stringArray = new String[]{targetState.getTargetAttribute()};
            vector.add(new StateValidation((ValidationType)DataStateError.SYNCHRONIZE_MISSING_TARGET, stringArray));
        }
        bl = super.processSynchronizationAction(vector, wizardStepState, synchronizeModelBuildProcess);
        return bl;
    }

    protected void updateSynchronizationState(SynchronizeModelBuildProcess synchronizeModelBuildProcess) throws Exception {
        ModelTargetValueState modelTargetValueState = (ModelTargetValueState)this.getStep(StepType.TARGET_VALUE_STEP);
        if (synchronizeModelBuildProcess.getTargetValueDataSource() == null) {
            DM4JException dM4JException = new DM4JException("Target values were not successfully extracted from the selected data.");
            throw dM4JException;
        }
        modelTargetValueState.setTargetValues(synchronizeModelBuildProcess.getTargetValueDataSource());
        modelTargetValueState.setTargetValueCostMatrix(synchronizeModelBuildProcess.getTargetValueCostMatrixDataSource());
        TargetValueDataSource targetValueDataSource = modelTargetValueState.getTargetValuesDataSource();
        int n = targetValueDataSource.getFirstRowByColumnValue(0, modelTargetValueState.getSelectedTargetValue());
        if (n == -1 && targetValueDataSource.getRowCount() > 0) {
            String string = (String)targetValueDataSource.getData(0, 0);
            modelTargetValueState.setSelectedTargetValue(string);
        }
        super.updateSynchronizationState(synchronizeModelBuildProcess);
    }
}

