/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.minings;

import java.util.Vector;
import javax.datamining.base.Model;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.SupervisedModel;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.datamining.supervised.classification.ClassificationSettings;
import oracle.dmt.dm4j.DM4JException;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.wizard.director.minings.ClassificationModelApplyBuilder;
import oracle.dmt.dm4j.wizard.director.minings.ClassificationModelApplyLoader;
import oracle.dmt.dm4j.wizard.director.minings.ValidateDataToModelProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelResultState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyTargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationApplyOutputOptionState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;

public class ClassificationModelApplyState
extends ClassificationModelResultState {
    private static final String DEFAULT_APPLY_NAME = "ClassApply";

    public ClassificationModelApplyState(BrowserContext browserContext, Connection connection, boolean bl) throws Exception {
        super(browserContext, connection, bl);
    }

    public void construct() throws Exception {
        if (this.isOld()) {
            this.m_loader = new ClassificationModelApplyLoader(this, this.getBrowserContext().getMiningObjectName());
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("MODEL_REBUILD_DIALOG_TITLE"), this.m_loader, true);
            this.m_loader.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("MODEL_REBUILD_UPPER_DESC"), null);
            if (this.m_loader.getException() != null) {
                throw this.m_loader.getException();
            }
            if (progressBar.hasUserCancelled()) {
                throw new Exception("USER_CANCEL");
            }
            if (!this.m_loader.promptForPDS()) {
                throw new Exception("USER_CANCEL");
            }
            if (!this.m_loader.validate()) {
                throw new Exception("USER_CANCEL");
            }
        }
        this.m_builder = new ClassificationModelApplyBuilder(this);
        this.m_builder.construct();
    }

    public String getDefaultModelName() {
        return DEFAULT_APPLY_NAME;
    }

    public boolean synchronize(Vector vector, WizardStepState wizardStepState) {
        boolean bl = true;
        ValidateDataToModelProcess validateDataToModelProcess = null;
        try {
            ModelState modelState = (ModelState)this.getStep(StepType.MODEL_STEP);
            DataState dataState = (DataState)this.getStep(StepType.DATA_STEP);
            ApplyTargetValueState applyTargetValueState = (ApplyTargetValueState)this.getStep(StepType.TARGET_VALUE_STEP);
            if (this.isOld()) {
                modelState.validateModelExists(vector);
                if (!vector.isEmpty()) {
                    bl = false;
                    return bl;
                }
            }
            SupervisedModel supervisedModel = (SupervisedModel)modelState.getSelectedMiningModel();
            validateDataToModelProcess = new ValidateDataToModelProcess(dataState, supervisedModel, true, false);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("VALIDATE_MODEL_TO_DATA_DIALOG_TITLE"), validateDataToModelProcess, true);
            validateDataToModelProcess.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("VALIDATE_MODEL_TO_DATA_DIALOG_TITLE"), ResourceUtilities.getUILabel("VALIDATE_MODEL_TO_DATA_DESCRIPTION"));
            if (validateDataToModelProcess.getException() != null) {
                this.doAbortCancel(validateDataToModelProcess.getException());
            } else {
                if (progressBar.hasUserCancelled()) {
                    bl = false;
                    return bl;
                }
                Vector vector2 = validateDataToModelProcess.getMissingAttributes();
                if (vector2 != null) {
                    if (vector2.isEmpty() || !vector2.isEmpty() && !this.displayMissingAttributesDialog(validateDataToModelProcess.getModelLDSDataSource(), vector2)) {
                        bl = true;
                        if (this.isOld()) {
                            if (!this.synchPriors(supervisedModel, vector, wizardStepState)) {
                                return false;
                            }
                            this.synchApplyIDs(validateDataToModelProcess.getDataLDSDataSource(), wizardStepState);
                        }
                        dataState.setLDSDataSource(validateDataToModelProcess.getDataLDSDataSource());
                        modelState.setLDSDataSource(validateDataToModelProcess.getModelLDSDataSource());
                        ((ClassificationModelState)modelState).setTargetAttributeDataType(validateDataToModelProcess.getModelLDSDataSource().getTargetAttributeDataType());
                        ((ClassificationModelState)modelState).setTargetAttributeName(validateDataToModelProcess.getModelLDSDataSource().getTargetAttributeName());
                        if (validateDataToModelProcess.getTargetValuesDataSource() != null) {
                            applyTargetValueState.setTargetValues(validateDataToModelProcess.getTargetValuesDataSource());
                            applyTargetValueState.setTargetValueCostMatrix(validateDataToModelProcess.getTargetValueCostMatrixDataSource());
                        }
                    } else {
                        bl = false;
                        wizardStepState.setState(StepStateType.DIRTY);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.doAbortCancel(exception);
        }
        return bl;
    }

    protected boolean synchPriors(Model model, Vector vector, WizardStepState wizardStepState) throws DM4JException, Exception {
        boolean bl = false;
        ClassificationModelState classificationModelState = (ClassificationModelState)this.getStep(StepType.MODEL_STEP);
        ClassificationModel classificationModel = (ClassificationModel)model;
        ClassificationSettings classificationSettings = (ClassificationSettings)classificationModel.getBuildSettings();
        int n = classificationModel.getTargetCategorySet().getSize();
        int n2 = classificationModelState.getNumberOfPriorsInteger();
        if (n2 > n) {
            ClassificationApplyOutputOptionState classificationApplyOutputOptionState = (ClassificationApplyOutputOptionState)this.getStep(StepType.APPLY_OPTION_STEP);
            if (this.doesApplyOptionsNeedToChange(classificationApplyOutputOptionState, n)) {
                if (this.showPriorsDialog("SYNCHRONIZE_APPLY_TARGET_VALUES_CHANGED")) {
                    this.performPriorsSynch(classificationApplyOutputOptionState, classificationModelState, n);
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private void performPriorsSynch(ClassificationApplyOutputOptionState classificationApplyOutputOptionState, ClassificationModelState classificationModelState, int n) {
        this.performPriorsSynch(classificationApplyOutputOptionState, n);
        int n2 = 0;
        n2 = classificationApplyOutputOptionState.getListOfSpecificPredictionValues().size();
        if (n2 > n) {
            Vector vector = classificationApplyOutputOptionState.getListOfSpecificPredictionValues();
            int n3 = n2 - n;
            Vector vector2 = (Vector)vector.clone();
            vector.clear();
            for (int i = 0; i < vector2.size() - n3; ++i) {
                vector.add(i, vector2.get(i));
            }
        }
        classificationModelState.setNumberOfPriors(Integer.toString(n));
    }

    protected boolean doesApplyOptionsNeedToChange(ClassificationApplyOutputOptionState classificationApplyOutputOptionState, int n) {
        int n2 = 0;
        boolean bl = false;
        if (super.doesApplyOptionsNeedToChange(classificationApplyOutputOptionState, n)) {
            bl = true;
        } else if (classificationApplyOutputOptionState.isSpecificPredictions() && (n2 = classificationApplyOutputOptionState.getListOfSpecificPredictionValues().size()) > n) {
            bl = true;
        }
        return bl;
    }
}

