/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.commonsteps;

import java.io.File;
import java.util.Locale;
import java.util.Vector;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportTableSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.OpenFileStateError;
import oracle.i18n.util.LocaleMapper;

public class OpenFileState
extends WizardStepState {
    private final int NAME_LENGTH_MAX = 4000;
    private File m_selected_file;
    private File m_selected_sql_loader;
    private static final String[] m_charsets = LocaleMapper.getAvailableIANACharacterSets();
    private String m_selected_charset;

    public OpenFileState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        this.validateFile(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    private void validateFile(Vector vector) throws Exception {
        Object object;
        String[] stringArray;
        String[] stringArray2;
        File file = this.m_selected_file;
        if (file == null) {
            stringArray2 = new String[]{"NULL"};
            vector.add(new StateValidation((ValidationType)OpenFileStateError.FILE_NOT_FOUND, stringArray2));
        }
        if (file != null && !file.exists()) {
            stringArray2 = new String[]{file.getName()};
            vector.add(new StateValidation((ValidationType)OpenFileStateError.FILE_NOT_FOUND, stringArray2));
        }
        if (!ValidationUtil.isFileNameWithSuffix((String)(stringArray2 = file.getName()))) {
            stringArray = new String[]{file.getName()};
            vector.add(new StateValidation((ValidationType)OpenFileStateError.FILE_MISSING_SUFFIX, stringArray));
        }
        if ((file = this.m_selected_sql_loader) == null) {
            stringArray = new String[]{"NULL"};
            vector.add(new StateValidation((ValidationType)OpenFileStateError.INVALID_SQL_LOADER, stringArray));
        }
        if (file != null && !file.exists()) {
            stringArray = new String[]{file.getName()};
            vector.add(new StateValidation((ValidationType)OpenFileStateError.INVALID_SQL_LOADER, stringArray));
        }
        if (file != null && !file.getName().toUpperCase().startsWith("SQLLDR")) {
            stringArray = new String[]{file.getName()};
            vector.add(new StateValidation((ValidationType)OpenFileStateError.INVALID_SQL_LOADER, stringArray));
        }
        if ((stringArray = UserPreferences.getInstance().getWorkingDirectory()) == null) {
            object = new String[]{"NULL"};
            vector.add(new StateValidation((ValidationType)OpenFileStateError.INVALID_WORKING_DIRECTORY, (String[])object));
        }
        if (stringArray != null && !((File)(object = new File((String)stringArray))).exists()) {
            String[] stringArray3 = new String[]{stringArray};
            vector.add(new StateValidation((ValidationType)OpenFileStateError.INVALID_WORKING_DIRECTORY, stringArray3));
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        this.loadDefaults();
    }

    public File getFile() {
        return this.m_selected_file;
    }

    public void setFile(File file) {
        if (file != null) {
            this.m_selected_file = file;
        }
    }

    public File getSqlLoader() {
        return this.m_selected_sql_loader;
    }

    public void setSqlLoader(File file) {
        if (file != null) {
            this.m_selected_sql_loader = file;
        }
    }

    public String[] getAllCharsets() {
        return m_charsets;
    }

    public void setCharset(String string) {
        if (string != null) {
            this.m_selected_charset = string;
        }
    }

    public String getCharset() {
        return this.m_selected_charset;
    }

    public String getOraCharset() {
        return LocaleMapper.getOraCharacterSet((int)2, (String)this.m_selected_charset);
    }

    protected void loadDefaults() throws Exception {
        String string;
        String string2 = UserPreferences.getInstance().getSQLLoaderPath();
        if (string2 != null && string2.length() > 0) {
            this.m_selected_sql_loader = new File(string2);
        }
        boolean bl = (string = System.getProperty("os.name")).indexOf("Win") != -1;
        String[] stringArray = LocaleMapper.getIANACharSetFromLocale((int)(bl ? 6 : 7), (Locale)Locale.getDefault());
        this.m_selected_charset = stringArray[0];
    }

    public void setState(StepStateType stepStateType) {
        super.setState(stepStateType);
        if (stepStateType == StepStateType.DIRTY) {
            FileImportTableSettingsState fileImportTableSettingsState = (FileImportTableSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
            fileImportTableSettingsState.setState(StepStateType.INCONSISTENT);
        }
    }

    public DataState getDataState() {
        return (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
    }
}

