/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.commonsteps;

import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.TableColumnsModel;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class DataState
extends WizardStepState {
    private StringBuffer m_schemaName = new StringBuffer(0);
    private StringBuffer m_tableName = new StringBuffer(0);
    private StringBuffer m_tableComment = new StringBuffer(0);
    private Vector m_schemaNames = new Vector();
    private Vector m_tableNames = new Vector();
    private Vector m_columnNames = new Vector();
    private TableColumnsModel m_columnModel;
    private boolean m_bloaded;
    private boolean m_hidePage = true;

    public boolean isLoaded() {
        return this.m_bloaded;
    }

    public DataState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public DataState(WizardState wizardState, String string, StepType stepType, boolean bl) {
        super(wizardState, string, stepType);
        this.m_hidePage = bl;
    }

    public void validate(Vector vector) throws Exception {
        this.setState(StepStateType.VALIDATED);
    }

    public void refresh() throws Exception {
        this.loadSchemaNames();
        this.loadDefaultSelectedSchemaName();
        this.loadDefaultSelectedTableName();
    }

    public void load() throws Exception {
        this.loadSchemaNames();
        this.loadDefaults();
    }

    private void loadDefaults() throws Exception {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            AbstractActivity abstractActivity = browserContext.getActivity();
            ComplexDataStructure complexDataStructure = browserContext.getInputDataDescriptor();
            this.setSelectedSchemaName(complexDataStructure.getCaseSchema());
            this.setSelectedTableName(complexDataStructure.getCaseTable());
        } else {
            this.loadDefaultSelectedSchemaName();
            this.loadDefaultSelectedTableName();
        }
    }

    protected void loadSchemaNames() throws Exception {
        this.m_schemaNames = DatabaseMetadata.getAccessibleSchemas(this.getparentWizardState().getConnection());
    }

    protected void loadDefaultSelectedSchemaName() throws Exception {
        if (this.m_schemaNames.isEmpty()) {
            return;
        }
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (this.getparentWizardState().getBrowserContext().getSchemaName() != null) {
            this.setSelectedSchemaName(this.getparentWizardState().getBrowserContext().getSchemaName());
        } else {
            this.setSelectedSchemaName(DM4JConnectionManager.getUser());
        }
    }

    protected void loadTableNames() throws Exception {
        this.m_tableNames = DatabaseMetadata.getAccessableTablesAndViews(this.getparentWizardState().getConnection(), this.m_schemaName.toString());
    }

    protected void loadColumnNames() {
        try {
            this.m_columnModel = new TableColumnsModel(this.getparentWizardState().getConnection(), this.m_schemaName.toString(), this.m_tableName.toString());
            this.m_bloaded = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.m_bloaded = false;
        }
    }

    protected void loadDefaultSelectedTableName() throws Exception {
        if (this.m_tableNames.isEmpty()) {
            this.setSelectedTableName("");
            return;
        }
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getDataSourceName() != null) {
            this.setSelectedTableName(this.getparentWizardState().getBrowserContext().getDataSourceName());
            if (this.m_hidePage && this.getparentWizardState().getBrowserContext().getLaunchPoint().equals(LaunchPoint.CONTEXT_MENU)) {
                this.enablePage(false);
            }
        } else {
            this.setSelectedTableName((String)this.m_tableNames.firstElement());
        }
    }

    public Vector getSchemaNames() {
        return (Vector)this.m_schemaNames.clone();
    }

    public Vector getTableNames() {
        return (Vector)this.m_tableNames.clone();
    }

    public Vector getColumnNames() {
        this.loadColumnNames();
        return this.m_bloaded ? this.m_columnModel.getColumnsByDataType(1, true) : new Vector();
    }

    public Vector getColumnNamesContainingStrings() {
        this.loadColumnNames();
        return this.m_bloaded ? this.m_columnModel.getColumnsByDataType(2, false) : new Vector();
    }

    public Vector getColumnNamesContainingStringsAndNumbers() {
        this.loadColumnNames();
        return this.m_bloaded ? this.m_columnModel.getColumnsByDataType(4, false) : new Vector();
    }

    public Vector getColumnNamesContainingNumbers() {
        this.loadColumnNames();
        return this.m_bloaded ? this.m_columnModel.getColumnsByDataType(3, false) : new Vector();
    }

    public String getSelectedSchemaName() {
        return this.m_schemaName.toString();
    }

    public void setSelectedSchemaName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_schemaName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_schemaName = new StringBuffer(string);
            this.loadTableNames();
            this.loadDefaultSelectedTableName();
        }
    }

    public String getSelectedTableName() {
        return this.m_tableName.toString();
    }

    public String getSelectedTableComment() {
        return this.m_tableComment.toString();
    }

    public void setSelectedTableName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_tableName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_tableName = new StringBuffer(string);
            this.loadTableComment();
        }
    }

    private void loadTableComment() throws Exception {
        this.m_tableComment = new StringBuffer(DatabaseMetadata.getTableComment(this.getparentWizardState().getConnection(), this.m_schemaName.toString(), this.m_tableName.toString()));
    }

    private void validateSchemaName(Vector vector) throws Exception {
        String string = this.m_schemaName.toString();
        if (!this.isSchemaNameValid(string)) {
            String[] stringArray = new String[]{string};
            vector.add(new StateValidation((ValidationType)DataStateError.SCHEMA_NOT_IN_DB, stringArray));
        }
    }

    private void validateTableName(Vector vector) throws Exception {
        Connection connection = null;
        try {
            String string = this.m_tableName.toString();
            String string2 = this.m_schemaName.toString();
            connection = DM4JConnectionManager.getDbConnection();
            if (!DatabaseMetadata.datasourceExists(connection, string2, string)) {
                String[] stringArray = new String[]{string};
                vector.add(new StateValidation((ValidationType)DataStateError.TABLE_NOT_IN_DB, stringArray));
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean postValidate(Vector vector) throws Exception {
        return true;
    }

    public boolean isSchemaNameValid(String string) {
        Iterator iterator = this.m_schemaNames.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isColumnAString(String string) {
        Vector vector = this.getColumnNamesContainingStrings();
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isColumnANumber(String string) {
        Vector vector = this.getColumnNamesContainingNumbers();
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    protected void enablePage(boolean bl) {
        DM4JWizard dM4JWizard = this.getparentWizardState().getWizard();
        int n = dM4JWizard.getPageCount();
        Class<DM4JPage> clazz = DM4JPage.class;
        DM4JPage dM4JPage = null;
        WizardPage wizardPage = null;
        for (int i = 0; i < n; ++i) {
            wizardPage = dM4JWizard.getPageAt(i);
            if (!clazz.isInstance(wizardPage) || !(dM4JPage = (DM4JPage)wizardPage).getStepType().equals(StepType.DATA_STEP)) continue;
            dM4JPage.setEnabled(bl);
            dM4JPage.setVisible(bl);
        }
    }

    public boolean allowDataSelection() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        return (!browserContext.getLaunchPoint().equals(LaunchPoint.CONTEXT_MENU) || browserContext.getDataSourceName() == null) && !browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
    }
}

