/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state;

import java.awt.Image;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JDialog;
import oracle.dmt.dm4j.activity.steps.ABNBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.ARBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.activity.steps.AnomalyDetectionBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.ClassificationApplyStepOptions;
import oracle.dmt.dm4j.activity.steps.ClassificationTestMetricStepOptions;
import oracle.dmt.dm4j.activity.steps.ClusteringApplyStepOptions;
import oracle.dmt.dm4j.activity.steps.DecisionTreeBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.DiscretizationStepOptions;
import oracle.dmt.dm4j.activity.steps.FeatureApplyStepOptions;
import oracle.dmt.dm4j.activity.steps.GLMCBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.GLMRBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.KMeansBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.MissingValuesStepOptions;
import oracle.dmt.dm4j.activity.steps.NMFBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.NaiveBayesBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.NormalizeStepOptions;
import oracle.dmt.dm4j.activity.steps.OClusterBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.OutlierTreatmentStepOptions;
import oracle.dmt.dm4j.activity.steps.SVMCBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.SVMRBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.SampleStepOptions;
import oracle.dmt.dm4j.activity.steps.SplitStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.dialogs.DM4JWizardDialog;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardStateInterface;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public abstract class WizardState
implements WizardStateInterface {
    private DM4JWizard m_wizard = null;
    private BrowserContext m_context = null;
    Vector m_stepsKeys = new Vector();
    HashMap m_steps = new HashMap();
    private Image m_image;
    private JDialog m_dialog;
    protected Connection m_connection;
    private DM4JWizardDialog m_DM4JDialog;
    private boolean m_wizardCompleted = false;
    private boolean m_displayUI = true;
    private Vector m_validations;
    protected AbstractStepOptions m_curActivityOptions = null;
    protected AbstractStepOptions m_preActivityOptions = null;

    public WizardState(BrowserContext browserContext) {
        this.m_context = browserContext;
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            this.m_curActivityOptions = browserContext.getOptions();
            if (this.m_curActivityOptions instanceof DecisionTreeBuildStepOptions) {
                this.m_preActivityOptions = new DecisionTreeBuildStepOptions((DecisionTreeBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof ABNBuildStepOptions) {
                this.m_preActivityOptions = new ABNBuildStepOptions((ABNBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof NaiveBayesBuildStepOptions) {
                this.m_preActivityOptions = new NaiveBayesBuildStepOptions((NaiveBayesBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof SVMCBuildStepOptions) {
                this.m_preActivityOptions = new SVMCBuildStepOptions((SVMCBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof SVMRBuildStepOptions) {
                this.m_preActivityOptions = new SVMRBuildStepOptions((SVMRBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof AnomalyDetectionBuildStepOptions) {
                this.m_preActivityOptions = new AnomalyDetectionBuildStepOptions((AnomalyDetectionBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof ClassificationTestMetricStepOptions) {
                this.m_preActivityOptions = new ClassificationTestMetricStepOptions((ClassificationTestMetricStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof NMFBuildStepOptions) {
                this.m_preActivityOptions = new NMFBuildStepOptions((NMFBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof KMeansBuildStepOptions) {
                this.m_preActivityOptions = new KMeansBuildStepOptions((KMeansBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof OClusterBuildStepOptions) {
                this.m_preActivityOptions = new OClusterBuildStepOptions((OClusterBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof ARBuildStepOptions) {
                this.m_preActivityOptions = new ARBuildStepOptions((ARBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof ClassificationApplyStepOptions) {
                this.m_preActivityOptions = new ClassificationApplyStepOptions((ClassificationApplyStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof ClusteringApplyStepOptions) {
                this.m_preActivityOptions = new ClusteringApplyStepOptions((ClusteringApplyStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof FeatureApplyStepOptions) {
                this.m_preActivityOptions = new FeatureApplyStepOptions((FeatureApplyStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof GLMCBuildStepOptions) {
                this.m_preActivityOptions = new GLMCBuildStepOptions((GLMCBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof GLMRBuildStepOptions) {
                this.m_preActivityOptions = new GLMRBuildStepOptions((GLMRBuildStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof SampleStepOptions) {
                this.m_preActivityOptions = new SampleStepOptions((SampleStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof SplitStepOptions) {
                this.m_preActivityOptions = new SplitStepOptions((SplitStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof MissingValuesStepOptions) {
                this.m_preActivityOptions = new MissingValuesStepOptions((MissingValuesStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof OutlierTreatmentStepOptions) {
                this.m_preActivityOptions = new OutlierTreatmentStepOptions((OutlierTreatmentStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof NormalizeStepOptions) {
                this.m_preActivityOptions = new NormalizeStepOptions((NormalizeStepOptions)this.m_curActivityOptions);
            } else if (this.m_curActivityOptions instanceof DiscretizationStepOptions) {
                this.m_preActivityOptions = new DiscretizationStepOptions((DiscretizationStepOptions)this.m_curActivityOptions);
            }
        }
    }

    public WizardState(BrowserContext browserContext, Connection connection) {
        this(browserContext);
        this.m_connection = connection;
    }

    public AbstractStepOptions getActivityOptions() {
        return this.m_curActivityOptions;
    }

    public boolean getDisplayUI() {
        return this.m_displayUI;
    }

    public void setDisplayUI(boolean bl) {
        this.m_displayUI = bl;
    }

    public boolean isWizardFinished() {
        return this.m_wizardCompleted;
    }

    public void setWizardFinished() {
        try {
            if (this.m_context.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
                this.m_context.getActivity().store();
            }
            this.m_wizardCompleted = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector validateStep(StepType stepType) throws Exception {
        WizardStepState wizardStepState = null;
        Vector vector = new Vector();
        wizardStepState = this.getStep(stepType);
        wizardStepState.validate(vector);
        if (vector.size() == 0) {
            this.validateWizard(stepType, wizardStepState, vector);
        }
        return vector;
    }

    public boolean addStep(StepType stepType, WizardStepState wizardStepState) {
        this.m_steps.put(stepType, wizardStepState);
        this.m_stepsKeys.add(stepType);
        return true;
    }

    public WizardStepState getStep(StepType stepType) {
        WizardStepState wizardStepState = null;
        wizardStepState = (WizardStepState)this.m_steps.get(stepType);
        return wizardStepState;
    }

    public void validateWizard(StepType stepType, WizardStepState wizardStepState, Vector vector) throws Exception {
        this.invalidateFurtherSteps(stepType);
    }

    protected void setStepState(WizardStepState wizardStepState, StepStateType stepStateType) {
        wizardStepState.setState(stepStateType);
    }

    public abstract void finish(Vector var1) throws Exception;

    protected abstract void invalidateFurtherSteps(StepType var1) throws Exception;

    public void setImage(Image image) {
        this.m_image = image;
    }

    public Image getImage() {
        return this.m_image;
    }

    public void setDialog(JDialog jDialog) {
        this.m_dialog = jDialog;
    }

    public JDialog getDialog() {
        return this.m_dialog;
    }

    public void setDM4JWizardDialog(DM4JWizardDialog dM4JWizardDialog) {
        this.m_DM4JDialog = dM4JWizardDialog;
        this.setDialog((JDialog)((Object)dM4JWizardDialog));
    }

    public DM4JWizardDialog getDM4JWizardDialog() {
        return this.m_DM4JDialog;
    }

    public void setWizard(DM4JWizard dM4JWizard) {
        this.m_wizard = dM4JWizard;
    }

    public DM4JWizard getWizard() {
        return this.m_wizard;
    }

    public Vector getStepKeys() {
        return (Vector)this.m_stepsKeys.clone();
    }

    public void doAbortCancel(Exception exception) {
        this.exit();
        this.m_wizard.doAbortCancel(exception);
    }

    public BrowserContext getBrowserContext() {
        return this.m_context;
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public void cancelStep(StepType stepType) throws Exception {
        WizardStepState wizardStepState = null;
        wizardStepState = (WizardStepState)this.m_steps.get(stepType);
        wizardStepState.setState(StepStateType.DIRTY);
        this.invalidateFurtherSteps(stepType);
    }

    public void exit() {
        try {
            if (this.m_context.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
                if (this.m_curActivityOptions instanceof DecisionTreeBuildStepOptions) {
                    ((DecisionTreeBuildStepOptions)this.m_curActivityOptions).restoreSettings((DecisionTreeBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof ABNBuildStepOptions) {
                    ((ABNBuildStepOptions)this.m_curActivityOptions).restoreSettings((ABNBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof NaiveBayesBuildStepOptions) {
                    ((NaiveBayesBuildStepOptions)this.m_curActivityOptions).restoreSettings((NaiveBayesBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof SVMCBuildStepOptions) {
                    ((SVMCBuildStepOptions)this.m_curActivityOptions).restoreSettings((SVMCBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof SVMRBuildStepOptions) {
                    ((SVMRBuildStepOptions)this.m_curActivityOptions).restoreSettings((SVMRBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof AnomalyDetectionBuildStepOptions) {
                    ((AnomalyDetectionBuildStepOptions)this.m_curActivityOptions).restoreSettings((AnomalyDetectionBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof ClassificationTestMetricStepOptions) {
                    ((ClassificationTestMetricStepOptions)this.m_curActivityOptions).restoreSettings((ClassificationTestMetricStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof NMFBuildStepOptions) {
                    ((NMFBuildStepOptions)this.m_curActivityOptions).restoreSettings((NMFBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof KMeansBuildStepOptions) {
                    ((KMeansBuildStepOptions)this.m_curActivityOptions).restoreSettings((KMeansBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof OClusterBuildStepOptions) {
                    ((OClusterBuildStepOptions)this.m_curActivityOptions).restoreSettings((OClusterBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof ARBuildStepOptions) {
                    ((ARBuildStepOptions)this.m_curActivityOptions).restoreSettings((ARBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof ClassificationApplyStepOptions) {
                    ((ClassificationApplyStepOptions)this.m_curActivityOptions).restoreSettings((ClassificationApplyStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof ClusteringApplyStepOptions) {
                    ((ClusteringApplyStepOptions)this.m_curActivityOptions).restoreSettings((ClusteringApplyStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof FeatureApplyStepOptions) {
                    ((FeatureApplyStepOptions)this.m_curActivityOptions).restoreSettings((FeatureApplyStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof GLMCBuildStepOptions) {
                    ((GLMCBuildStepOptions)this.m_curActivityOptions).restoreSettings((GLMCBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof GLMRBuildStepOptions) {
                    ((GLMRBuildStepOptions)this.m_curActivityOptions).restoreSettings((GLMRBuildStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof SampleStepOptions) {
                    ((SampleStepOptions)this.m_curActivityOptions).restoreSettings((SampleStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof SplitStepOptions) {
                    ((SplitStepOptions)this.m_curActivityOptions).restoreSettings((SplitStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof MissingValuesStepOptions) {
                    ((MissingValuesStepOptions)this.m_curActivityOptions).restoreSettings((MissingValuesStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof OutlierTreatmentStepOptions) {
                    ((OutlierTreatmentStepOptions)this.m_curActivityOptions).restoreSettings((OutlierTreatmentStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof NormalizeStepOptions) {
                    ((NormalizeStepOptions)this.m_curActivityOptions).restoreSettings((NormalizeStepOptions)this.m_preActivityOptions);
                } else if (this.m_curActivityOptions instanceof DiscretizationStepOptions) {
                    ((DiscretizationStepOptions)this.m_curActivityOptions).restoreSettings((DiscretizationStepOptions)this.m_preActivityOptions);
                }
            }
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValidations(Vector vector) {
        this.m_validations = vector;
    }

    public Vector getValidations() {
        return this.m_validations;
    }
}

