/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.resources;

import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.wizard.validation.ValidationType;

public class ResourceUtilities {
    protected static ListResourceBundle s_addInStateBundle;
    protected static Locale s_locale;
    protected static DM4JListResourceBundle s_addInBundle;

    public static ListResourceBundle getStateResourceBundle() throws Exception {
        if (s_addInStateBundle == null) {
            s_addInStateBundle = (ListResourceBundle)ListResourceBundle.getBundle("oracle.dmt.dm4j.wizard.resources.StateBundle", Locale.getDefault());
        }
        return s_addInStateBundle;
    }

    public Locale getLocale() {
        if (s_locale.equals(null)) {
            s_locale = Locale.getDefault();
        }
        return s_locale;
    }

    public static String getstateExceptionMessage(String string, String[] stringArray) {
        String string2 = ResourceUtilities.getstateExceptionMessage(string);
        String string3 = MessageFormat.format(string2, stringArray);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getstateExceptionMessage(String string) {
        String string2 = null;
        try {
            string2 = ResourceUtilities.getStateResourceBundle().getString(string);
        }
        catch (Exception exception) {
        }
        finally {
            if (string2 == null) {
                string2 = "Missing message.";
            }
        }
        return string2;
    }

    public static String getDM4JValidationMessage(ValidationType validationType) throws Exception {
        String string = null;
        try {
            String string2 = validationType.toString();
            string = ResourceUtilities.getStateResourceBundle().getString(string2);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (string == null) {
                string = "Missing message.";
            }
        }
        return string;
    }

    public static DM4JListResourceBundle getResourceBundle() throws Exception {
        if (s_addInBundle == null) {
            s_addInBundle = (DM4JListResourceBundle)ListResourceBundle.getBundle("oracle.dmt.dm4j.wizard.resources.UIBundle", Locale.getDefault());
        }
        return s_addInBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUILabel(String string) {
        String string2 = null;
        try {
            string2 = ResourceUtilities.getResourceBundle().getStringNoMnemonic(string);
        }
        catch (Exception exception) {
        }
        finally {
            if (string2 == null) {
                string2 = "Missing message";
            }
        }
        return string2;
    }

    public static int getUIMnemonicIntValue(String string) throws Exception {
        return ResourceUtilities.getUIMnemonic(string);
    }

    public static int getUIMnemonic(String string) {
        try {
            return ResourceUtilities.getResourceBundle().getMnemonic(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static void setMinimumSize(JComponent[] jComponentArray, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].setMinimumSize(dimension);
        }
    }

    public static void setTextBoxSize(JComponent[] jComponentArray, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray[i].setPreferredSize(dimension);
            jComponentArray[i].setMinimumSize(dimension);
        }
    }

    public static void setPreferredSize(JButton[] jButtonArray, int n, int n2) {
        Serializable serializable;
        String string = UIManager.getLookAndFeel().getID();
        int n3 = 0;
        if (string.equals("Motif")) {
            serializable = new Double((double)n2 * 1.5);
            n3 = ((Double)serializable).intValue();
        } else {
            n3 = n2;
        }
        serializable = new Dimension(n, n3);
        Insets insets = new Insets(2, 4, 2, 4);
        for (int i = 0; i < jButtonArray.length; ++i) {
            jButtonArray[i].setPreferredSize((Dimension)serializable);
            jButtonArray[i].setMinimumSize((Dimension)serializable);
            jButtonArray[i].setMargin(insets);
        }
    }

    public static String getUILabel(String string, String[] stringArray) throws Exception {
        String string2 = "Failed retrieving resource";
        string2 = MessageFormat.format(string, stringArray);
        return string2;
    }

    public static String getUILabelFromResource(String string, String[] stringArray) throws Exception {
        String string2 = "Failed retrieving resource";
        String string3 = ResourceUtilities.getUILabel(string);
        string2 = MessageFormat.format(string3, stringArray);
        return string2;
    }
}

