/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.transforms;

import java.sql.Connection;
import java.util.Hashtable;
import javax.datamining.ExecutionHandle;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.base.Task;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.AbstractApplyActivity;
import oracle.dmt.dm4j.activity.AbstractTestActivity;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.TextStep;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.TextState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextCaseIdState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextFinishState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ViewNameState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.OraTransformationTask;
import oracle.dmt.jdm.task.OraTransformationTaskFactory;
import oracle.dmt.jdm.transform.OraTransformation;
import oracle.dmt.jdm.transform.text.OraTextTransformFactory;
import oracle.dmt.jdm.transform.text.OraTextTransformImpl;

public class TextDirector
extends LongRunningProcess {
    private TextDataState m_dataState;
    private ViewNameState m_nameState;
    private TextCaseIdState m_caseIdState;
    private TextSettingsState m_settingsState;
    private TextFinishState m_finishState;
    protected TextState m_state;
    protected Task m_task = null;
    protected boolean m_isCancelable = true;
    private OraTextTransformFactory m_textXformFactory = null;
    private OraTransformationTaskFactory m_xformTaskFactory = null;
    private String m_uniqueTaskName = null;
    public static final String TASK_SUFFIX = "_J";

    public TextDirector(TextState textState) {
        this.m_state = textState;
    }

    public void construct() throws Exception {
        this.m_dataState = (TextDataState)this.m_state.getStep(StepType.DATA_STEP);
        this.m_nameState = (ViewNameState)this.m_state.getStep(StepType.NAME_STEP);
        this.m_caseIdState = (TextCaseIdState)this.m_state.getStep(StepType.SETTING_STEP);
        this.m_settingsState = (TextSettingsState)this.m_state.getStep(StepType.SETTING_STEP_1);
        this.m_finishState = (TextFinishState)this.m_state.getStep(StepType.FINISH_STEP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = System.currentTimeMillis();
        OraConnection oraConnection = null;
        try {
            this.getProgressBar().updateProgress(ResourceUtilities.getUILabel("MODEL_BUILD_UPPER_STEP_1"), null);
            oraConnection = (OraConnection)DM4JConnectionManager.getConnection();
            this.m_textXformFactory = (OraTextTransformFactory)oraConnection.getFactory("oracle.dmt.jdm.transform.text.OraTextTransform");
            this.m_xformTaskFactory = (OraTransformationTaskFactory)oraConnection.getFactory("oracle.dmt.jdm.task.OraTransformationTask");
            String string = this.getMiningTask(oraConnection);
            this.m_isCancelable = false;
            ExecutionHandle executionHandle = oraConnection.execute(string);
            this.m_state.setNewTaskName(string);
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            if (this.m_isCancelable) {
                this.cleanUp();
            }
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
        finally {
            try {
                oraConnection.close();
            }
            catch (Exception exception) {}
        }
        long l2 = System.currentTimeMillis();
    }

    private String getMiningTask(OraConnection oraConnection) throws Exception {
        Object object;
        Connection connection = oraConnection.getDatabaseConnection();
        if (this.m_nameState == null) {
            this.construct();
        }
        String string = this.m_dataState.getSelectedTableName();
        String string2 = this.m_nameState.getViewName();
        String string3 = this.m_caseIdState.getSequenceAttribute();
        Object[] objectArray = this.m_settingsState.getSelectedAttributes();
        String[] stringArray = null;
        if (objectArray != null) {
            stringArray = new String[objectArray.length];
            System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        }
        AbstractActivity abstractActivity = this.m_state.getBrowserContext().getActivity();
        this.m_uniqueTaskName = ValidationUtil.createUniqueJDMObjectName(ValidationUtil.addPrefixToName("DM4J$", DM4JStringUtils.trimDoubleQuotes(ValidationUtil.createNonQuotedCompliantName(string2))), oraConnection.getDatabaseConnection(), TASK_SUFFIX);
        String string4 = this.m_dataState.getSelectedSchemaName();
        String string5 = DM4JConnectionManager.getUser();
        boolean bl = DatabaseMetadata.isTable(connection, string4, string);
        boolean bl2 = string4.equalsIgnoreCase(string5);
        if (!bl || !bl2) {
            try {
                object = ValidationUtil.createUniqueTableName(DM4JStringUtils.trimDoubleQuotes(string), connection, "");
                DatabaseMetadata.createTableAs(connection, string4, string, string5, (String)object);
                string4 = string5;
                string = object;
                if (abstractActivity != null) {
                    ((TextStep)abstractActivity.findStep(TextStep.class.getName())).setCreateAsTable(new Table(string5, (String)object));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (abstractActivity == null) {
            object = (OraTextTransformImpl)this.m_textXformFactory.create(string4 + "." + string, string5 + "." + DM4JStringUtils.trimDoubleQuotes(string2), string3, stringArray);
            OraTransformationTask oraTransformationTask = this.m_xformTaskFactory.create((OraTransformation)object);
            oraConnection.saveObject("\"" + this.m_uniqueTaskName + "\"", oraTransformationTask, true);
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String string6 = abstractActivity == null ? "DM4J$UNKNOWN" : abstractActivity.getName();
            dMEMetadata.insertXformRec(connection, string2, "\"" + this.m_uniqueTaskName + "\"", string, string6);
        } else {
            String string7;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            boolean bl3 = false;
            String string8 = null;
            if (abstractActivity instanceof AbstractTestActivity) {
                object5 = ((AbstractTestActivity)abstractActivity).getModelName();
                object4 = DMEMetadata.getInstance();
                object3 = ((DMEMetadata)object4).getTransparencyTables(connection, null, (String)object5);
                if (object3 != null) {
                    string8 = (String)((Hashtable)object3).get("XTEXT");
                    bl3 = true;
                }
            } else if (abstractActivity instanceof AbstractApplyActivity) {
                object5 = ((AbstractApplyActivity)abstractActivity).getModelName();
                object4 = DMEMetadata.getInstance();
                object3 = ((DMEMetadata)object4).getTransparencyTables(connection, null, (String)object5);
                if (object3 != null) {
                    string8 = (String)((Hashtable)object3).get("XTEXT");
                    bl3 = true;
                }
            }
            object5 = abstractActivity.findModelStepOutput();
            if (null != object5) {
                object4 = (String)((Hashtable)object5).get("MODEL");
                object3 = DMEMetadata.getInstance();
                object2 = ((DMEMetadata)object3).getTransparencyTables(connection, null, (String)object4);
                if (object2 != null) {
                    string8 = (String)((Hashtable)object2).get("XTEXT");
                    bl3 = true;
                }
            }
            if (string8 == null) {
                object4 = abstractActivity.getTextTable().getName();
                object3 = abstractActivity.getTextTable().getSchema();
                object2 = abstractActivity.getTextColumn().getName();
                bl = DatabaseMetadata.isTable(connection, (String)object3, (String)object4);
                if (!bl || (string7 = DatabaseMetadata.getContextIndexName(connection, (String)object3, (String)object4, (String)object2)) != null) {
                    // empty if block
                }
            }
            object4 = null;
            object4 = string8 == null ? (OraTextTransformImpl)this.m_textXformFactory.create(string4 + "." + string, string5 + "." + string2, string3, stringArray) : (OraTextTransformImpl)this.m_textXformFactory.create(string4 + "." + string, string5 + "." + string2, string3, stringArray, new String[]{string8});
            if (!bl3) {
                string8 = ((OraTextTransformImpl)object4).getFeatureTables()[0];
                ((TextStep)abstractActivity.findStep(TextStep.class.getName())).setFeatureTable(new Table(DM4JConnectionManager.getUser(), string8));
            }
            object3 = this.m_xformTaskFactory.create((OraTransformation)object4);
            oraConnection.saveObject("\"" + this.m_uniqueTaskName + "\"", (MiningObject)object3, true);
            object2 = DMEMetadata.getInstance();
            string7 = abstractActivity == null ? "DM4J$UNKNOWN" : abstractActivity.getName();
            ((DMEMetadata)object2).insertXformRec(connection, string2, "\"" + this.m_uniqueTaskName + "\"", string, string7);
        }
        return "\"" + this.m_uniqueTaskName + "\"";
    }

    public void clear() throws Exception {
        this.m_task = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            Object object;
            if (this.m_uniqueTaskName != null) {
                object = null;
                try {
                    object = (OraConnection)DM4JConnectionManager.getConnection();
                    ((OraConnection)object).removeObject("\"" + this.m_uniqueTaskName + "\"", NamedObject.task);
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        ((OraConnection)object).close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                object = DMEMetadata.getInstance();
                ((DMEMetadata)object).deleteXformRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", null);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

