/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.transforms;

import java.io.Serializable;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.AttrValueCountDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.sql.PLSQLPackage;
import oracle.dmt.dm4j.wizard.director.transforms.TransformPLSQLPackage;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.state.transforms.StratifiedSplitState;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.transformsteps.SplitNameState;
import oracle.dmt.dm4j.wizard.state.transformsteps.SplitSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedSplitTargetState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class StratifiedSplitDirector
extends TransformsDirector {
    public static final String SPLIT_TEST_OUTPUT = "Split Test Output";
    public static final String SPLIT_BUILD_OUTPUT = "Split Build Output";
    public static final String RANDOM_SPLIT_OUTPUT = "Random Sample Output";
    CaseCountDataState m_dataState;
    SplitNameState m_nameState;
    StratifiedSplitTargetState m_targetState;
    SplitSettingsState m_settingsState;
    FinishState m_finishState;
    String m_caseID = "ROWNUM";
    Hashtable m_codeGenCreateBuildArguments;
    Hashtable m_codeGenCreateTestArguments;
    private StringBuffer m_results = new StringBuffer();
    private StringBuffer m_queryResults = new StringBuffer();
    private TransformPLSQLPackage m_componentResults = null;
    protected Hashtable m_TxData;

    public Hashtable getCodeGenCreateBuildArguments() {
        return this.m_codeGenCreateBuildArguments;
    }

    public Hashtable getCodeGenCreateTestArguments() {
        return this.m_codeGenCreateTestArguments;
    }

    public StratifiedSplitDirector(TransformWizardState transformWizardState) {
        super(transformWizardState);
    }

    public void construct() throws Exception {
        CharSequence charSequence;
        long l;
        CharSequence charSequence2;
        Object[] objectArray;
        Object[] objectArray2;
        this.m_dataState = (CaseCountDataState)this.getWizardState().getStep(StepType.DATA_STEP);
        this.m_nameState = (SplitNameState)this.getWizardState().getStep(StepType.NAME_STEP);
        this.m_targetState = (StratifiedSplitTargetState)this.getWizardState().getStep(StepType.SETTING_STEP);
        this.m_settingsState = (SplitSettingsState)this.getWizardState().getStep(StepType.SETTING_STEP_1);
        this.m_finishState = (FinishState)this.getWizardState().getStep(StepType.FINISH_STEP);
        String string = this.m_targetState.getTargetColumnName();
        BrowserContext browserContext = this.getWizardState().getBrowserContext();
        double d = Double.parseDouble(this.m_settingsState.getBuildTablePercentage());
        long l2 = (long)((double)this.m_dataState.getCaseCount() * d / 100.0);
        Connection connection = null;
        AttrValueCountDataSource attrValueCountDataSource = null;
        connection = DM4JConnectionManager.getDbConnection();
        if (this.m_dataState.isMultipleRecordCaseFormat()) {
            attrValueCountDataSource = new AttrValueCountDataSource(connection, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName(), string, this.m_dataState.getCaseCount(), d, l2, this.m_dataState.getSequenceIDMapping(), this.m_dataState.getAttributeNameMapping(), this.m_dataState.getValueMapping());
            if (this.m_dataState.isSingleMetric()) {
                attrValueCountDataSource.setSingleMetric();
            }
        } else {
            attrValueCountDataSource = new AttrValueCountDataSource(connection, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName(), string, this.m_dataState.getCaseCount(), d, l2);
        }
        attrValueCountDataSource.run();
        connection.close();
        boolean bl = this.m_dataState.isMultipleRecordCaseFormat();
        boolean bl2 = this.m_nameState.getCreateTable();
        String string2 = "TABLE";
        if (!bl2) {
            string2 = "VIEW";
        }
        String string3 = "\"" + this.m_dataState.getSelectedSchemaName() + "\"" + ".\"" + this.m_dataState.getSelectedTableName() + "\"";
        String string4 = "\"" + DM4JConnectionManager.getUser() + "\"." + "\"" + DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getOutputBuildTable()) + "\"";
        String string5 = "\"" + DM4JConnectionManager.getUser() + "\"." + "\"" + DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getOutputTestTable()) + "\"";
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        StringBuffer stringBuffer4 = null;
        StringBuffer stringBuffer5 = null;
        StringBuffer stringBuffer6 = null;
        StringBuffer stringBuffer7 = null;
        StringBuffer stringBuffer8 = null;
        String string6 = "\"" + this.m_targetState.getTargetColumnName() + "\"";
        ArrayList[] arrayListArray = attrValueCountDataSource.getAttributeValueCounts();
        if (bl) {
            objectArray2 = "\"" + this.m_dataState.getSequenceIDMapping() + "\"";
            objectArray = "\"" + this.m_dataState.getAttributeNameMapping() + "\"";
            charSequence2 = "\"" + this.m_dataState.getValueMapping() + "\"";
            string6 = this.m_targetState.getTargetColumnName();
            stringBuffer = new StringBuffer("WITH sampleseqids AS (");
            Object[] objectArray3 = null;
            objectArray3 = new Object[]{objectArray2, string3};
            stringBuffer.append(MessageFormat.format("SELECT {0} FROM {1} WHERE \n", objectArray3));
            int n = arrayListArray[0].size();
            if (n > 0) {
                stringBuffer3 = new StringBuffer();
                stringBuffer4 = new StringBuffer();
            }
            for (int i = 0; i < n; ++i) {
                long l3 = (Long)arrayListArray[1].get(i);
                l = (Long)arrayListArray[4].get(i);
                objectArray3 = new Object[]{objectArray, string6, charSequence2, DM4JNumericFormat.SQLFormat(new Double(((Number)arrayListArray[0].get(i)).doubleValue())), objectArray2, l3 + "", "12345", (l3 <= 2L ? l3 : l) + ""};
                stringBuffer3.append(MessageFormat.format("( {0}=''{1}'' AND {2}={3} AND ORA_HASH({4},{5},{6}) < {7} ) \n", objectArray3));
                stringBuffer4.append(MessageFormat.format("( {0}=''{1}'' AND {2}={3} AND ORA_HASH({4},{5},{6}) >= {7} ) \n", objectArray3));
                if (i == n - 1) continue;
                stringBuffer3.append(" OR ");
                stringBuffer4.append(" OR ");
            }
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append(") \nSELECT t.* FROM sampleseqids s, " + string3 + " t WHERE s." + (String)objectArray2 + " = " + "t." + (String)objectArray2);
        } else {
            Serializable serializable;
            String string7;
            objectArray2 = this.getWizardState().getConnection();
            objectArray = DatabaseMetadata.getColumnNames((Connection)objectArray2, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
            charSequence2 = new StringBuffer();
            int n = objectArray.size();
            for (int i = 0; i < n; ++i) {
                string7 = (String)objectArray.get(i);
                ((StringBuffer)charSequence2).append("\"" + string7 + "\"");
                if (i >= n - 1) continue;
                ((StringBuffer)charSequence2).append(", ");
            }
            stringBuffer = new StringBuffer();
            Object[] objectArray4 = null;
            string7 = this.m_caseID;
            if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
                serializable = browserContext.getInputDataDescriptor();
                this.m_caseID = ((ComplexDataStructure)serializable).getCaseId();
                string7 = "\"" + this.m_caseID + "\"";
            } else {
                try {
                    serializable = DatabaseMetadata.getSequenceColumn((Connection)objectArray2, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
                    if (serializable != null && ((Vector)serializable).size() > 0) {
                        this.m_caseID = ((Vector)serializable).get(0).toString();
                        string7 = "\"" + this.m_caseID + "\"";
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            objectArray4 = new Object[]{((StringBuffer)charSequence2).toString(), string3, string6, string7};
            stringBuffer.append(MessageFormat.format("SELECT {0} \nFROM (SELECT /*+ no_merge */ t.*, row_number() over(partition by {2} order by ora_hash({3})) RNUM FROM {1} t) \nWHERE RNUM = 1 \n OR ", objectArray4));
            int n2 = arrayListArray[0].size();
            if (n2 > 0) {
                stringBuffer3 = new StringBuffer();
                stringBuffer4 = new StringBuffer();
            }
            for (int i = 0; i < n2; ++i) {
                l = (Long)arrayListArray[1].get(i);
                long l4 = (Long)arrayListArray[4].get(i);
                charSequence = null;
                if (arrayListArray[0].get(i) == null) {
                    objectArray4 = new Object[]{string6, l + "", "12345", l4 + ""};
                    stringBuffer3.append(MessageFormat.format("( {0} IS NULL and ORA_HASH(RNUM,({1}-1),{2}) < {3} ) \n", objectArray4));
                    stringBuffer4.append(MessageFormat.format("( {0} IS NULL and ORA_HASH(RNUM,({1}-1),{2}) >= {3} ) \n", objectArray4));
                } else {
                    charSequence = attrValueCountDataSource.isAttrValNumber() ? "" + ((Number)arrayListArray[0].get(i)).doubleValue() : "'" + DM4JStringUtils.escapeSingleQuotesForSQL(arrayListArray[0].get(i).toString()) + "'";
                }
                if (charSequence != null) {
                    objectArray4 = new Object[]{string6, charSequence, l + "", "12345", l4 + ""};
                    stringBuffer3.append(MessageFormat.format("( {0}={1} and ORA_HASH(RNUM,({2}-1),{3}) < {4} ) \n", objectArray4));
                    stringBuffer4.append(MessageFormat.format("( {0}={1} and ORA_HASH(RNUM,({2}-1),{3}) >= {4} ) \n", objectArray4));
                }
                if (i == n2 - 1) continue;
                stringBuffer3.append(" OR ");
                stringBuffer4.append(" OR ");
            }
        }
        objectArray2 = new Object[]{string2, string4};
        stringBuffer5 = new StringBuffer(MessageFormat.format("CREATE {0} {1} AS \n", objectArray2));
        stringBuffer5.append(stringBuffer);
        stringBuffer5.append(stringBuffer3);
        if (stringBuffer2 != null) {
            stringBuffer5.append(stringBuffer2);
        }
        objectArray = new Object[]{string2, string5};
        stringBuffer6 = new StringBuffer(MessageFormat.format("CREATE {0} {1} AS \n", objectArray));
        stringBuffer6.append(stringBuffer);
        stringBuffer6.append(stringBuffer4);
        if (stringBuffer2 != null) {
            stringBuffer6.append(stringBuffer2);
        }
        this.m_queryResults.setLength(0);
        this.m_queryResults.append(stringBuffer);
        this.m_queryResults.append(stringBuffer3);
        if (stringBuffer2 != null) {
            this.m_queryResults.append(stringBuffer2);
        }
        charSequence2 = StratifiedSplitDirector.getReplacedString(this.m_nameState.getBuildComment(), "'", "''");
        stringBuffer7 = new StringBuffer();
        stringBuffer7.append("COMMENT ON TABLE \"" + DM4JConnectionManager.getUser() + "\".\"" + DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getOutputBuildTable()) + "\" IS '" + (String)charSequence2 + "'");
        charSequence2 = StratifiedSplitDirector.getReplacedString(this.m_nameState.getTestComment(), "'", "''");
        stringBuffer8 = new StringBuffer();
        stringBuffer8.append("COMMENT ON TABLE \"" + DM4JConnectionManager.getUser() + "\".\"" + DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getOutputTestTable()) + "\" IS '" + (String)charSequence2 + "'");
        this.m_results.setLength(0);
        int n = 4;
        ComplexDataStructure complexDataStructure = null;
        ComplexDataStructure complexDataStructure2 = null;
        ComplexDataStructure complexDataStructure3 = null;
        Object var32_44 = null;
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            complexDataStructure = browserContext.getInputDataDescriptor();
            n += 4 * complexDataStructure.getColumnMap().size();
        }
        StringBuffer[] stringBufferArray = new StringBuffer[n];
        stringBufferArray[0] = new StringBuffer(stringBuffer5.toString());
        stringBufferArray[1] = new StringBuffer(stringBuffer7.toString());
        stringBufferArray[2] = new StringBuffer(stringBuffer6.toString());
        stringBufferArray[3] = new StringBuffer(stringBuffer8.toString());
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            complexDataStructure2 = TransformsDirector.createCDSDataStructureAndSQL(complexDataStructure, SPLIT_BUILD_OUTPUT, complexDataStructure.getCaseSchema(), complexDataStructure.getCaseTable(), DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getOutputBuildTable()), string2, stringBufferArray, 4);
            int n3 = 4 + 2 * complexDataStructure.getColumnMap().size();
            complexDataStructure3 = TransformsDirector.createCDSDataStructureAndSQL(complexDataStructure, SPLIT_TEST_OUTPUT, complexDataStructure.getCaseSchema(), complexDataStructure.getCaseTable(), DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getOutputTestTable()), string2, stringBufferArray, n3);
        }
        this.m_stmtVisibleComponentArray = stringBufferArray;
        if (browserContext != null && complexDataStructure != null) {
            ComplexDataStructure complexDataStructure4 = browserContext.getSampledInputDataDescriptor();
            if (complexDataStructure4 != null) {
                String string8 = complexDataStructure.getCaseTable();
                String string9 = ValidationUtil.createUniqueTableNameUsingRandom(string8, this.getWizardState().getConnection(), "_S");
                charSequence = new StringBuffer("CREATE VIEW ");
                ((StringBuffer)charSequence).append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(complexDataStructure4.getCaseSchema())));
                ((StringBuffer)charSequence).append(".");
                ((StringBuffer)charSequence).append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(string9)));
                ((StringBuffer)charSequence).append(" AS\n   (SELECT * FROM ");
                ((StringBuffer)charSequence).append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(complexDataStructure4.getCaseSchema())));
                ((StringBuffer)charSequence).append(".");
                ((StringBuffer)charSequence).append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(complexDataStructure4.getCaseTable())));
                ((StringBuffer)charSequence).append(")");
                this.m_stmtComponentArray = new StringBuffer[stringBufferArray.length + 1];
                System.arraycopy(stringBufferArray, 0, this.m_stmtComponentArray, 0, stringBufferArray.length);
                this.m_stmtComponentArray[stringBufferArray.length] = charSequence;
                ComplexDataStructure complexDataStructure5 = new ComplexDataStructure(complexDataStructure4.getName() + "SAMPLED_RESULT", string9, complexDataStructure2.getCaseSchema(), complexDataStructure2.getCaseId());
                complexDataStructure5.setColumnMap(complexDataStructure2.getColumnMap());
                this.getWizardState().setOutputSampledDataDescriptor(complexDataStructure5);
            }
        } else {
            this.m_stmtComponentArray = new StringBuffer[stringBufferArray.length];
            System.arraycopy(stringBufferArray, 0, this.m_stmtComponentArray, 0, stringBufferArray.length);
        }
        StratifiedSplitState stratifiedSplitState = (StratifiedSplitState)this.getWizardState();
        stratifiedSplitState.setNewTranformName(DM4JConnectionManager.getUser(), this.m_nameState.getOutputBuildTable(), !this.m_nameState.getCreateTable());
        stratifiedSplitState.setNewTestTranformName(DM4JConnectionManager.getUser(), this.m_nameState.getOutputTestTable(), !this.m_nameState.getCreateTable());
        this.getWizardState().setOutputDataDescriptor(complexDataStructure2);
        ((StratifiedSplitState)this.getWizardState()).setTestOutputDataDescriptor(complexDataStructure3);
    }

    public void executeHiddenSQLStatements() throws Exception {
        if (DiscretizeDataSource.isDebug()) {
            ActivityUtils.printOutoutLineage(this.getWizardState().getOutputSampledDataDescriptor(), this.getWizardState().getOutputDataDescriptor());
        }
    }

    public String getConstructResults() throws Exception {
        return null;
    }

    public String getConstructResultsQueryOnly() throws Exception {
        return this.m_queryResults.toString();
    }

    public PLSQLPackage getConstructComponent() throws Exception {
        return null;
    }

    public Vector getTxSQL(String string) {
        if (this.m_TxData != null) {
            return (Vector)this.m_TxData.get(string);
        }
        return null;
    }

    public void setTxSQL(String string, Vector vector) {
        if (this.m_TxData == null) {
            this.m_TxData = new Hashtable();
        }
        this.m_TxData.put(string, vector);
    }

    public void constructCodeGen() throws Exception {
        this.m_dataState = (CaseCountDataState)this.getWizardState().getStep(StepType.DATA_STEP);
        this.m_nameState = (SplitNameState)this.getWizardState().getStep(StepType.NAME_STEP);
        this.m_targetState = (StratifiedSplitTargetState)this.getWizardState().getStep(StepType.SETTING_STEP);
        this.m_settingsState = (SplitSettingsState)this.getWizardState().getStep(StepType.SETTING_STEP_1);
        this.m_finishState = (FinishState)this.getWizardState().getStep(StepType.FINISH_STEP);
        String string = this.m_targetState.getTargetColumnName();
        BrowserContext browserContext = this.getWizardState().getBrowserContext();
        double d = Double.parseDouble(this.m_settingsState.getBuildTablePercentage());
        Connection connection = this.getWizardState().getConnection();
        Vector vector = DatabaseMetadata.getColumnNames(connection, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
        this.m_codeGenCreateBuildArguments = new Hashtable();
        this.m_codeGenCreateBuildArguments.put("ATTRIBUTE_LIST", vector);
        this.m_codeGenCreateBuildArguments.put("TARGET_ATTR_VALUE", string);
        this.m_codeGenCreateBuildArguments.put("PERCENTAGE", new Double(d));
        this.m_codeGenCreateTestArguments = new Hashtable();
        this.m_codeGenCreateTestArguments.put("ATTRIBUTE_LIST", vector);
        this.m_codeGenCreateTestArguments.put("TARGET_ATTR_VALUE", string);
        this.m_codeGenCreateTestArguments.put("PERCENTAGE", new Double(d));
        ComplexDataStructure complexDataStructure = null;
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            complexDataStructure = browserContext.getInputDataDescriptor();
            Vector vector2 = new Vector();
            TransformsDirector.createCDSDataStructureAndSQLCodeGen(complexDataStructure, SPLIT_BUILD_OUTPUT, DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getOutputBuildTable()), "TABLE", vector2);
            this.setTxSQL(SPLIT_BUILD_OUTPUT, vector2);
            Vector vector3 = new Vector();
            TransformsDirector.createCDSDataStructureAndSQLCodeGen(complexDataStructure, SPLIT_TEST_OUTPUT, DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getOutputTestTable()), "TABLE", vector3);
            this.setTxSQL(SPLIT_TEST_OUTPUT, vector3);
        }
    }

    static interface SQL_TEMPLATES_WITH_TMP_TABLE {
        public static final String QUERY_BUILD_2D_DATA = "SELECT /*+ noparallel(t)*/ t.* FROM {0} t, {1} tmp WHERE t.{2}=tmp.VALUE and sign(rownum)-1+dbms_random.value <= tmp.SAMPLE_PERCENTAGE";
        public static final String QUERY_BUILD_XNL_DATA = "SELECT * FROM (SELECT /*+ noparallel(t)*/ originalTable.* FROM (SELECT DISTINCT {3} FROM  {0} t, {1} tmp WHERE t.{4}='{2}' and t.{5}=tmp.VALUE and sign(rownum)-1+dbms_random.value <= tmp.SAMPLE_PERCENTAGE) sampleSeqIds, {0} originalTable WHERE sampleSeqIds.{3}=originalTable.{3}";
        public static final String CREATE_TABLE_PREFIX = "CREATE {0} {1} AS ";
    }

    static interface SQL_TEMPLATES {
        public static final String QUERY_SPLIT_XNL_DATA_PREFIX = "SELECT {0} FROM {1} WHERE \n";
        public static final String QUERY_BUILD_XNL_DATA = "( {0}=''{1}'' AND {2}={3} AND ORA_HASH({4},{5},{6}) < {7} ) \n";
        public static final String QUERY_TEST_XNL_DATA = "( {0}=''{1}'' AND {2}={3} AND ORA_HASH({4},{5},{6}) >= {7} ) \n";
        public static final String QUERY_BUILD_2D_DATA_PREFIX = "SELECT {0} \nFROM (SELECT /*+ no_merge */ t.*, row_number() over(partition by {2} order by ora_hash({3})) RNUM FROM {1} t) \nWHERE RNUM = 1 \n OR ";
        public static final String QUERY_BUILD_2D_DATA = "( {0}={1} and ORA_HASH(RNUM,({2}-1),{3}) < {4} ) \n";
        public static final String QUERY_TEST_2D_DATA = "( {0}={1} and ORA_HASH(RNUM,({2}-1),{3}) >= {4} ) \n";
        public static final String QUERY_BUILD_2D_DATA_NULL_VALUE = "( {0} IS NULL and ORA_HASH(RNUM,({1}-1),{2}) < {3} ) \n";
        public static final String QUERY_TEST_2D_DATA_NULL_VALUE = "( {0} IS NULL and ORA_HASH(RNUM,({1}-1),{2}) >= {3} ) \n";
        public static final String CREATE_TABLE_PREFIX = "CREATE {0} {1} AS \n";
    }
}

