/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.transforms;

import java.io.Serializable;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.sql.PLSQLPackage;
import oracle.dmt.dm4j.wizard.director.transforms.TransformPLSQLPackage;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedTargetState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TableViewNameState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class StratifiedDirector
extends TransformsDirector {
    CaseCountDataState m_dataState;
    TableViewNameState m_nameState;
    StratifiedTargetState m_targetState;
    StratifiedSettingsState m_settingsState;
    FinishState m_finishState;
    Hashtable m_codeGenCreateBuildArguments;
    String m_caseID = "ROWNUM";
    private StringBuffer m_results = new StringBuffer();
    private StringBuffer m_queryResults = new StringBuffer();
    private TransformPLSQLPackage m_componentResults = null;
    protected Hashtable m_TxData;

    public Hashtable getCodeGenCreateBuildArguments() {
        return this.m_codeGenCreateBuildArguments;
    }

    public StratifiedDirector(TransformWizardState transformWizardState) {
        super(transformWizardState);
    }

    public void construct() throws Exception {
        long l;
        long l2;
        int n;
        Serializable serializable;
        Object object;
        Object object2;
        Object[] objectArray;
        this.m_dataState = (CaseCountDataState)this.getWizardState().getStep(StepType.DATA_STEP);
        this.m_nameState = (TableViewNameState)this.getWizardState().getStep(StepType.NAME_STEP);
        this.m_targetState = (StratifiedTargetState)this.getWizardState().getStep(StepType.SETTING_STEP);
        this.m_settingsState = (StratifiedSettingsState)this.getWizardState().getStep(StepType.SETTING_STEP_1);
        this.m_finishState = (FinishState)this.getWizardState().getStep(StepType.FINISH_STEP);
        BrowserContext browserContext = this.getWizardState().getBrowserContext();
        boolean bl = this.m_dataState.isMultipleRecordCaseFormat();
        boolean bl2 = this.m_nameState.getCreateTable();
        String string = "TABLE";
        if (!bl2) {
            string = "VIEW";
        }
        String string2 = "\"" + this.m_dataState.getSelectedSchemaName() + "\"" + ".\"" + this.m_dataState.getSelectedTableName() + "\"";
        String string3 = DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewName());
        String string4 = "\"" + DM4JConnectionManager.getUser() + "\"." + "\"" + DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewName()) + "\"";
        String string5 = this.m_nameState.getViewComment();
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        String string6 = "\"" + this.m_targetState.getTargetColumnName() + "\"";
        ArrayList[] arrayListArray = this.m_settingsState.getTableModel().getTableContents();
        if (bl) {
            objectArray = "\"" + this.m_dataState.getSequenceIDMapping() + "\"";
            object2 = "\"" + this.m_dataState.getAttributeNameMapping() + "\"";
            object = "\"" + this.m_dataState.getValueMapping() + "\"";
            string6 = this.m_targetState.getTargetColumnName();
            stringBuffer = new StringBuffer("WITH sampleseqids AS (");
            Object[] objectArray2 = null;
            objectArray2 = new Object[]{objectArray, string2};
            stringBuffer.append(MessageFormat.format("SELECT {0} FROM {1} WHERE \n", objectArray2));
            int n2 = arrayListArray[0].size();
            boolean bl3 = this.m_targetState.getLDSDataSource().isSingleMetric();
            serializable = DecimalFormat.getNumberInstance();
            ((NumberFormat)serializable).setGroupingUsed(false);
            for (n = 0; n < n2; ++n) {
                l2 = (Long)arrayListArray[1].get(n);
                l = (Long)arrayListArray[4].get(n);
                if (!bl3) {
                    objectArray2 = new Object[]{object2, string6, object, ((Format)serializable).format(arrayListArray[0].get(n)), objectArray, l2 + "", this.m_settingsState.getRandomSeed() + "", l + ""};
                    stringBuffer.append(MessageFormat.format("( {0}=''{1}'' AND {2}={3} AND ORA_HASH({4},{5},{6}) < {7} ) \n", objectArray2));
                } else {
                    objectArray2 = new Object[]{object, ((Format)serializable).format(arrayListArray[0].get(n)), objectArray, l2 + "", this.m_settingsState.getRandomSeed() + "", l + ""};
                    stringBuffer.append(MessageFormat.format("( {0}={1} AND ORA_HASH({2},{3},{4}) < {5} ) \n", objectArray2));
                }
                if (n == n2 - 1) continue;
                stringBuffer.append(" OR ");
            }
            stringBuffer.append(") \nSELECT t.* FROM sampleseqids s, " + string2 + " t WHERE s." + (String)objectArray + " = " + "t." + (String)objectArray);
        } else {
            Serializable serializable2;
            String string7;
            objectArray = this.getWizardState().getConnection();
            object2 = DatabaseMetadata.getColumnNames((Connection)objectArray, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
            object = new StringBuffer();
            int n3 = ((Vector)object2).size();
            for (int i = 0; i < n3; ++i) {
                string7 = (String)((Vector)object2).get(i);
                ((StringBuffer)object).append("\"" + string7 + "\"");
                if (i >= n3 - 1) continue;
                ((StringBuffer)object).append(", ");
            }
            stringBuffer = new StringBuffer();
            Object[] objectArray3 = null;
            string7 = this.m_caseID;
            if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
                serializable2 = browserContext.getInputDataDescriptor();
                this.m_caseID = ((ComplexDataStructure)serializable2).getCaseId();
                string7 = "\"" + this.m_caseID + "\"";
            } else {
                try {
                    serializable2 = DatabaseMetadata.getSequenceColumn((Connection)objectArray, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
                    if (serializable2 != null && ((Vector)serializable2).size() > 0) {
                        this.m_caseID = ((Vector)serializable2).get(0).toString();
                        string7 = "\"" + this.m_caseID + "\"";
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            objectArray3 = new Object[]{((StringBuffer)object).toString(), string2, string6, string7};
            stringBuffer.append(MessageFormat.format("SELECT {0} \nFROM (SELECT /*+ no_merge */ t.*, row_number() over(partition by {2} order by ora_hash({3})) RNUM FROM {1} t) \nWHERE RNUM = 1 \n OR ", objectArray3));
            int n4 = arrayListArray[0].size();
            for (n = 0; n < n4; ++n) {
                l2 = (Long)arrayListArray[1].get(n);
                l = (Long)arrayListArray[4].get(n);
                String string8 = null;
                if (arrayListArray[0].get(n) == null) {
                    objectArray3 = new Object[]{string6, l2 + "", this.m_settingsState.getRandomSeed() + "", l + ""};
                    stringBuffer.append(MessageFormat.format("( {0} IS NULL and ORA_HASH(RNUM,({1}-1),{2}) < {3} ) \n", objectArray3));
                } else {
                    string8 = this.m_settingsState.isAttrValNumber() ? "" + ((Number)arrayListArray[0].get(n)).doubleValue() : "'" + DM4JStringUtils.escapeSingleQuotesForSQL(arrayListArray[0].get(n).toString()) + "'";
                }
                if (string8 != null) {
                    objectArray3 = new Object[]{string6, string8, l2 + "", this.m_settingsState.getRandomSeed() + "", l + ""};
                    stringBuffer.append(MessageFormat.format("( {0}={1} and ORA_HASH(RNUM,({2}-1),{3}) < {4} ) \n", objectArray3));
                }
                if (n == n4 - 1) continue;
                stringBuffer.append(" OR ");
            }
        }
        objectArray = new Object[]{string, string4};
        stringBuffer2 = new StringBuffer(MessageFormat.format("CREATE {0} {1} AS \n", objectArray));
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer3 = new StringBuffer("COMMENT ON TABLE " + string4 + " IS '" + StratifiedDirector.getReplacedString(string5, "'", "''") + "'");
        this.m_queryResults = stringBuffer;
        int n5 = 2;
        object = null;
        ComplexDataStructure complexDataStructure = null;
        Object var18_24 = null;
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            object = browserContext.getInputDataDescriptor();
            n5 += 2 * ((ComplexDataStructure)object).getColumnMap().size();
        }
        StringBuffer[] stringBufferArray = new StringBuffer[n5];
        stringBufferArray[0] = new StringBuffer(stringBuffer2.toString());
        stringBufferArray[1] = new StringBuffer(stringBuffer3.toString());
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            complexDataStructure = TransformsDirector.createCDSDataStructureAndSQL((ComplexDataStructure)object, "Stratified Sample Output", ((ComplexDataStructure)object).getCaseSchema(), ((ComplexDataStructure)object).getCaseTable(), string3, string, stringBufferArray, 2);
        }
        this.m_stmtVisibleComponentArray = stringBufferArray;
        if (browserContext != null && object != null) {
            serializable = browserContext.getSampledInputDataDescriptor();
            if (serializable != null) {
                String string9 = ((ComplexDataStructure)object).getCaseTable();
                String string10 = ValidationUtil.createUniqueTableNameUsingRandom(string9, this.getWizardState().getConnection(), "_S");
                StringBuffer stringBuffer4 = new StringBuffer("CREATE VIEW ");
                stringBuffer4.append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(((ComplexDataStructure)serializable).getCaseSchema())));
                stringBuffer4.append(".");
                stringBuffer4.append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(string10)));
                stringBuffer4.append(" AS\n   (SELECT * FROM ");
                stringBuffer4.append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(((ComplexDataStructure)serializable).getCaseSchema())));
                stringBuffer4.append(".");
                stringBuffer4.append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(((ComplexDataStructure)serializable).getCaseTable())));
                stringBuffer4.append(")");
                this.m_stmtComponentArray = new StringBuffer[stringBufferArray.length + 1];
                System.arraycopy(stringBufferArray, 0, this.m_stmtComponentArray, 0, stringBufferArray.length);
                this.m_stmtComponentArray[stringBufferArray.length] = stringBuffer4;
                ComplexDataStructure complexDataStructure2 = new ComplexDataStructure(((ComplexDataStructure)serializable).getName() + "SAMPLED_RESULT", string10, complexDataStructure.getCaseSchema(), complexDataStructure.getCaseId());
                complexDataStructure2.setColumnMap(complexDataStructure.getColumnMap());
                this.getWizardState().setOutputSampledDataDescriptor(complexDataStructure2);
            }
        } else {
            this.m_stmtComponentArray = new StringBuffer[stringBufferArray.length];
            System.arraycopy(stringBufferArray, 0, this.m_stmtComponentArray, 0, stringBufferArray.length);
        }
        this.getWizardState().setNewTranformName(DM4JConnectionManager.getUser(), string3, !bl2);
        this.getWizardState().setOutputDataDescriptor(complexDataStructure);
    }

    public String getConstructResults() throws Exception {
        return null;
    }

    public String getConstructResultsQueryOnly() throws Exception {
        return this.m_queryResults.toString();
    }

    public PLSQLPackage getConstructComponent() throws Exception {
        return null;
    }

    public void executeHiddenSQLStatements() throws Exception {
        if (DiscretizeDataSource.isDebug()) {
            ActivityUtils.printOutoutLineage(this.getWizardState().getOutputSampledDataDescriptor(), this.getWizardState().getOutputDataDescriptor());
        }
    }

    public Vector getTxSQL(String string) {
        if (this.m_TxData != null) {
            return (Vector)this.m_TxData.get(string);
        }
        return null;
    }

    public void setTxSQL(String string, Vector vector) {
        if (this.m_TxData == null) {
            this.m_TxData = new Hashtable();
        }
        this.m_TxData.put(string, vector);
    }

    public void constructCodeGen() throws Exception {
        this.m_dataState = (CaseCountDataState)this.getWizardState().getStep(StepType.DATA_STEP);
        this.m_nameState = (TableViewNameState)this.getWizardState().getStep(StepType.NAME_STEP);
        this.m_targetState = (StratifiedTargetState)this.getWizardState().getStep(StepType.SETTING_STEP);
        this.m_settingsState = (StratifiedSettingsState)this.getWizardState().getStep(StepType.SETTING_STEP_1);
        this.m_finishState = (FinishState)this.getWizardState().getStep(StepType.FINISH_STEP);
        String string = this.m_targetState.getTargetColumnName();
        Double d = this.m_targetState.getSamplePercentageOfCases();
        String string2 = DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewName());
        Connection connection = this.getWizardState().getConnection();
        Vector vector = DatabaseMetadata.getColumnNames(connection, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
        this.m_codeGenCreateBuildArguments = new Hashtable();
        this.m_codeGenCreateBuildArguments.put("ATTRIBUTE_LIST", vector);
        this.m_codeGenCreateBuildArguments.put("TARGET_ATTR_VALUE", string);
        this.m_codeGenCreateBuildArguments.put("PERCENTAGE", d);
        BrowserContext browserContext = this.getWizardState().getBrowserContext();
        ComplexDataStructure complexDataStructure = null;
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            complexDataStructure = browserContext.getInputDataDescriptor();
            Vector vector2 = new Vector();
            TransformsDirector.createCDSDataStructureAndSQLCodeGen(complexDataStructure, "Split Build Output", string2, "TABLE", vector2);
            this.setTxSQL("Split Build Output", vector2);
        }
    }

    static interface SQL_TEMPLATES_WITH_TMP_TABLE {
        public static final String QUERY_SAMPLE_2D_DATA = "SELECT /*+ noparallel(t)*/ t.* FROM {0} t, {1} tmp WHERE t.{2}=tmp.VALUE and sign(rownum)-1+dbms_random.value <= tmp.SAMPLE_PERCENTAGE";
        public static final String QUERY_SAMPLE_XNL_DATA = "SELECT * FROM (SELECT /*+ noparallel(t)*/ originalTable.* FROM (SELECT DISTINCT {3} FROM  {0} t, {1} tmp WHERE t.{4}='{2}' and t.{5}=tmp.VALUE and sign(rownum)-1+dbms_random.value <= tmp.SAMPLE_PERCENTAGE) sampleSeqIds, {0} originalTable WHERE sampleSeqIds.{3}=originalTable.{3}";
        public static final String CREATE_TABLE_PREFIX = "CREATE {0} {1} AS ";
    }

    static interface SQL_TEMPLATES {
        public static final String QUERY_SAMPLE_XNL_DATA_PREFIX = "SELECT {0} FROM {1} WHERE \n";
        public static final String QUERY_SAMPLE_XNL_DATA = "( {0}=''{1}'' AND {2}={3} AND ORA_HASH({4},{5},{6}) < {7} ) \n";
        public static final String QUERY_SAMPLE_XNL_DATA_SINGLEMETRIC = "( {0}={1} AND ORA_HASH({2},{3},{4}) < {5} ) \n";
        public static final String QUERY_SAMPLE_2D_DATA_PREFIX = "SELECT {0} \nFROM (SELECT /*+ no_merge */ t.*, row_number() over(partition by {2} order by ora_hash({3})) RNUM FROM {1} t) \nWHERE RNUM = 1 \n OR ";
        public static final String QUERY_SAMPLE_2D_DATA = "( {0}={1} and ORA_HASH(RNUM,({2}-1),{3}) < {4} ) \n";
        public static final String QUERY_SAMPLE_2D_DATA_NULL_VALUE = "( {0} IS NULL and ORA_HASH(RNUM,({1}-1),{2}) < {3} ) \n";
        public static final String CREATE_TABLE_PREFIX = "CREATE {0} {1} AS \n";
    }
}

