/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.transforms;

import java.text.MessageFormat;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.sql.PLSQLPackage;
import oracle.dmt.dm4j.wizard.director.transforms.TransformPLSQLPackage;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.Filter2DSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ViewNameState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class Filter2DDirector
extends TransformsDirector {
    private DataState m_dataState;
    private ViewNameState m_nameState;
    private Filter2DSettingsState m_settingsState;
    private FinishState m_finishState;
    public static String OUTPUT_VIEW_NAME = "output_view_name";
    private StringBuffer m_results = new StringBuffer();
    private StringBuffer m_queryResults = new StringBuffer();
    private TransformPLSQLPackage m_componentResults = null;

    public Filter2DDirector(TransformWizardState transformWizardState) {
        super(transformWizardState);
    }

    public void construct() throws Exception {
        StringBuffer stringBuffer = new StringBuffer(1000);
        StringBuffer stringBuffer2 = new StringBuffer(1000);
        StringBuffer stringBuffer3 = new StringBuffer(100);
        StringBuffer stringBuffer4 = new StringBuffer(1000);
        this.m_dataState = (DataState)this.getWizardState().getStep(StepType.DATA_STEP);
        this.m_nameState = (ViewNameState)this.getWizardState().getStep(StepType.NAME_STEP);
        this.m_settingsState = (Filter2DSettingsState)this.getWizardState().getStep(StepType.SETTING_STEP);
        this.m_finishState = (FinishState)this.getWizardState().getStep(StepType.FINISH_STEP);
        String string = DM4JConnectionManager.getUser();
        stringBuffer.append("CREATE VIEW \"" + string + "\"." + "{2}" + " AS \n");
        stringBuffer4.append("DROP VIEW \"" + string + "\"." + "{2}" + "\n ");
        stringBuffer2.append("SELECT * ");
        stringBuffer2.append("FROM \"" + this.m_dataState.getSelectedSchemaName() + "\".\"" + this.m_dataState.getSelectedTableName() + "\" ");
        if (this.m_settingsState.getCondition() != null && this.m_settingsState.getCondition().length() > 0) {
            stringBuffer2.append("WHERE " + this.m_settingsState.getCondition());
        }
        String[] stringArray = new String[]{this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName(), DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewName())};
        this.m_queryResults.setLength(0);
        String string2 = Filter2DDirector.getReplacedString(stringBuffer2.toString(), "'", "''");
        this.m_queryResults.append(MessageFormat.format(string2, PLSQLPackage.createQuotedParms(stringArray)));
        stringBuffer2.insert(0, stringBuffer.toString());
        string2 = Filter2DDirector.getReplacedString(this.m_nameState.getViewComment(), "'", "''");
        stringBuffer3.append("COMMENT ON TABLE \"" + DM4JConnectionManager.getUser() + "\"." + this.m_nameState.getViewName() + " IS '" + string2 + "'");
        string2 = Filter2DDirector.getReplacedString(stringBuffer2.toString(), "'", "''");
        StringBuffer stringBuffer5 = new StringBuffer(MessageFormat.format(string2, PLSQLPackage.createQuotedParms(stringArray)));
        StringBuffer[] stringBufferArray = new StringBuffer[]{stringBuffer5, stringBuffer3};
        this.m_stmtComponentArray = stringBufferArray;
        this.getWizardState().setNewTranformName(DM4JConnectionManager.getUser(), this.m_nameState.getViewName(), true);
    }

    public String getConstructResults() throws Exception {
        return null;
    }

    public String getConstructResultsQueryOnly() throws Exception {
        return this.m_queryResults.toString();
    }

    public PLSQLPackage getConstructComponent() throws Exception {
        return null;
    }

    public void clear() throws Exception {
        this.m_componentResults = null;
        this.m_queryResults.setLength(0);
        this.m_results.setLength(0);
    }
}

