/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.transforms;

import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dmt.dm4j.ConnectionPersistence;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.wizard.director.DM4JDirectorInterface;
import oracle.dmt.dm4j.wizard.director.transforms.StreamGobbler;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.commonsteps.OpenFileState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportAdvanceState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportDestinationState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportTableSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class FileImportDirector
implements DM4JDirectorInterface {
    private WizardState m_state;
    String SQLLDR = "{SQLLDR} ";
    String WORKING_DIR = "{WORKING_DIR}";
    String CONTROL_FILE = "fileimport.ctl";
    String LOG_FILE = "fileimport.log";
    String DIR_SEPERATOR = "\\";
    String RECORD_TERMINATOR = "{RECORD_TERMINATOR}";
    String DATA_FILE = "{DATA_FILE}";
    String CONNECTION = "{USER}/{PASSWORD}@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST={HOST})(PORT={PORT})))(CONNECT_DATA=([SID]={SID})))";
    String USER = DM4JConnectionManager.getUser();
    String DBURL = DM4JConnectionManager.getUrl();
    String HOST = DM4JConnectionManager.getHost();
    String PORT = DM4JConnectionManager.getPort();
    String SID = DM4JConnectionManager.getSid();
    boolean CONNECTION_IS_SERVICE = false;
    OpenFileState m_openFileState;
    FileImportSettingsState m_fileImportSettingsState;
    FileImportAdvanceState m_fileImportAdvanceState;
    FileImportTableSettingsState m_fileImportTableSettingsState;
    FileImportDestinationState m_fileImportDestinationState;
    String TEXT_CONTROL_FILE;
    String TEXT_CREATE_NEW_TABLE;
    String CHECK_TEXT_CREATE_NEW_TABLE;
    String EXEC_FILE_IMPORT;
    private String m_textControlFile;
    private String m_textCreateNewTable;
    private String m_execCreateNewTable;
    private String m_execFileImport;
    private int m_existValue;

    public FileImportDirector(WizardState wizardState) {
        if (DM4JConnectionManager.isIsUsingServiceName()) {
            this.CONNECTION_IS_SERVICE = true;
        }
        this.TEXT_CONTROL_FILE = "LOAD DATA CHARACTERSET {CHARSET} INFILE '" + this.DATA_FILE + "' " + this.RECORD_TERMINATOR + " APPEND INTO TABLE \"{TABLE_NAME}\" FIELDS " + "TERMINATED BY {DELIMITER} " + "{ENCLOSURE} " + "TRAILING NULLCOLS " + "(" + "{TABLE_COLUMNS}" + ")";
        this.TEXT_CREATE_NEW_TABLE = "CREATE TABLE \"{TABLE_NAME}\" ({TABLE_COLUMNS})";
        this.CHECK_TEXT_CREATE_NEW_TABLE = "SELECT COUNT(*) TOTAL FROM  \"{TABLE_NAME}\"";
        this.EXEC_FILE_IMPORT = this.SQLLDR + " USERID='" + this.CONNECTION + "' " + ",CONTROL='" + this.WORKING_DIR + this.CONTROL_FILE + "' " + ",LOG='" + this.WORKING_DIR + this.LOG_FILE + "' " + ",DATA='" + this.DATA_FILE + "' " + "{DISCARDMAX}" + " " + "{SKIP}" + " " + "{LOAD}" + " " + "{ERRORS}" + " " + "{DIRECT}";
        this.m_textControlFile = "";
        this.m_textCreateNewTable = "";
        this.m_execCreateNewTable = "";
        this.m_execFileImport = "";
        this.m_existValue = -1;
        this.m_state = wizardState;
    }

    public void construct() throws Exception {
        String string;
        int n;
        this.m_openFileState = (OpenFileState)this.getWizardState().getStep(StepType.DATA_STEP);
        this.m_fileImportSettingsState = (FileImportSettingsState)this.getWizardState().getStep(StepType.SETTING_STEP);
        this.m_fileImportAdvanceState = this.m_fileImportSettingsState.getFileImportAdvanceState();
        this.m_fileImportTableSettingsState = (FileImportTableSettingsState)this.getWizardState().getStep(StepType.SETTING_STEP_1);
        this.m_fileImportDestinationState = (FileImportDestinationState)this.getWizardState().getStep(StepType.SETTING_STEP_2);
        String[] stringArray = this.m_fileImportTableSettingsState.getFieldNames();
        String[] stringArray2 = this.m_fileImportTableSettingsState.getFieldDataTypes();
        String[] stringArray3 = this.m_fileImportTableSettingsState.getFieldSizes();
        String[] stringArray4 = this.m_fileImportTableSettingsState.getFieldNullIfs();
        int n2 = stringArray.length;
        String string2 = "";
        String string3 = "";
        if (System.getProperty("os.name").startsWith("Windows")) {
            this.DIR_SEPERATOR = "\\";
            this.RECORD_TERMINATOR = "";
        } else {
            this.DIR_SEPERATOR = "/";
            this.RECORD_TERMINATOR = this.m_fileImportSettingsState.getHasControlM() ? "\"str '\\r\\n'\"" : "";
        }
        string3 = this.TEXT_CONTROL_FILE;
        File file = this.m_openFileState.getFile();
        string3 = FileImportTableSettingsState.getReplacedString(string3, "{CHARSET}", this.m_openFileState.getOraCharset());
        string3 = FileImportTableSettingsState.getReplacedString(string3, "{DATA_FILE}", file.getName());
        string3 = FileImportTableSettingsState.getReplacedString(string3, "{RECORD_TERMINATOR}", this.RECORD_TERMINATOR);
        string3 = this.m_fileImportSettingsState.getFieldDelimiter().equalsIgnoreCase("WHITESPACE") ? FileImportTableSettingsState.getReplacedString(string3, "{DELIMITER}", this.m_fileImportSettingsState.getFieldDelimiter()) : FileImportTableSettingsState.getReplacedString(string3, "{DELIMITER}", "'" + this.m_fileImportSettingsState.getFieldDelimiter() + "'");
        String string4 = this.m_fileImportSettingsState.getEnclosure();
        if (string4 == "'") {
            string4 = "\\'";
        }
        string3 = this.m_fileImportSettingsState.getEnclosure().length() > 0 ? FileImportTableSettingsState.getReplacedString(string3, "{ENCLOSURE}", "OPTIONALLY ENCLOSED BY '" + string4 + "'") : FileImportTableSettingsState.getReplacedString(string3, "{ENCLOSURE}", "");
        string3 = this.m_fileImportDestinationState.getUseNewTable() ? FileImportTableSettingsState.getReplacedString(string3, "{TABLE_NAME}", this.m_fileImportDestinationState.getNewTableName()) : FileImportTableSettingsState.getReplacedString(string3, "{TABLE_NAME}", this.m_fileImportDestinationState.getSelectedSchemaName() + "\".\"" + this.m_fileImportDestinationState.getSelectedTableName());
        string2 = "";
        for (n = 0; n < n2; ++n) {
            string2 = string2 + " " + stringArray[n];
            String string5 = stringArray2[n];
            this.m_fileImportTableSettingsState.getClass();
            if (string5.equals("VARCHAR2(SIZE)") || stringArray2[n].equals(this.m_fileImportTableSettingsState.NVARCHAR2) || stringArray2[n].equals(this.m_fileImportTableSettingsState.CHAR) || stringArray2[n].equals(this.m_fileImportTableSettingsState.NCHAR) || stringArray2[n].equals(this.m_fileImportTableSettingsState.RAW)) {
                string2 = string2 + " CHAR(" + stringArray3[n] + ") ";
            }
            if (stringArray2[n].equals(this.m_fileImportTableSettingsState.DATE)) {
                string2 = string2 + " DATE '" + stringArray3[n] + "'";
            }
            if (stringArray4[n].length() > 0) {
                string2 = string2 + " NULLIF " + stringArray[n] + "='" + stringArray4[n] + "'";
            }
            if (n >= n2 - 1) continue;
            string2 = string2 + ",";
        }
        this.m_textControlFile = string3 = FileImportTableSettingsState.getReplacedString(string3, "{TABLE_COLUMNS}", string2);
        if (this.m_fileImportDestinationState.getUseNewTable()) {
            string3 = this.TEXT_CREATE_NEW_TABLE;
            string3 = FileImportTableSettingsState.getReplacedString(string3, "{TABLE_NAME}", this.m_fileImportDestinationState.getNewTableName());
            string2 = "";
            for (n = 0; n < n2; ++n) {
                string = stringArray2[n];
                String string6 = stringArray2[n];
                this.m_fileImportTableSettingsState.getClass();
                if (string6.equals("VARCHAR2(SIZE)") || stringArray2[n].equals(this.m_fileImportTableSettingsState.NVARCHAR2) || stringArray2[n].equals(this.m_fileImportTableSettingsState.CHAR) || stringArray2[n].equals(this.m_fileImportTableSettingsState.NCHAR) || stringArray2[n].equals(this.m_fileImportTableSettingsState.RAW)) {
                    string = FileImportTableSettingsState.getReplacedString(stringArray2[n], "SIZE", stringArray3[n]);
                } else if (stringArray2[n].equals(this.m_fileImportTableSettingsState.NUMBER)) {
                    string = FileImportTableSettingsState.getReplacedString(stringArray2[n], "PRECISION,SCALE", stringArray3[n]);
                }
                string2 = string2 + " " + stringArray[n];
                string2 = string2 + " " + string;
                if (n >= n2 - 1) continue;
                string2 = string2 + ",";
            }
            this.m_textCreateNewTable = string3 = FileImportTableSettingsState.getReplacedString(string3, "{TABLE_COLUMNS}", string2);
        }
        string3 = this.EXEC_FILE_IMPORT;
        File file2 = this.m_openFileState.getSqlLoader();
        string3 = FileImportTableSettingsState.getReplacedString(string3, "{SQLLDR}", file2.getPath());
        string = UserPreferences.getInstance().getWorkingDirectory();
        if (string == null) {
            string = "";
        }
        string3 = FileImportTableSettingsState.getReplacedString(string3, "{WORKING_DIR}", string + this.DIR_SEPERATOR);
        file = this.m_openFileState.getFile();
        string3 = FileImportTableSettingsState.getReplacedString(string3, "{DATA_FILE}", file.getPath());
        string3 = this.m_fileImportAdvanceState.getDiscardMaximum() > 0 ? FileImportTableSettingsState.getReplacedString(string3, "{DISCARDMAX}", ",DISCARDMAX=" + this.m_fileImportAdvanceState.getDiscardMaximum()) : FileImportTableSettingsState.getReplacedString(string3, "{DISCARDMAX}", "");
        string3 = this.m_fileImportAdvanceState.getSkipCount() > 0 ? FileImportTableSettingsState.getReplacedString(string3, "{SKIP}", ",SKIP=" + this.m_fileImportAdvanceState.getSkipCount()) : FileImportTableSettingsState.getReplacedString(string3, "{SKIP}", "");
        string3 = this.m_fileImportAdvanceState.getLoadCount() > 0 ? FileImportTableSettingsState.getReplacedString(string3, "{LOAD}", ",LOAD=" + this.m_fileImportAdvanceState.getLoadCount()) : FileImportTableSettingsState.getReplacedString(string3, "{LOAD}", "");
        string3 = this.m_fileImportAdvanceState.getMaxError() > 0 ? FileImportTableSettingsState.getReplacedString(string3, "{ERRORS}", ",ERRORS=" + this.m_fileImportAdvanceState.getMaxError()) : FileImportTableSettingsState.getReplacedString(string3, "{ERRORS}", "");
        string3 = this.m_fileImportAdvanceState.getUseDirectPath() ? FileImportTableSettingsState.getReplacedString(string3, "{DIRECT}", ",DIRECT=true") : FileImportTableSettingsState.getReplacedString(string3, "{DIRECT}", "");
        this.m_execFileImport = string3;
    }

    public void run() throws Exception {
        Object object;
        if (this.m_fileImportDestinationState.getUseNewTable()) {
            this.DBURL = DM4JConnectionManager.getUrl();
            this.HOST = DM4JConnectionManager.getHost();
            this.PORT = DM4JConnectionManager.getPort();
            this.SID = DM4JConnectionManager.getSid();
        } else {
            String string = this.m_fileImportDestinationState.getSelectedDBName();
            this.DBURL = "jdbc:oracle:thin:@" + string;
            object = new StringTokenizer(string, ":");
            this.HOST = ((StringTokenizer)object).nextToken();
            this.PORT = ((StringTokenizer)object).nextToken();
            this.SID = ((StringTokenizer)object).nextToken();
        }
        String string = UserPreferences.getInstance().getWorkingDirectory();
        object = string != null ? new File(string + this.DIR_SEPERATOR + this.CONTROL_FILE) : new File(this.CONTROL_FILE);
        FileWriter fileWriter = new FileWriter((File)object);
        fileWriter.write(this.m_textControlFile);
        fileWriter.close();
        if (this.m_fileImportDestinationState.getUseNewTable()) {
            this.exec_sql(this.DBURL, this.USER, this.m_textCreateNewTable);
        }
        ConnectionPersistence connectionPersistence = ConnectionPersistence.getInstance();
        char[] cArray = ConnectionPersistence.retrieveCredential(connectionPersistence.getDefaultConnectionName());
        this.m_execFileImport = FileImportTableSettingsState.getReplacedString(this.m_execFileImport, "{USER}", this.USER);
        this.m_execFileImport = FileImportTableSettingsState.getReplacedString(this.m_execFileImport, "{PASSWORD}", cArray);
        this.m_execFileImport = FileImportTableSettingsState.getReplacedString(this.m_execFileImport, "{HOST}", this.HOST);
        this.m_execFileImport = FileImportTableSettingsState.getReplacedString(this.m_execFileImport, "{PORT}", this.PORT);
        this.m_execFileImport = FileImportTableSettingsState.getReplacedString(this.m_execFileImport, "{SID}", this.SID);
        this.m_execFileImport = this.CONNECTION_IS_SERVICE ? FileImportTableSettingsState.getReplacedString(this.m_execFileImport, "[SID]", "SERVICE_NAME") : FileImportTableSettingsState.getReplacedString(this.m_execFileImport, "[SID]", "SID");
        this.exec_command(this.m_execFileImport);
    }

    public String getConstructExecCreateNewTable() throws Exception {
        return this.m_execCreateNewTable;
    }

    public String getConstructExecFileImport() throws Exception {
        return this.m_execFileImport;
    }

    public String getConstructResults() throws Exception {
        return "file_import";
    }

    public void clear() throws Exception {
        this.m_execCreateNewTable = "";
        this.m_execFileImport = "";
    }

    public void exec_command(String string) throws Exception {
        Object object;
        Process process;
        Runtime runtime = Runtime.getRuntime();
        String string2 = System.getProperty("os.name");
        String[] stringArray = new String[3];
        if (string2.equals("Windows NT")) {
            stringArray[0] = "cmd.exe";
            stringArray[1] = "/C";
            stringArray[2] = string;
            process = runtime.exec(stringArray);
        } else if (string2.equals("Windows 95")) {
            stringArray[0] = "command.com";
            stringArray[1] = "/C";
            stringArray[2] = string;
            process = runtime.exec(stringArray);
        } else if (string2.equals("Windows 2000")) {
            System.out.println("DEBUG: Windows 2000");
            stringArray[0] = "cmd.exe";
            stringArray[1] = "/C";
            stringArray[2] = string;
            process = runtime.exec(stringArray);
            System.out.println("process ID:" + process);
        } else {
            process = runtime.exec(string);
        }
        StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "ERROR");
        StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "OUTPUT");
        streamGobbler.start();
        streamGobbler2.start();
        int n = process.waitFor();
        System.out.println("ExitValue(0=success, others=error):" + n);
        this.m_existValue = n;
        String string3 = this.CHECK_TEXT_CREATE_NEW_TABLE;
        string3 = this.m_fileImportDestinationState.getUseNewTable() ? FileImportTableSettingsState.getReplacedString(string3, "{TABLE_NAME}", this.m_fileImportDestinationState.getNewTableName()) : FileImportTableSettingsState.getReplacedString(string3, "{TABLE_NAME}", this.m_fileImportDestinationState.getSelectedSchemaName() + "\".\"" + this.m_fileImportDestinationState.getSelectedTableName());
        int n2 = 0;
        int n3 = -1;
        int n4 = -2;
        int n5 = n2;
        try {
            object = DM4JConnectionManager.getDbConnection();
            Vector vector = FileImportDirector.getVectorData((Connection)object, string3);
            Object[] objectArray = (Object[])vector.get(0);
            BigDecimal bigDecimal = (BigDecimal)objectArray[0];
            n5 = bigDecimal.intValue() > 0 ? n2 : n3;
        }
        catch (Exception exception) {
            System.out.println("Failed to obain java.sql.Connection to check table status");
            n5 = n4;
        }
        System.out.println("returnTableValue(0=NO_ERROR, -1=EMPTY_TABLE, -2=NO_TABLE):" + n5);
        if (n5 == n3 | n5 == n4) {
            object = "Unable to execute " + string + "\n";
            object = (String)object + streamGobbler.getMessage();
            throw new Exception((String)object);
        }
        if (n5 == n2 && this.m_existValue != n2) {
            this.m_existValue = n2;
            object = "Not all data can be loaded, please view log file for more information.\n";
            object = (String)object + streamGobbler.getMessage();
            throw new Exception((String)object);
        }
    }

    public void exec_sql(String string, String string2, String string3) throws Exception {
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            Statement statement = connection.createStatement();
            statement.execute(string3);
            statement.close();
            connection.close();
        }
        catch (Exception exception) {
            String string4 = "Unable to execute " + string3 + "\n";
            string4 = string4 + exception;
            System.out.println("ERROR : " + exception);
            throw new Exception(string4);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Vector getVectorData(Connection connection, String string) throws Exception {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int n2 = 0;
            Vector<Object[]> vector = new Vector<Object[]>();
            while (resultSet.next()) {
                ++n2;
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    Object object;
                    objectArray[i] = object = resultSet.getObject(i + 1);
                }
                vector.addElement(objectArray);
            }
            resultSet.close();
            resultSet = null;
            statement.close();
            statement = null;
            return vector;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    protected WizardState getWizardState() {
        return this.m_state;
    }

    public int getExistValue() {
        return this.m_existValue;
    }
}

