/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.transforms;

import java.sql.Connection;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FinishState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.jdbc.OracleCallableStatement;

public class ExecuteTransformationProcess
extends LongRunningProcess
implements Cancelable {
    private boolean m_canceled = false;
    private TransformWizardState m_wizardState;
    private Connection m_dbConn;
    private OracleCallableStatement m_statement;

    public ExecuteTransformationProcess(Connection connection, TransformWizardState transformWizardState) {
        this.m_dbConn = connection;
        this.m_wizardState = transformWizardState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.getProgressBar().updateProgress(ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_UPPER_DESC"), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_LOWER_STEP_1"));
            StringBuffer[] stringBufferArray = this.m_wizardState.getSQLStatements();
            if (stringBufferArray != null) {
                for (int i = 0; i < stringBufferArray.length; ++i) {
                    String string = stringBufferArray[i].toString();
                    this.m_statement = (OracleCallableStatement)this.m_dbConn.prepareCall(string);
                    this.m_statement.execute();
                    this.m_statement.close();
                }
            }
            this.m_wizardState.executeHiddenSQLStatements();
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
        finally {
            try {
                if (this.m_statement != null) {
                    this.m_statement.close();
                }
                if (this.m_dbConn != null) {
                    this.m_dbConn.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean createStoredProcedure() {
        FinishState finishState = (FinishState)this.m_wizardState.getStep(StepType.FINISH_STEP);
        return finishState.isGenerateStoredProcedure();
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        if (this.m_statement != null) {
            try {
                this.m_statement.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_canceled = true;
    }
}

