/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.transforms;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.sql.PLSQLPackage;
import oracle.dmt.dm4j.wizard.director.transforms.TransformPLSQLPackage;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ComputeFieldEntry;
import oracle.dmt.dm4j.wizard.state.transformsteps.ComputeFieldSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ViewNameState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class ComputeFieldDirector
extends TransformsDirector {
    private DataState m_dataState;
    private ViewNameState m_nameState;
    private ComputeFieldSettingsState m_settingsState;
    private FinishState m_finishState;
    private ArrayList m_columns = null;
    public static String OUTPUT_VIEW_NAME = "output_view_name";
    private StringBuffer m_results = null;
    private StringBuffer m_queryResults = null;
    private TransformPLSQLPackage m_componentResults = null;

    public ComputeFieldDirector(TransformWizardState transformWizardState) {
        super(transformWizardState);
    }

    public void construct() throws Exception {
        this.m_columns = new ArrayList();
        this.m_results = new StringBuffer();
        this.m_queryResults = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer(1000);
        StringBuffer stringBuffer2 = new StringBuffer(1000);
        StringBuffer stringBuffer3 = new StringBuffer(100);
        StringBuffer stringBuffer4 = new StringBuffer(1000);
        this.m_dataState = (DataState)this.getWizardState().getStep(StepType.DATA_STEP);
        this.m_nameState = (ViewNameState)this.getWizardState().getStep(StepType.NAME_STEP);
        this.m_settingsState = (ComputeFieldSettingsState)this.getWizardState().getStep(StepType.SETTING_STEP);
        this.m_finishState = (FinishState)this.getWizardState().getStep(StepType.FINISH_STEP);
        Connection connection = this.getWizardState().getConnection();
        Vector vector = DatabaseMetadata.getColumnNames(connection, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
        String string = DM4JConnectionManager.getUser();
        stringBuffer.append("CREATE VIEW \"" + string + "\"." + "{2}" + " AS \n");
        stringBuffer4.append("DROP VIEW \"" + string + "\"." + "{2}" + "\n ");
        ComputeFieldEntry[] computeFieldEntryArray = this.m_settingsState.getAttributes();
        stringBuffer2.append("SELECT ");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            stringBuffer2.append("\"" + this.m_dataState.getSelectedTableName() + "\".\"" + string2 + "\", ");
        }
        for (int i = 0; i < computeFieldEntryArray.length; ++i) {
            stringBuffer2.append(computeFieldEntryArray[i].getValue() + " AS \"" + computeFieldEntryArray[i].getName());
            if (i < computeFieldEntryArray.length - 1) {
                stringBuffer2.append("\", ");
                continue;
            }
            stringBuffer2.append("\" \n ");
        }
        stringBuffer2.append("FROM \"" + this.m_dataState.getSelectedSchemaName() + "\".\"" + this.m_dataState.getSelectedTableName() + "\" ");
        this.m_queryResults.append(stringBuffer2);
        stringBuffer2.insert(0, stringBuffer);
        String string3 = ComputeFieldDirector.getReplacedString(this.m_nameState.getViewComment(), "'", "''");
        stringBuffer3.append("COMMENT ON TABLE \"" + DM4JConnectionManager.getUser() + "\"." + this.m_nameState.getViewName() + " IS '" + string3 + "'");
        String[] stringArray = new String[]{this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName(), DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewName())};
        String string4 = ComputeFieldDirector.getReplacedString(stringBuffer2.toString(), "'", "''");
        StringBuffer stringBuffer5 = new StringBuffer(MessageFormat.format(string4.toString(), PLSQLPackage.createQuotedParms(stringArray)));
        StringBuffer[] stringBufferArray = new StringBuffer[]{stringBuffer5, stringBuffer3};
        this.m_stmtComponentArray = stringBufferArray;
        this.getWizardState().setNewTranformName(DM4JConnectionManager.getUser(), this.m_nameState.getViewName(), true);
    }

    public String getConstructResults() throws Exception {
        return null;
    }

    public String getConstructResultsQueryOnly() throws Exception {
        return this.m_queryResults.toString();
    }

    public PLSQLPackage getConstructComponent() throws Exception {
        return null;
    }

    public void clear() throws Exception {
        this.m_componentResults = null;
        this.m_queryResults.setLength(0);
        this.m_results.setLength(0);
    }

    public ArrayList getPreviewColumns() throws Exception {
        return this.m_columns;
    }
}

