/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.Vector;
import javax.datamining.MiningAlgorithm;
import javax.datamining.base.Model;
import javax.datamining.resource.Connection;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.CDSLDSDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.datasources.TargetValueWeightDataSource;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.jdm.OraMiningAlgorithm;

public class ValidateDataToModelProcess
extends LongRunningProcess
implements Cancelable {
    private boolean m_canceled = false;
    Vector m_missingAttributes = new Vector();
    LDSDataSource m_modelLDSDataSource;
    LDSDataSource m_dataLDSDataSource;
    TargetValueDataSource m_targetValueDataSource = null;
    TargetValueCostMatrixDataSource m_targetValueCostMatrixDataSource = null;
    boolean m_extractTargetValues = false;
    boolean m_requireTarget = false;
    String m_target = null;
    Model m_miningModel;
    String m_tgtSchema;
    String m_tgtTable;
    ComplexDataStructure m_tgtCDS;
    String m_srcSchema;
    String m_srcTable;
    DataState m_dataState;
    boolean m_allowTextDataTypes = false;
    Thread m_workerThread;
    Thread m_workerThread2;
    Thread m_workerThread3;
    Thread m_workerThread4;
    Thread m_workerThread5;
    private String CREATE_LDS = "CreateLDS";
    private String CREATE_MODEL_LDS = "CreateModelLDS";
    private String VALIDATE_LDS = "ValidateLDS";
    private String EXTRACT_TARGET_VALUES = "ExtractTargetValues";

    public ValidateDataToModelProcess(DataState dataState, Model model, boolean bl, boolean bl2) throws Exception {
        this(dataState.getSelectedSchemaName(), dataState.getSelectedTableName(), model, bl, bl2);
        this.m_tgtCDS = dataState.getInputCDS();
        this.m_dataState = dataState;
    }

    public ValidateDataToModelProcess(String string, String string2, Model model, boolean bl, boolean bl2) throws Exception {
        this.m_extractTargetValues = bl;
        this.m_requireTarget = bl2;
        this.m_miningModel = model;
        this.m_tgtSchema = string;
        this.m_tgtTable = string2;
        MiningAlgorithm miningAlgorithm = this.m_miningModel.getMiningAlgorithm();
        if (miningAlgorithm.equals(MiningAlgorithm.svmClassification) || miningAlgorithm.equals(MiningAlgorithm.svmRegression) || miningAlgorithm.equals(OraMiningAlgorithm.nonNegativeMatrixFactorization)) {
            this.m_allowTextDataTypes = true;
        }
    }

    public ValidateDataToModelProcess(String string, String string2, String string3, String string4, String string5) throws Exception {
        this.m_target = string5;
        this.m_extractTargetValues = false;
        this.m_requireTarget = false;
        this.m_miningModel = null;
        this.m_tgtSchema = string;
        this.m_tgtTable = string2;
        this.m_srcSchema = string3;
        this.m_srcTable = string4;
        this.m_allowTextDataTypes = true;
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }

    public Vector getMissingAttributes() {
        return this.m_missingAttributes;
    }

    protected void setMissingAttributes(Vector vector) {
        this.m_missingAttributes = vector;
    }

    public LDSDataSource getModelLDSDataSource() {
        return this.m_modelLDSDataSource;
    }

    protected void setModelLDSDataSource(LDSDataSource lDSDataSource) {
        this.m_modelLDSDataSource = lDSDataSource;
    }

    public LDSDataSource getDataLDSDataSource() {
        return this.m_dataLDSDataSource;
    }

    protected void setDataLDSDataSource(LDSDataSource lDSDataSource) {
        this.m_dataLDSDataSource = lDSDataSource;
    }

    public TargetValueDataSource getTargetValuesDataSource() {
        return this.m_targetValueDataSource;
    }

    public TargetValueCostMatrixDataSource getTargetValueCostMatrixDataSource() {
        return this.m_targetValueCostMatrixDataSource;
    }

    protected void setTargetValuesDataSource(TargetValueDataSource targetValueDataSource) {
        this.m_targetValueDataSource = targetValueDataSource;
    }

    public void run() {
        try {
            this.createWorkerThreads();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
            exception.printStackTrace();
            return;
        }
        try {
            this.m_workerThread.join();
            if (this.m_dataLDSDataSource.getException() != null) {
                throw this.m_dataLDSDataSource.getException();
            }
            this.m_workerThread2.join();
            if (this.m_modelLDSDataSource.getException() != null) {
                throw this.m_modelLDSDataSource.getException();
            }
            if (this.m_target != null) {
                for (int i = 0; i < this.m_modelLDSDataSource.getRowCount(); ++i) {
                    if (((String)this.m_modelLDSDataSource.getData(1, i)).compareTo(this.m_target) != 0) continue;
                    this.m_modelLDSDataSource.setData(5, i, "target");
                    break;
                }
            }
            this.createValidationThread();
            this.m_workerThread3.join();
            if (this.m_extractTargetValues && this.m_missingAttributes != null) {
                this.createTargetValuesThread();
                this.m_workerThread4.join();
            }
            this.getProgressBar().setDoneStatus();
        }
        catch (InterruptedException interruptedException) {
            this.setException(interruptedException);
            this.getProgressBar().setDoneStatus();
            this.m_workerThread.interrupt();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
            this.m_workerThread.interrupt();
        }
    }

    private void createWorkerThreads() throws Exception {
        this.m_dataLDSDataSource = new CDSLDSDataSource(DM4JConnectionManager.getDbConnection(), null, null, this.m_tgtCDS, this.m_tgtSchema, this.m_tgtTable, this.m_allowTextDataTypes, true);
        this.m_workerThread = new Thread((Runnable)this.m_dataLDSDataSource, this.CREATE_LDS);
        this.m_workerThread.setDaemon(false);
        this.m_workerThread.start();
        Connection connection = DM4JConnectionManager.getConnection();
        if (this.m_miningModel == null) {
            this.m_modelLDSDataSource = new LDSDataSource(connection, this.m_srcSchema, this.m_srcTable, this.m_allowTextDataTypes, true);
            this.m_workerThread2 = new Thread((Runnable)this.m_modelLDSDataSource, this.CREATE_LDS);
        } else {
            this.m_modelLDSDataSource = new LDSDataSource(connection, this.m_miningModel);
            this.m_workerThread2 = new Thread((Runnable)this.m_modelLDSDataSource, this.CREATE_MODEL_LDS);
        }
        this.m_workerThread2.setDaemon(false);
        this.m_workerThread2.start();
    }

    private void createValidationThread() {
        this.m_workerThread3 = new Thread(new Runnable(){

            public void run() {
                ValidateDataToModelProcess.this.m_missingAttributes = ValidateDataToModelProcess.this.m_modelLDSDataSource.validateCompatibility(ValidateDataToModelProcess.this.m_dataLDSDataSource, ValidateDataToModelProcess.this.m_requireTarget);
            }
        });
        this.m_workerThread3.setDaemon(false);
        this.m_workerThread3.start();
    }

    private void createTargetValuesThread() throws Exception {
        boolean bl = this.m_miningModel.getMiningAlgorithm().compareTo(MiningAlgorithm.svmClassification) != 0;
        Connection connection = DM4JConnectionManager.getConnection();
        this.m_targetValueDataSource = bl ? new TargetValueDataSource(connection, this.m_tgtSchema, this.m_tgtTable, this.m_modelLDSDataSource.getTargetAttributeName()) : new TargetValueWeightDataSource(connection, this.m_tgtSchema, this.m_tgtTable, this.m_modelLDSDataSource.getTargetAttributeName());
        this.m_workerThread4 = new Thread((Runnable)this.m_targetValueDataSource, this.EXTRACT_TARGET_VALUES);
        this.m_workerThread4.setDaemon(false);
        this.m_workerThread4.start();
        this.m_workerThread4.join();
        Vector vector = this.m_targetValueDataSource.getAttributes(0);
        this.m_targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(vector);
        this.m_workerThread5 = new Thread((Runnable)this.m_targetValueCostMatrixDataSource, this.EXTRACT_TARGET_VALUES);
        this.m_workerThread5.setDaemon(false);
        this.m_workerThread5.start();
    }
}

