/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.Vector;
import javax.datamining.resource.Connection;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.datasources.TargetValueWeightDataSource;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetValueState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;

public class TargetValueExtractProcess
extends LongRunningProcess
implements Cancelable {
    private static String COMMAND_MONITOR = "TargetExtractValuePanelMonitor";
    WizardStepState m_stepState;
    private boolean m_canceled = false;
    private boolean m_targetPriors = true;
    private boolean m_avgCosts = false;
    Thread m_workerThread;
    Thread m_workerThread2;
    private TargetState m_targetState = null;
    private TargetValueState m_targetValueState = null;
    private TargetValueDataSource m_targetValueDataSource = null;
    private TargetValueCostMatrixDataSource m_targetValueCostMatrixDataSource = null;
    private String THREAD_NAME = "ExtractTargetValues";
    boolean m_dialogCanceled = false;

    public TargetValueExtractProcess(DataState dataState) throws Exception {
        this.m_stepState = dataState;
    }

    public void run() {
        try {
            this.m_targetState = (TargetState)this.m_stepState.getparentWizardState().getStep(StepType.TARGET_STEP);
            this.m_targetValueState = (TargetValueState)this.m_stepState.getparentWizardState().getStep(StepType.TARGET_VALUE_STEP);
            WizardStepState wizardStepState = (WizardStepState)this.m_stepState.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            if (wizardStepState instanceof ClassificationAlgorithmState) {
                ClassificationAlgorithmState classificationAlgorithmState = (ClassificationAlgorithmState)wizardStepState;
                this.m_targetPriors = !classificationAlgorithmState.isSupportVectorMachineSelected();
                this.m_avgCosts = classificationAlgorithmState.isDecisionTreeSelected();
            }
            this.createWorkerThreads();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
            exception.printStackTrace();
            return;
        }
        try {
            this.m_workerThread.join();
            if (this.m_targetValueDataSource.getException() != null) {
                throw this.m_targetValueDataSource.getException();
            }
            this.m_workerThread2.join();
            if (this.m_targetValueCostMatrixDataSource.getException() != null) {
                throw this.m_targetValueCostMatrixDataSource.getException();
            }
            this.m_targetValueState.setTargetValues(this.m_targetValueDataSource);
            this.m_targetValueState.setTargetValueCostMatrix(this.m_targetValueCostMatrixDataSource);
            this.getProgressBar().setDoneStatus();
        }
        catch (InterruptedException interruptedException) {
            this.setException(interruptedException);
            this.getProgressBar().setDoneStatus();
            this.m_workerThread.interrupt();
            this.m_workerThread2.interrupt();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
            this.m_workerThread.interrupt();
            this.m_workerThread2.interrupt();
        }
    }

    private void createWorkerThreads() throws Exception {
        Connection connection = DM4JConnectionManager.getConnection();
        this.m_targetValueDataSource = this.m_targetPriors ? new TargetValueDataSource(connection, ((DataState)this.m_stepState).getSelectedSchemaName(), ((DataState)this.m_stepState).getSelectedTableName(), this.m_targetState.getTargetAttribute()) : new TargetValueWeightDataSource(connection, ((DataState)this.m_stepState).getSelectedSchemaName(), ((DataState)this.m_stepState).getSelectedTableName(), this.m_targetState.getTargetAttribute());
        this.m_workerThread = new Thread((Runnable)this.m_targetValueDataSource, this.THREAD_NAME);
        this.m_workerThread.setDaemon(false);
        this.m_workerThread.start();
        this.m_workerThread.join();
        Vector vector = this.m_targetValueDataSource.getAttributes(0);
        this.m_targetValueCostMatrixDataSource = this.m_avgCosts ? new TargetValueCostMatrixDataSource(this.m_targetValueDataSource) : new TargetValueCostMatrixDataSource(vector);
        this.m_workerThread2 = new Thread((Runnable)this.m_targetValueCostMatrixDataSource, this.THREAD_NAME);
        this.m_workerThread2.setDaemon(false);
        this.m_workerThread2.start();
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }
}

