/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import javax.datamining.ExecutionHandle;
import javax.datamining.ExecutionState;
import javax.datamining.ExecutionStatus;
import javax.datamining.NamedObject;
import javax.datamining.supervised.regression.RegressionTestMetrics;
import javax.datamining.supervised.regression.RegressionTestTask;
import javax.datamining.supervised.regression.RegressionTestTaskFactory;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.director.minings.MiningBuilder;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTestNameState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionModelState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class RegressionModelTestBuilder
extends MiningBuilder {
    private static RegressionTestTaskFactory m_testFactory = null;
    private String m_uniqueTaskName = null;

    public RegressionModelTestBuilder(WizardState wizardState) {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        m_testFactory = (RegressionTestTaskFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.supervised.regression.RegressionTestTask");
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_uniqueTaskName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_uniqueTaskName + "\"", NamedObject.task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            dMEMetadata.deleteTestRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    protected String getMiningTask() throws Exception {
        RegressionModelState regressionModelState = (RegressionModelState)this.m_state.getStep(StepType.MODEL_STEP);
        String string = regressionModelState.getSelectedModelName();
        ModelTestNameState modelTestNameState = (ModelTestNameState)this.m_state.getStep(StepType.NAME_STEP);
        String string2 = DM4JStringUtils.trimDoubleQuotes(modelTestNameState.getModelTestName());
        this.m_uniqueTaskName = ValidationUtil.createUniqueJDMObjectName(ValidationUtil.addPrefixToName("DM4J$", string2), this.m_state.getConnection(), "_J");
        String string3 = this.createPhysicalDataSpecification();
        RegressionTestTask regressionTestTask = m_testFactory.create("\"" + string3 + "\"", string, "\"" + string2 + "\"");
        this.m_state.getJDMConnection().saveObject("\"" + this.m_uniqueTaskName + "\"", regressionTestTask, true);
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        AbstractActivity abstractActivity = this.m_state.getBrowserContext().getActivity();
        String string4 = abstractActivity.getName();
        dMEMetadata.insertTestRec(this.m_state.getConnection(), "\"" + string2 + "\"", "\"" + this.m_uniqueTaskName + "\"", string, string4);
        return "\"" + this.m_uniqueTaskName + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double computePredictiveConfidence(String string, String string2, String string3, Double d) throws Exception {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string4 = "select TARGET_ATTRIBUTE from DM_USER_MODELS where NAME = ?";
        String string5 = "select SQRT((count(*) / (count(*) - 1)) * variance(\"{0}\")) from \"{1}\".\"{2}\"";
        Double d2 = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            preparedStatement = connection.prepareStatement(string4);
            preparedStatement.setString(1, string.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            String string6 = null;
            if (resultSet.next()) {
                string6 = resultSet.getString(1);
            }
            preparedStatement.close();
            preparedStatement = null;
            resultSet.close();
            resultSet = null;
            double d3 = 0.0;
            double d4 = 0.0;
            if (string6 != null) {
                Object[] objectArray = new Object[]{DM4JStringUtils.trimDoubleQuotes(string6), DM4JStringUtils.trimDoubleQuotes(string2), DM4JStringUtils.trimDoubleQuotes(string3)};
                String string7 = MessageFormat.format(string5, objectArray);
                preparedStatement = connection.prepareStatement(string7);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    d3 = resultSet.getDouble(1);
                    double d5 = d;
                    d4 = 1.0 - d5 / d3;
                }
                d2 = new Double(Math.min(Math.max(0.0, d4), 1.0) * 100.0);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (null != preparedStatement) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return d2;
    }

    public void run() {
        try {
            this.getProgressBar().updateProgress(ResourceUtilities.getUILabel("MODEL_BUILD_UPPER_STEP_1"), null);
            String string = this.getMiningTask();
            this.m_isCancelable = false;
            ExecutionHandle executionHandle = this.m_state.getJDMConnection().execute(string);
            ExecutionStatus executionStatus = executionHandle.waitForCompletion(Integer.MAX_VALUE);
            if (executionStatus.getState().equals(ExecutionState.success)) {
                DataState dataState = (DataState)this.m_state.getStep(StepType.DATA_STEP);
                String string2 = dataState.getSelectedSchemaName();
                String string3 = dataState.getSelectedTableName();
                RegressionModelState regressionModelState = (RegressionModelState)this.m_state.getStep(StepType.MODEL_STEP);
                String string4 = regressionModelState.getSelectedModelName();
                ModelTestNameState modelTestNameState = (ModelTestNameState)this.m_state.getStep(StepType.NAME_STEP);
                String string5 = DM4JStringUtils.trimDoubleQuotes(modelTestNameState.getModelTestName());
                RegressionTestMetrics regressionTestMetrics = (RegressionTestMetrics)this.m_state.getJDMConnection().retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string5), NamedObject.testMetrics);
                Double d = RegressionModelTestBuilder.computePredictiveConfidence(string4, string2, string3, regressionTestMetrics.getRMSError());
                DMEMetadata dMEMetadata = DMEMetadata.getInstance();
                dMEMetadata.insertXformTableRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", string4, "XPCV", d + "");
            }
            this.m_state.setNewTaskName(string);
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            if (this.m_isCancelable) {
                this.cleanUp();
            }
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
    }
}

