/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.HashMap;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.supervised.regression.RegressionApplyContent;
import javax.datamining.supervised.regression.RegressionApplySettings;
import javax.datamining.supervised.regression.RegressionApplySettingsFactory;
import javax.datamining.task.apply.ApplySettings;
import javax.datamining.task.apply.DataSetApplyTask;
import javax.datamining.task.apply.DataSetApplyTaskFactory;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.director.minings.ModelApplyBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AppliedOutputTableState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyIDState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class RegressionModelResidualPlotBuilder
extends ModelApplyBuilder {
    public static String PREDICTION_COLUMN_NAME = "PREDICTION";
    protected RegressionApplySettingsFactory m_applySettingsFactory = null;
    private DataSetApplyTaskFactory m_applyFactory = null;
    private String m_settingName = null;
    private String m_uniqueTaskName = null;

    public RegressionModelResidualPlotBuilder(WizardState wizardState) {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        this.m_applySettingsFactory = (RegressionApplySettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.supervised.regression.RegressionApplySettings");
        this.m_applyFactory = (DataSetApplyTaskFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.task.apply.DataSetApplyTask");
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_settingName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_settingName + "\"", NamedObject.applySettings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.m_uniqueTaskName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_uniqueTaskName + "\"", NamedObject.task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            dMEMetadata.deletePlotsRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    protected String getMiningTask() throws Exception {
        ModelState modelState = (ModelState)this.m_state.getStep(StepType.MODEL_STEP);
        String string = modelState.getSelectedModelName();
        AppliedOutputTableState appliedOutputTableState = (AppliedOutputTableState)this.m_state.getStep(StepType.OUTPUT_DATA_STEP);
        String string2 = DM4JStringUtils.trimDoubleQuotes(appliedOutputTableState.getSelectedTableName());
        this.m_uniqueTaskName = ValidationUtil.createUniqueJDMObjectName("DM4J$" + string, this.m_state.getConnection(), "_J");
        String string3 = this.createPhysicalDataSpecification();
        ApplySettings applySettings = this.createApplySettings();
        this.addApplySourceAttributeItem(applySettings);
        this.addApplyMultipleScoringItem(applySettings);
        this.addApplyTargetProbabilityItem(applySettings);
        this.m_settingName = ValidationUtil.createUniqueJDMObjectName("DM4J$" + string, this.m_state.getConnection(), "_B");
        this.m_state.getJDMConnection().saveObject("\"" + this.m_settingName + "\"", applySettings, true);
        DataSetApplyTask dataSetApplyTask = this.m_applyFactory.create("\"" + string3 + "\"", string, "\"" + this.m_settingName + "\"", "\"" + string2 + "\"");
        this.m_state.getJDMConnection().saveObject("\"" + this.m_uniqueTaskName + "\"", dataSetApplyTask, true);
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        AbstractActivity abstractActivity = this.m_state.getBrowserContext().getActivity();
        dMEMetadata.insertPlotsRec(this.m_state.getConnection(), "\"" + string2 + "\"", "\"" + this.m_uniqueTaskName + "\"", string, abstractActivity != null ? abstractActivity.getName() : "DM4J$UNKNOWN");
        return "\"" + this.m_uniqueTaskName + "\"";
    }

    protected ApplySettings createApplySettings() throws Exception {
        RegressionApplySettings regressionApplySettings = this.m_applySettingsFactory.create();
        return regressionApplySettings;
    }

    protected void addApplySourceAttributeItem(ApplySettings applySettings) throws JDMException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ApplyIDState applyIDState = (ApplyIDState)this.m_state.getStep(StepType.APPLY_ID_STEP);
        Vector vector = applyIDState.getIDAttributes();
        String string = applyIDState.getSequenceIDName();
        for (String string2 : vector) {
            if (string == null || string2.compareTo(string) == 0) continue;
            String string3 = "\"" + string2 + "\"";
            hashMap.put(new String(string3), new String(string3));
        }
        if (!hashMap.isEmpty()) {
            applySettings.setSourceDestinationMap(hashMap);
        }
    }

    protected void addApplyMultipleScoringItem(ApplySettings applySettings) throws Exception {
        RegressionApplySettings regressionApplySettings = (RegressionApplySettings)applySettings;
        regressionApplySettings.map(RegressionApplyContent.predictedValue, PREDICTION_COLUMN_NAME);
    }
}

