/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.sql.Connection;
import javax.datamining.Enum;
import javax.datamining.NamedObject;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.supervised.SupervisedAlgorithmSettings;
import javax.datamining.supervised.regression.RegressionSettings;
import javax.datamining.supervised.regression.RegressionSettingsFactory;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.algorithm.glm.OraGLMRegressionSettings;
import oracle.dmt.jdm.algorithm.glm.OraGLMSettingsFactory;
import oracle.dmt.jdm.algorithm.svm.regression.OraSVMRegressionSettings;
import oracle.dmt.jdm.algorithm.svm.regression.OraSVMRegressionSettingsFactory;
import oracle.dmt.jdm.base.OraBuildSettings;

public class RegressionModelBuildBuilder
extends ModelBuildBuilder {
    private RegressionSettingsFactory m_regrFactory = (RegressionSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.supervised.regression.RegressionSettings");
    private OraSVMRegressionSettingsFactory m_svmFactory = (OraSVMRegressionSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.algorithm.svm.regression.SVMRegressionSettings");
    private OraGLMSettingsFactory m_glmFactory = (OraGLMSettingsFactory)this.m_state.getJDMConnection().getFactory("oracle.dmt.jdm.algorithm.glm.OraGLMSettings");
    private String m_settingName = null;

    public RegressionModelBuildBuilder(WizardState wizardState) throws Exception {
        super(wizardState);
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_settingName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_settingName + "\"", NamedObject.buildSettings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    private AlgorithmSettings buildAlgorithmSetting(RegressionAlgorithmState regressionAlgorithmState) throws Exception {
        SupervisedAlgorithmSettings supervisedAlgorithmSettings = null;
        if (regressionAlgorithmState.isSupportVectorMachineSelected()) {
            Number number;
            Comparable<Double> comparable;
            OraSVMRegressionSettings oraSVMRegressionSettings = (OraSVMRegressionSettings)this.m_svmFactory.create();
            if (regressionAlgorithmState.getSupportVectorMachine().isComplexityFactorSelected()) {
                comparable = regressionAlgorithmState.getSupportVectorMachine().getComplexityFactor();
                oraSVMRegressionSettings.setComplexityFactor((Double)comparable);
            }
            comparable = regressionAlgorithmState.getSupportVectorMachine().getKernelFunction();
            oraSVMRegressionSettings.setKernelFunction((KernelFunction)comparable);
            if (((Enum)comparable).equals(KernelFunction.kGaussian)) {
                number = regressionAlgorithmState.getSupportVectorMachine().getKernelCacheSize();
                oraSVMRegressionSettings.setKernelCacheSize((Integer)number * 1000000);
            }
            if (regressionAlgorithmState.getSupportVectorMachine().isStdSelected()) {
                number = regressionAlgorithmState.getSupportVectorMachine().getStd();
                oraSVMRegressionSettings.setStandardDeviation((Double)number);
            }
            number = regressionAlgorithmState.getSupportVectorMachine().getTolerance();
            oraSVMRegressionSettings.setTolerance((Double)number);
            if (regressionAlgorithmState.getSupportVectorMachine().isEpsilonSelected()) {
                Double d = regressionAlgorithmState.getSupportVectorMachine().getEpsilon();
                oraSVMRegressionSettings.setEpsilon(d);
            }
            oraSVMRegressionSettings.setActiveLearning(regressionAlgorithmState.getSupportVectorMachine().isLearningEnabled());
            supervisedAlgorithmSettings = oraSVMRegressionSettings;
        } else if (regressionAlgorithmState.isGeneralizedLinearModelSelected()) {
            Object object;
            OraGLMRegressionSettings oraGLMRegressionSettings = this.m_glmFactory.createGLMRegressionSettings();
            oraGLMRegressionSettings.setConfidenceLevel(regressionAlgorithmState.getGeneralizedLinearModel().getConfidenceLevel());
            if (regressionAlgorithmState.getGeneralizedLinearModel().isDiagnosticsTableEnabled()) {
                Connection connection = this.m_state.getConnection();
                try {
                    object = ValidationUtil.createUniqueTableName("DM4J$D", connection, "");
                    oraGLMRegressionSettings.setDiagnosticsTableName((String)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean bl = regressionAlgorithmState.getGeneralizedLinearModel().isRidgeRegressionEnabled();
            object = regressionAlgorithmState.getGeneralizedLinearModel().getRidgeValue();
            if (!bl) {
                oraGLMRegressionSettings.useRidgeRegression(false);
            } else if (object != null) {
                oraGLMRegressionSettings.useRidgeRegression(true);
                oraGLMRegressionSettings.setRidgeValue((Double)object);
                oraGLMRegressionSettings.produceVIFforRidgeRegression(regressionAlgorithmState.getGeneralizedLinearModel().isRidgeVIFEnabled());
            }
            supervisedAlgorithmSettings = oraGLMRegressionSettings;
        }
        return supervisedAlgorithmSettings;
    }

    protected String createFunctionSettings() throws Exception {
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        RegressionSettings regressionSettings = this.m_regrFactory.create();
        RegressionAlgorithmState regressionAlgorithmState = (RegressionAlgorithmState)this.m_state.getStep(StepType.ALGORITHM_STEP);
        AlgorithmSettings algorithmSettings = this.buildAlgorithmSetting(regressionAlgorithmState);
        if (regressionAlgorithmState.isGeneralizedLinearModelSelected()) {
            ((OraBuildSettings)((Object)regressionSettings)).useAutomatedDataPreparations(true);
        }
        regressionSettings.setAlgorithmSettings(algorithmSettings);
        TargetState targetState = (TargetState)this.m_state.getStep(StepType.TARGET_STEP);
        String string = targetState.getTargetAttribute();
        regressionSettings.setTargetAttributeName("\"" + string + "\"");
        this.m_settingName = DM4JStringUtils.trimDoubleQuotes(finishState.getMiningSettingsName());
        this.m_state.getJDMConnection().saveObject("\"" + this.m_settingName + "\"", regressionSettings, true);
        return this.m_settingName;
    }
}

