/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import javax.datamining.NamedObject;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.director.minings.MiningBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AppliedOutputTableState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SequenceAttributeState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.task.OraPredictTask;
import oracle.dmt.jdm.task.OraPredictTaskFactory;

public class PredictBuilder
extends MiningBuilder {
    private OraPredictTaskFactory m_predictFactory = null;
    private String m_uniqueTaskName = null;
    private String m_result = null;

    public PredictBuilder(WizardState wizardState) {
        super(wizardState);
    }

    public void construct() throws Exception {
        this.m_predictFactory = (OraPredictTaskFactory)this.m_state.getJDMConnection().getFactory("oracle.dmt.jdm.task.OraPredictTask");
    }

    protected String getMiningTask() throws Exception {
        String string;
        DataState dataState = (DataState)this.m_state.getStep(StepType.DATA_STEP);
        String string2 = DM4JStringUtils.trimDoubleQuotes(dataState.getSelectedSchemaName());
        String string3 = DM4JStringUtils.trimDoubleQuotes(dataState.getSelectedTableName());
        SequenceAttributeState sequenceAttributeState = (SequenceAttributeState)this.m_state.getStep(StepType.SEQ_ID_STEP);
        String string4 = sequenceAttributeState.getSequenceAttribute();
        TargetState targetState = (TargetState)this.m_state.getStep(StepType.TARGET_STEP);
        String string5 = targetState.getTargetAttribute();
        AppliedOutputTableState appliedOutputTableState = (AppliedOutputTableState)this.m_state.getStep(StepType.NAME_STEP);
        this.m_result = string = DM4JStringUtils.trimDoubleQuotes(appliedOutputTableState.getOutputTableName());
        this.m_uniqueTaskName = ValidationUtil.createUniqueJDMObjectName("DM4J$" + string, this.m_state.getConnection(), "_J");
        OraPredictTask oraPredictTask = this.m_predictFactory.create("\"" + string2 + "\"" + "." + "\"" + string3 + "\"", "\"" + string4 + "\"", "\"" + string5 + "\"", "\"" + string + "\"");
        this.m_state.getJDMConnection().saveObject("\"" + this.m_uniqueTaskName + "\"", oraPredictTask, true);
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        dMEMetadata.insertPredictRec(this.m_state.getConnection(), "\"" + string + "\"", "\"" + this.m_uniqueTaskName + "\"", "\"" + string3 + "\"");
        return "\"" + this.m_uniqueTaskName + "\"";
    }

    public String getTaskName() {
        return this.m_uniqueTaskName;
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_uniqueTaskName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_uniqueTaskName + "\"", NamedObject.task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            dMEMetadata.deletePredictRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", this.m_result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

