/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.datamining.MiningAlgorithm;
import javax.datamining.NamedObject;
import javax.datamining.base.BuildSettings;
import javax.datamining.base.Model;
import javax.datamining.base.Task;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalAttributeRole;
import javax.datamining.resource.Connection;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.director.minings.MiningLoader;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataPrepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SequenceAttributeState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetValueState;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.task.OraBuildTask;

public abstract class ModelBuildLoader
extends MiningLoader {
    protected BuildSettings m_mfs = null;
    protected LDSDataSource m_ds = null;

    protected ModelBuildLoader(WizardState wizardState, String string) {
        super(wizardState, string);
    }

    protected String findPDSForMiningObj(String string) throws Exception {
        String string2 = null;
        this.m_task = this.findTaskForMiningObj(string);
        if (this.m_task != null) {
            OraBuildTask oraBuildTask = (OraBuildTask)this.m_task;
            string2 = oraBuildTask.getBuildData().getURI();
            BrowserFrame browserFrame = BrowserFrame.getMainFrame();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            String string3 = null;
            String string4 = null;
            if (stringTokenizer.countTokens() == 2) {
                string3 = DM4JStringUtils.trimDoubleQuotes(stringTokenizer.nextToken());
                string4 = DM4JStringUtils.trimDoubleQuotes(stringTokenizer.nextToken());
            } else {
                string3 = DM4JStringUtils.trimDoubleQuotes(DM4JConnectionManager.getUser());
                string4 = DM4JStringUtils.trimDoubleQuotes(string2);
            }
            string2 = string3 + "." + string4;
            if (!DatabaseMetadata.datasourceExists(this.m_state.getConnection(), DM4JStringUtils.trimDoubleQuotes(string3), DM4JStringUtils.trimDoubleQuotes(string4))) {
                string2 = null;
            }
        }
        return string2;
    }

    protected Task findTaskForMiningObj(String string) {
        Task task = null;
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String string2 = dMEMetadata.getTaskNameForMiningObject(this.m_state.getConnection(), "BUILD", string);
            if (string2 != null) {
                task = (Task)this.m_state.getJDMConnection().retrieveObject(string2, NamedObject.task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return task;
    }

    public boolean validate() throws Exception {
        boolean bl = true;
        return bl;
    }

    public BuildSettings getMiningFunctionSettings() throws Exception {
        if (this.m_mfs == null) {
            Model model = (Model)this.getMiningObj();
            this.m_mfs = model.getBuildSettings();
        }
        return this.m_mfs;
    }

    public void buildLogicalDataSpecification(DataState dataState) throws Exception {
        if (this.m_ds == null) {
            boolean bl = false;
            Model model = (Model)this.getMiningObj();
            MiningAlgorithm miningAlgorithm = model.getMiningAlgorithm();
            if (miningAlgorithm != null && (miningAlgorithm.equals(MiningAlgorithm.svmClassification) || miningAlgorithm.equals(MiningAlgorithm.svmRegression) || miningAlgorithm.equals(OraMiningAlgorithm.nonNegativeMatrixFactorization))) {
                bl = true;
            }
            Connection connection = DM4JConnectionManager.getConnection();
            this.m_ds = new LDSDataSource(connection, (Model)this.getMiningObj(), bl, true);
            this.m_ds.run();
            dataState.setLDSDataSource(this.m_ds);
        }
    }

    public void buildModel(ModelState modelState) throws Exception {
        modelState.setSelectedModelName(this.getMiningObjName());
    }

    public void buildSequenceAttribute(SequenceAttributeState sequenceAttributeState) throws Exception {
        if (this.m_task != null) {
            OraBuildTask oraBuildTask = (OraBuildTask)this.m_task;
            Collection collection = oraBuildTask.getBuildData().getAttributes();
            Iterator iterator = collection.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                PhysicalAttribute physicalAttribute = (PhysicalAttribute)iterator.next();
                PhysicalAttributeRole physicalAttributeRole = physicalAttribute.getRole();
                if (!physicalAttributeRole.equals(PhysicalAttributeRole.caseId)) continue;
                sequenceAttributeState.syncSequenceAttribute(physicalAttribute.getName());
                bl = true;
                break;
            }
            sequenceAttributeState.setUseCaseId(bl);
        } else {
            sequenceAttributeState.setUseCaseId(false);
        }
    }

    public void buildDataPrep(DataPrepState dataPrepState) throws Exception {
    }

    public void buildTargetValue(TargetValueState targetValueState) throws Exception {
    }

    public void buildTargetAttribute(TargetState targetState) throws Exception {
    }
}

