/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.datamining.MiningFunction;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.base.Model;
import javax.datamining.base.Task;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalAttributeRole;
import javax.datamining.resource.Connection;
import javax.datamining.task.apply.ApplySettings;
import javax.datamining.task.apply.DataSetApplyTask;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.director.minings.MiningLoader;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AppliedOutputTableState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyIDState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyOutputOptionState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTestDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SequenceAttributeState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.jdm.OraMiningFunction;
import oracle.dmt.jdm.task.apply.OraDataSetApplyTask;

public abstract class ModelApplyLoader
extends MiningLoader {
    protected LDSDataSource m_dataLDS = null;
    protected LDSDataSource m_applyIdLDS = null;
    protected ApplySettings m_applySettings = null;

    protected ModelApplyLoader(WizardState wizardState, String string) {
        super(wizardState, string);
    }

    protected String findPDSForMiningObj(String string) throws Exception {
        String string2 = null;
        this.m_task = this.findTaskForMiningObj(string);
        if (this.m_task != null) {
            OraDataSetApplyTask oraDataSetApplyTask = (OraDataSetApplyTask)this.m_task;
            string2 = oraDataSetApplyTask.getApplyData().getURI();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            String string3 = null;
            String string4 = null;
            if (stringTokenizer.countTokens() == 2) {
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
            } else {
                string3 = DM4JConnectionManager.getUser();
                string4 = string2;
            }
            string2 = string3 + "." + string4;
            if (!DatabaseMetadata.datasourceExists(this.m_state.getConnection(), string3, string4)) {
                string2 = null;
            }
        }
        return string2;
    }

    protected Task findTaskForMiningObj(String string) {
        Task task = null;
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String string2 = dMEMetadata.getTaskNameForMiningObject(this.m_state.getConnection(), "APPLY", string);
            if (string2 != null) {
                task = (Task)this.m_state.getJDMConnection().retrieveObject(string2, NamedObject.task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return task;
    }

    protected ApplySettings getApplySettings() throws Exception {
        if (this.m_applySettings == null) {
            OraDataSetApplyTask oraDataSetApplyTask = (OraDataSetApplyTask)this.m_task;
            String string = oraDataSetApplyTask.getModelName();
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String string2 = dMEMetadata.getModelType(this.m_state.getConnection(), string);
            MiningFunction miningFunction = null;
            if (string2.equalsIgnoreCase("ASSOCIATION_RULES")) {
                miningFunction = MiningFunction.association;
            } else if (string2.equalsIgnoreCase("REGRESSION")) {
                miningFunction = MiningFunction.regression;
            } else if (string2.equalsIgnoreCase("CLASSIFICATION")) {
                miningFunction = MiningFunction.classification;
            } else if (string2.equalsIgnoreCase("ANOMALY_DETECTION")) {
                miningFunction = MiningFunction.classification;
            } else if (string2.equalsIgnoreCase("ATTRIBUTE_IMPORTANCE")) {
                miningFunction = MiningFunction.attributeImportance;
            } else if (string2.equalsIgnoreCase("FEATURE_EXTRACTION")) {
                miningFunction = OraMiningFunction.featureExtraction;
            } else if (string2.equalsIgnoreCase("CLUSTERING")) {
                miningFunction = MiningFunction.clustering;
            }
            this.m_applySettings = oraDataSetApplyTask.getApplySettings(miningFunction);
        }
        return this.m_applySettings;
    }

    protected MiningObject restoreMiningObject(String string) throws Exception {
        return null;
    }

    public boolean validate() throws Exception {
        boolean bl = true;
        return bl;
    }

    public void buildLogicalDataSpecification(DataState dataState) throws Exception {
        if (this.m_dataLDS == null) {
            DataSetApplyTask dataSetApplyTask = (DataSetApplyTask)this.m_task;
            String string = dataSetApplyTask.getModelName();
            Model model = (Model)this.m_state.getJDMConnection().retrieveObject(string, NamedObject.model);
            Connection connection = DM4JConnectionManager.getConnection();
            this.m_dataLDS = new LDSDataSource(connection, model);
            this.m_dataLDS.run();
            dataState.setLDSDataSource(this.m_dataLDS);
        }
    }

    public void buildApplySourceAttributes(ApplyIDState applyIDState) throws Exception {
        if (this.m_applyIdLDS == null) {
            ModelTestDataState modelTestDataState = (ModelTestDataState)this.m_state.getStep(StepType.DATA_STEP);
            LDSDataSource lDSDataSource = modelTestDataState.getLDSDataSource();
            applyIDState.setLDSDataSource(lDSDataSource);
            applyIDState.setAllAttributesToExclude();
            ApplySettings applySettings = this.getApplySettings();
            Map map = applySettings.getSourceDestinationMap();
            if (map != null) {
                Object[] objectArray = map.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = (String)objectArray[i];
                    for (int j = 0; j < lDSDataSource.getRowCount(); ++j) {
                        if (!lDSDataSource.getData(1, j).equals(string)) continue;
                        lDSDataSource.setData(0, j, new Boolean(true));
                    }
                }
            }
        }
    }

    public void buildApplyOption(ApplyOutputOptionState applyOutputOptionState) throws Exception {
    }

    public void buildAppliedOutputLocation(AppliedOutputTableState appliedOutputTableState) throws Exception {
        appliedOutputTableState.setSelectedTableName(this.m_table);
        appliedOutputTableState.setSelectedSchemaName(this.m_schema);
    }

    public void buildModel(ModelState modelState) throws Exception {
        DataSetApplyTask dataSetApplyTask = (DataSetApplyTask)this.m_task;
        String string = dataSetApplyTask.getModelName();
        modelState.setSelectedModelName(string);
    }

    public void buildSequenceAttribute(SequenceAttributeState sequenceAttributeState) throws Exception {
        OraDataSetApplyTask oraDataSetApplyTask = (OraDataSetApplyTask)this.m_task;
        Collection collection = oraDataSetApplyTask.getApplyData().getAttributes();
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            PhysicalAttribute physicalAttribute = (PhysicalAttribute)iterator.next();
            PhysicalAttributeRole physicalAttributeRole = physicalAttribute.getRole();
            if (!physicalAttributeRole.equals(PhysicalAttributeRole.caseId)) continue;
            sequenceAttributeState.syncSequenceAttribute(physicalAttribute.getName());
            bl = true;
            break;
        }
        sequenceAttributeState.setUseCaseId(bl);
    }
}

