/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.datamining.JDMException;
import javax.datamining.NamedObject;
import javax.datamining.task.apply.ApplySettings;
import javax.datamining.task.apply.DataSetApplyTask;
import javax.datamining.task.apply.DataSetApplyTaskFactory;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.AbstractApplyActivity;
import oracle.dmt.dm4j.activity.data.Column;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.director.minings.MiningBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AppliedOutputTableState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public abstract class ModelApplyBuilder
extends MiningBuilder {
    private DataSetApplyTaskFactory m_applyFactory = null;
    private String m_settingName = null;
    private String m_uniqueTaskName = null;

    protected ModelApplyBuilder(WizardState wizardState) {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        this.m_applyFactory = (DataSetApplyTaskFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.task.apply.DataSetApplyTask");
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_settingName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_settingName + "\"", NamedObject.applySettings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.m_uniqueTaskName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_uniqueTaskName + "\"", NamedObject.task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            dMEMetadata.deleteApplyRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    protected String getMiningTask() throws Exception {
        ModelState modelState = (ModelState)this.m_state.getStep(StepType.MODEL_STEP);
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        String string = modelState.getSelectedModelName();
        AppliedOutputTableState appliedOutputTableState = (AppliedOutputTableState)this.m_state.getStep(StepType.OUTPUT_DATA_STEP);
        String string2 = DM4JStringUtils.trimDoubleQuotes(appliedOutputTableState.getOutputTableName());
        this.m_uniqueTaskName = ValidationUtil.createUniqueJDMObjectName("DM4J$" + string, this.m_state.getConnection(), "_J");
        String string3 = this.createPhysicalDataSpecification();
        ApplySettings applySettings = this.createApplySettings();
        this.addApplySourceAttributeItem(applySettings);
        this.addApplyMultipleScoringItem(applySettings);
        this.addApplyTargetProbabilityItem(applySettings);
        this.m_settingName = DM4JStringUtils.trimDoubleQuotes(finishState.getMiningSettingsName());
        this.m_state.getJDMConnection().saveObject("\"" + this.m_settingName + "\"", applySettings, true);
        DataSetApplyTask dataSetApplyTask = this.m_applyFactory.create("\"" + string3 + "\"", string, "\"" + this.m_settingName + "\"", "\"" + string2 + "\"");
        this.m_state.getJDMConnection().saveObject("\"" + this.m_uniqueTaskName + "\"", dataSetApplyTask, true);
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        AbstractActivity abstractActivity = this.m_state.getBrowserContext().getActivity();
        String string4 = abstractActivity.getName();
        dMEMetadata.insertApplyRec(this.m_state.getConnection(), "\"" + string2 + "\"", "\"" + this.m_uniqueTaskName + "\"", string, string4);
        return "\"" + this.m_uniqueTaskName + "\"";
    }

    protected abstract ApplySettings createApplySettings() throws Exception;

    protected void addApplySourceAttributeItem(ApplySettings applySettings) throws JDMException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AbstractApplyActivity abstractApplyActivity = (AbstractApplyActivity)this.m_state.getBrowserContext().getActivity();
        Vector vector = abstractApplyActivity.getSupplementalTables();
        for (int i = 0; i < vector.size(); ++i) {
            Table table = (Table)vector.get(i);
            LinkedHashMap linkedHashMap = table.getColumns();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                Column column = (Column)entry.getValue();
                if (!column.getIsInput()) continue;
                String string = column.getAlias();
                String string2 = "\"" + string + "\"";
                hashMap.put(new String(string2), new String(string2));
            }
        }
        if (!hashMap.isEmpty()) {
            applySettings.setSourceDestinationMap(hashMap);
        }
    }

    protected void addApplyTargetProbabilityItem(ApplySettings applySettings) throws Exception {
    }

    protected void addApplyMultipleScoringItem(ApplySettings applySettings) throws Exception {
    }
}

