/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.Vector;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.base.Model;
import javax.datamining.clustering.ClusteringModel;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildLoader;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClusteringAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.algorithm.kmeans.OraKMeansSettings;
import oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettings;

public class ClusteringModelBuildLoader
extends ModelBuildLoader {
    public ClusteringModelBuildLoader(WizardState wizardState, String string) {
        super(wizardState, string);
    }

    protected MiningObject restoreMiningObject(String string) throws Exception {
        ClusteringModel clusteringModel = (ClusteringModel)this.m_state.getJDMConnection().retrieveObject(string, NamedObject.model);
        return clusteringModel;
    }

    public boolean validate() throws Exception {
        Vector vector = new Vector();
        this.m_state.getStep(StepType.DATA_STEP).load();
        ModelDataState modelDataState = (ModelDataState)this.m_state.getStep(StepType.DATA_STEP);
        boolean bl = this.m_state.synchronize(vector, modelDataState);
        if (ValidationUtil.validationsContainsErrors(vector)) {
            DialogUtilities.displayValidations(vector, null, this.m_state.getDialog());
        }
        return bl;
    }

    public void buildAlgorithmSetting(ClusteringAlgorithmState clusteringAlgorithmState) throws Exception {
        Model model = (Model)this.getMiningObj();
        AlgorithmSettings algorithmSettings = this.getMiningFunctionSettings().getAlgorithmSettings();
        MiningAlgorithm miningAlgorithm = model.getMiningAlgorithm();
        if (miningAlgorithm.equals(MiningAlgorithm.kMeans)) {
            OraKMeansSettings oraKMeansSettings = (OraKMeansSettings)algorithmSettings;
            int n = oraKMeansSettings.getMaxNumberOfIterations();
            double d = oraKMeansSettings.getMinErrorTolerance();
        } else if (miningAlgorithm.equals(OraMiningAlgorithm.oCluster)) {
            OraOClusterSettings oraOClusterSettings = (OraOClusterSettings)algorithmSettings;
            double d = oraOClusterSettings.getSensitivity();
            long l = oraOClusterSettings.getBufferSize();
        }
    }
}

