/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.HashMap;
import javax.datamining.clustering.ClusteringApplyContent;
import javax.datamining.clustering.ClusteringApplySettings;
import javax.datamining.clustering.ClusteringApplySettingsFactory;
import javax.datamining.task.apply.ApplySettings;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.wizard.director.minings.ModelApplyBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClusteringApplyOutputOptionState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;

public class ClusteringModelApplyBuilder
extends ModelApplyBuilder {
    public static String CLUSTER_ID_COLUMN_NAME = "CLUSTER_ID";
    public static String DISTANCE_COLUMN_NAME = "DIST";
    public static String FIT_COLUMN_NAME = "FIT";
    protected ClusteringApplySettingsFactory m_applySettingsFactory = null;

    public ClusteringModelApplyBuilder(WizardState wizardState) {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        this.m_applySettingsFactory = (ClusteringApplySettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.clustering.ClusteringApplySettings");
    }

    protected ApplySettings createApplySettings() throws Exception {
        ClusteringApplySettings clusteringApplySettings = this.m_applySettingsFactory.create();
        return clusteringApplySettings;
    }

    protected void addApplyMultipleScoringItem(ApplySettings applySettings) throws Exception {
        ClusteringApplySettings clusteringApplySettings = (ClusteringApplySettings)applySettings;
        ClusteringApplyOutputOptionState clusteringApplyOutputOptionState = (ClusteringApplyOutputOptionState)this.m_state.getStep(StepType.APPLY_OPTION_STEP);
        if (!clusteringApplyOutputOptionState.isSpecificPredictions()) {
            boolean bl = true;
            bl = true;
            int n = clusteringApplyOutputOptionState.getNumberOfTopNPredictions();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "Top_" + i + "_Prediction";
            }
            clusteringApplySettings.mapByRank(ClusteringApplyContent.clusterIdentifier, stringArray, bl);
        }
    }

    protected void addApplyTargetProbabilityItem(ApplySettings applySettings) throws Exception {
        ClusteringApplySettings clusteringApplySettings = (ClusteringApplySettings)applySettings;
        ClusteringApplyOutputOptionState clusteringApplyOutputOptionState = (ClusteringApplyOutputOptionState)this.m_state.getStep(StepType.APPLY_OPTION_STEP);
        if (clusteringApplyOutputOptionState.isSpecificPredictions()) {
            HashMap hashMap = clusteringApplyOutputOptionState.getClusterPredictionColumns(true);
            for (Integer n : hashMap.keySet()) {
                String string = (String)hashMap.get(n);
                string = DM4JStringUtils.trimDoubleQuotes(string);
                clusteringApplySettings.mapByClusterIdentifier(ClusteringApplyContent.probability, n, "\"" + CLUSTER_ID_COLUMN_NAME + "_" + string + "\"");
                clusteringApplySettings.mapByClusterIdentifier(ClusteringApplyContent.distance, n, "\"" + DISTANCE_COLUMN_NAME + "_" + string + "\"");
                clusteringApplySettings.mapByClusterIdentifier(ClusteringApplyContent.qualityOfFit, n, "\"" + FIT_COLUMN_NAME + "_" + string + "\"");
            }
        }
    }
}

