/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.math.BigDecimal;
import java.util.Vector;
import javax.datamining.NamedObject;
import javax.datamining.supervised.classification.ClassificationApplySettings;
import javax.datamining.supervised.classification.CostMatrix;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.director.minings.ModelApplyLoader;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyTargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationApplyOutputOptionState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTestDataState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.supervised.classification.OraClassificationModel;
import oracle.dmt.jdm.task.apply.OraDataSetApplyTask;

public class ClassificationModelApplyLoader
extends ModelApplyLoader {
    public ClassificationModelApplyLoader(WizardState wizardState, String string) {
        super(wizardState, string);
    }

    public void buildApplyOption(ClassificationApplyOutputOptionState classificationApplyOutputOptionState) throws Exception {
        Object[] objectArray;
        OraDataSetApplyTask oraDataSetApplyTask = (OraDataSetApplyTask)this.getMiningTask();
        ClassificationApplySettings classificationApplySettings = (ClassificationApplySettings)this.getApplySettings();
        Integer n = classificationApplySettings.getRanks();
        if (n != null) {
            classificationApplyOutputOptionState.setTopNPredictions(classificationApplySettings.isFromTop());
            classificationApplyOutputOptionState.setNumberOfTopNPredictions(n);
            classificationApplyOutputOptionState.setNumberOfBottomNPredictions(n);
        }
        if ((objectArray = classificationApplySettings.getMappedCategories()) != null && objectArray.length > 0) {
            classificationApplyOutputOptionState.setSpecificPredictions(true);
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof BigDecimal) {
                    vector.add(new Integer(((BigDecimal)object).intValue()));
                    continue;
                }
                vector.add((String)object);
            }
            classificationApplyOutputOptionState.setListOfSpecificPredictionValues(vector);
        }
    }

    public void buildModel(ClassificationModelState classificationModelState) throws Exception {
        OraClassificationModel oraClassificationModel = (OraClassificationModel)classificationModelState.getSelectedMiningModel();
        if (oraClassificationModel != null) {
            classificationModelState.setNumberOfPriors(oraClassificationModel.getTargetCategorySet().getSize() + "");
        }
    }

    public void buildCostMatrix(ApplyTargetValueState applyTargetValueState) throws Exception {
        OraDataSetApplyTask oraDataSetApplyTask = (OraDataSetApplyTask)this.getMiningTask();
        ClassificationApplySettings classificationApplySettings = (ClassificationApplySettings)this.getApplySettings();
        String string = classificationApplySettings.getCostMatrixName();
        if (string != null) {
            CostMatrix costMatrix = (CostMatrix)this.m_state.getJDMConnection().retrieveObject(string, NamedObject.costMatrix);
            applyTargetValueState.setWeightedScoreIndicator(true);
            applyTargetValueState.setFalsePositiveIndicator(false);
            applyTargetValueState.setWeight("1.0");
            TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(new Vector(costMatrix.getCategories()));
            targetValueCostMatrixDataSource.run();
            targetValueCostMatrixDataSource.setCostMatrix(costMatrix);
            applyTargetValueState.setTargetValueCostMatrix(targetValueCostMatrixDataSource);
        }
    }

    public boolean validate() throws Exception {
        Vector vector = new Vector();
        this.m_state.getStep(StepType.MODEL_STEP).load();
        this.m_state.getStep(StepType.DATA_STEP).load();
        this.m_state.getStep(StepType.APPLY_ID_STEP).load();
        this.m_state.getStep(StepType.APPLY_OPTION_STEP).load();
        ModelTestDataState modelTestDataState = (ModelTestDataState)this.m_state.getStep(StepType.DATA_STEP);
        boolean bl = this.m_state.synchronize(vector, modelTestDataState);
        if (ValidationUtil.validationsContainsErrors(vector)) {
            DialogUtilities.displayValidations(vector, null, this.m_state.getDialog());
        }
        return bl;
    }
}

